/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.Validate;

public class Tetrahedron
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(Tetrahedron.class.getName());

    protected Tetrahedron() {
    }

    public Tetrahedron(float radius, boolean generateNormals) {
        Validate.positive(radius, "radius");
        float h = radius / FastMath.sqrt((float)3.0f);
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((float[])new float[]{-h, h, h, h, h, -h, -h, -h, -h, -h, h, h, h, -h, h, h, h, -h, -h, h, h, -h, -h, -h, h, -h, h, -h, -h, -h, h, h, -h, h, -h, h});
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        positionBuffer.clear();
        if (generateNormals) {
            MyMesh.generateNormals(this);
        }
        this.updateBound();
        this.setStatic();
    }
}

