/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.MyControl;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class MySkeleton {
    private static final Logger logger = Logger.getLogger(MySkeleton.class.getName());
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);

    private MySkeleton() {
    }

    public static void cancelAttachments(Bone bone) {
        Field attachNodeField;
        try {
            attachNodeField = Bone.class.getDeclaredField("attachNode");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        attachNodeField.setAccessible(true);
        try {
            attachNodeField.set(bone, null);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static void cancelAttachments(Joint joint) {
        Field attachedNodeField;
        try {
            attachedNodeField = Joint.class.getDeclaredField("attachedNode");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        attachedNodeField.setAccessible(true);
        try {
            attachedNodeField.set(joint, null);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Transform copyBindTransform(Bone bone, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f translation = bone.getBindPosition();
        result.setTranslation(translation);
        Quaternion rotation = bone.getBindRotation();
        result.setRotation(rotation);
        Vector3f scale = bone.getBindScale();
        if (scale == null) {
            scale = scaleIdentity;
        }
        result.setScale(scale);
        return result;
    }

    public static Transform copyLocalTransform(Bone bone, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f translation = bone.getLocalPosition();
        result.setTranslation(translation);
        Quaternion rotation = bone.getLocalRotation();
        result.setRotation(rotation);
        Vector3f scale = bone.getLocalScale();
        result.setScale(scale);
        return result;
    }

    public static Transform copyMeshTransform(Bone bone, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f translation = bone.getModelSpacePosition();
        result.setTranslation(translation);
        Quaternion rotation = bone.getModelSpaceRotation();
        result.setRotation(rotation);
        Vector3f scale = bone.getModelSpaceScale();
        result.setScale(scale);
        return result;
    }

    public static int countLeafBones(Skeleton skeleton) {
        int boneCount = skeleton.getBoneCount();
        int result = 0;
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            Bone bone = skeleton.getBone(boneIndex);
            ArrayList children = bone.getChildren();
            if (!children.isEmpty()) continue;
            ++result;
        }
        return result;
    }

    public static int countRootBones(Skeleton skeleton) {
        Bone[] roots = skeleton.getRoots();
        int result = roots.length;
        return result;
    }

    public static int countRootJoints(Armature armature) {
        Joint[] roots = armature.getRoots();
        int result = roots.length;
        return result;
    }

    public static boolean descendsFrom(int boneIndex, int ancestorIndex, Skeleton skeleton) {
        Validate.nonNegative(boneIndex, "bone index");
        Validate.nonNegative(ancestorIndex, "ancestor index");
        Bone bone = skeleton.getBone(boneIndex);
        Bone ancestor = skeleton.getBone(ancestorIndex);
        while (bone != null) {
            if ((bone = bone.getParent()) != ancestor) continue;
            return true;
        }
        return false;
    }

    public static Bone findBone(Spatial spatial, String boneName) {
        Validate.nonNull(spatial, "spatial");
        Validate.nonNull(boneName, "bone name");
        Bone result = null;
        int numControls = spatial.getNumControls();
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = spatial.getControl(controlIndex);
            Skeleton skeleton = MyControl.findSkeleton(control);
            if (skeleton == null) continue;
            result = skeleton.getBone(boneName);
            break;
        }
        return result;
    }

    public static Skeleton findSkeleton(Spatial spatial) {
        SkeletonControl skeletonControl;
        Skeleton skeleton = null;
        AnimControl animControl = (AnimControl)spatial.getControl(AnimControl.class);
        if (animControl != null) {
            skeleton = animControl.getSkeleton();
        }
        if (skeleton == null && (skeletonControl = (SkeletonControl)spatial.getControl(SkeletonControl.class)) != null) {
            skeleton = skeletonControl.getSkeleton();
        }
        return skeleton;
    }

    public static Node getAttachments(Bone bone) {
        Node result;
        Field attachNodeField;
        try {
            attachNodeField = Bone.class.getDeclaredField("attachNode");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        attachNodeField.setAccessible(true);
        try {
            result = (Node)attachNodeField.get(bone);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static Node getAttachments(Joint joint) {
        Node result;
        Field attachedNodeField;
        try {
            attachedNodeField = Joint.class.getDeclaredField("attachedNode");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        attachedNodeField.setAccessible(true);
        try {
            result = (Node)attachedNodeField.get(joint);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static Geometry getTargetGeometry(Joint joint) {
        Geometry result;
        Field attachNodeField;
        try {
            attachNodeField = Joint.class.getDeclaredField("targetGeometry");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        attachNodeField.setAccessible(true);
        try {
            result = (Geometry)attachNodeField.get(joint);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static List<Armature> listArmatures(Spatial subtree, List<Armature> addResult) {
        Validate.nonNull(subtree, "subtree");
        ArrayList<Armature> result = addResult == null ? new ArrayList<Armature>(4) : addResult;
        int numSgcs = subtree.getNumControls();
        for (int sgcIndex = 0; sgcIndex < numSgcs; ++sgcIndex) {
            Armature armature;
            Control sgc = subtree.getControl(sgcIndex);
            if (!(sgc instanceof SkinningControl) || (armature = ((SkinningControl)sgc).getArmature()) == null || result.contains(armature)) continue;
            result.add(armature);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySkeleton.listArmatures(child, result);
            }
        }
        return result;
    }

    public static List<String> listBones(Skeleton skeleton, List<String> addResult) {
        int boneCount = skeleton.getBoneCount();
        ArrayList<String> result = addResult == null ? new ArrayList<String>(boneCount) : addResult;
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            String name;
            Bone bone = skeleton.getBone(boneIndex);
            if (bone == null || (name = bone.getName()) == null || result.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    public static List<String> listBones(Spatial spatial) {
        ArrayList<String> result = new ArrayList<String>(80);
        int numControls = spatial.getNumControls();
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = spatial.getControl(controlIndex);
            Skeleton skeleton = MyControl.findSkeleton(control);
            if (skeleton == null) continue;
            MySkeleton.listBones(skeleton, result);
        }
        Collections.sort(result);
        return result;
    }

    public static List<Skeleton> listSkeletons(Spatial subtree, List<Skeleton> addResult) {
        Validate.nonNull(subtree, "subtree");
        ArrayList<Skeleton> result = addResult == null ? new ArrayList<Skeleton>(4) : addResult;
        int numControls = subtree.getNumControls();
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = subtree.getControl(controlIndex);
            Skeleton skeleton = MyControl.findSkeleton(control);
            if (skeleton == null || result.contains(skeleton)) continue;
            result.add(skeleton);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySkeleton.listSkeletons(child, result);
            }
        }
        return result;
    }

    public static Map<Bone, Spatial> mapAttachments(Skeleton skeleton, Map<Bone, Spatial> storeResult) {
        Validate.nonNull(skeleton, "skeleton");
        HashMap<Bone, Spatial> result = storeResult == null ? new HashMap<Bone, Spatial>(4) : storeResult;
        int numBones = skeleton.getBoneCount();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Bone bone = skeleton.getBone(boneIndex);
            Node attachmentsNode = MySkeleton.getAttachments(bone);
            if (attachmentsNode == null) continue;
            if (result.containsKey(bone)) {
                if (result.get(bone) == attachmentsNode) continue;
                String m = "bone " + MyString.quote(bone.getName());
                throw new IllegalArgumentException(m);
            }
            result.put(bone, (Spatial)attachmentsNode);
        }
        return result;
    }

    public static Map<Bone, Spatial> mapAttachments(Spatial subtree, Map<Bone, Spatial> storeResult) {
        Validate.nonNull(subtree, "subtree");
        HashMap<Bone, Spatial> result = storeResult == null ? new HashMap<Bone, Spatial>(4) : storeResult;
        List<SkeletonControl> list = MySpatial.listControls(subtree, SkeletonControl.class, null);
        for (SkeletonControl control : list) {
            Skeleton skeleton = control.getSkeleton();
            MySkeleton.mapAttachments(skeleton, result);
        }
        return result;
    }

    public static List<Bone> preOrderBones(Skeleton skeleton) {
        Bone[] rootBones;
        int numBones = skeleton.getBoneCount();
        ArrayList<Bone> result = new ArrayList<Bone>(numBones);
        for (Bone rootBone : rootBones = skeleton.getRoots()) {
            MySkeleton.addPreOrderBones(rootBone, result);
        }
        assert (result.size() == numBones) : result.size();
        return result;
    }

    public static List<Joint> preOrderJoints(Armature armature) {
        Joint[] rootJoints;
        int numJoints = armature.getJointCount();
        ArrayList<Joint> result = new ArrayList<Joint>(numJoints);
        for (Joint rootJoint : rootJoints = armature.getRoots()) {
            MySkeleton.addPreOrderJoints(rootJoint, result);
        }
        assert (result.size() == numJoints) : result.size();
        return result;
    }

    public static boolean setName(Bone bone, String newName) {
        Field nameField;
        try {
            nameField = Bone.class.getDeclaredField("name");
        }
        catch (NoSuchFieldException exception) {
            return false;
        }
        nameField.setAccessible(true);
        try {
            nameField.set(bone, newName);
        }
        catch (IllegalAccessException exception) {
            return false;
        }
        Node attachmentsNode = MySkeleton.getAttachments(bone);
        if (attachmentsNode != null) {
            String newNodeName = newName + "_attachnode";
            attachmentsNode.setName(newNodeName);
        }
        return true;
    }

    public static void setLocalTransform(Bone bone, Transform transform) {
        boolean hadControl = bone.hasUserControl();
        if (!hadControl) {
            bone.setUserControl(true);
        }
        Vector3f translation = transform.getTranslation();
        bone.setLocalTranslation(translation);
        Quaternion rotation = transform.getRotation();
        bone.setLocalRotation(rotation);
        Vector3f scale = transform.getScale();
        bone.setLocalScale(scale);
        if (!hadControl) {
            bone.setUserControl(false);
        }
    }

    public static void setUserControl(Skeleton skeleton, boolean newSetting) {
        int boneCount = skeleton.getBoneCount();
        for (int boneIndex = 0; boneIndex < boneCount; ++boneIndex) {
            Bone bone = skeleton.getBone(boneIndex);
            bone.setUserControl(newSetting);
        }
    }

    public static void setUserControl(Spatial subtree, boolean newSetting) {
        Validate.nonNull(subtree, "spatial");
        List<Skeleton> skeletons = MySkeleton.listSkeletons(subtree, null);
        for (Skeleton skeleton : skeletons) {
            MySkeleton.setUserControl(skeleton, newSetting);
        }
    }

    private static void addPreOrderBones(Bone bone, List<Bone> addResult) {
        assert (bone != null);
        addResult.add(bone);
        ArrayList children = bone.getChildren();
        for (Bone child : children) {
            MySkeleton.addPreOrderBones(child, addResult);
        }
    }

    private static void addPreOrderJoints(Joint joint, List<Joint> addResult) {
        assert (joint != null);
        addResult.add(joint);
        List children = joint.getChildren();
        for (Joint child : children) {
            MySkeleton.addPreOrderJoints(child, addResult);
        }
    }
}

