/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.anim.SkinningControl;
import com.jme3.animation.SkeletonControl;
import com.jme3.app.StatsView;
import com.jme3.asset.AssetManager;
import com.jme3.audio.AudioNode;
import com.jme3.effect.ParticleEmitter;
import com.jme3.font.BitmapText;
import com.jme3.light.Light;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.AssetLinkNode;
import com.jme3.scene.BatchNode;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.GeometryGroupNode;
import com.jme3.scene.LightNode;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SimpleBatchNode;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.scene.debug.SkeletonDebugger;
import com.jme3.scene.instancing.InstancedGeometry;
import com.jme3.scene.instancing.InstancedNode;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import com.jme3.ui.Picture;
import com.jme3.util.SafeArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyControl;
import jme3utilities.MyMesh;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class MySpatial {
    private static final Logger logger = Logger.getLogger(MySpatial.class.getName());

    private MySpatial() {
    }

    public static <T extends Control> int countControls(Spatial subtree, Class<T> controlType) {
        int result = 0;
        if (subtree != null) {
            int numControls = subtree.getNumControls();
            for (int controlI = 0; controlI < numControls; ++controlI) {
                Control control = subtree.getControl(controlI);
                if (!controlType.isAssignableFrom(control.getClass())) continue;
                ++result;
            }
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                result += MySpatial.countControls(child, controlType);
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static int countMeshBones(Spatial subtree) {
        int result = 0;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            result = MyMesh.countBones(mesh);
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                int childBones = MySpatial.countMeshBones(child);
                if (childBones <= result) continue;
                result = childBones;
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static <T extends Spatial> int countSpatials(Spatial subtree, Class<T> spatialType) {
        int result = 0;
        if (subtree != null && spatialType.isAssignableFrom(subtree.getClass())) {
            ++result;
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                result += MySpatial.countSpatials(child, spatialType);
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static int countUserData(Spatial subtree) {
        int result = 0;
        if (subtree != null) {
            Collection keys = subtree.getUserDataKeys();
            result += keys.size();
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                result += MySpatial.countUserData(child);
            }
        }
        assert (result >= 0) : result;
        return result;
    }

    public static int countUses(Spatial subtree, Material material) {
        int count = 0;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Material mat = geometry.getMaterial();
            if (mat == material) {
                ++count;
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                count += MySpatial.countUses(child, material);
            }
        }
        return count;
    }

    public static int countVertices(Spatial subtree) {
        int result = 0;
        List<Mesh> meshes = MyMesh.listMeshes(subtree, null);
        for (Mesh mesh : meshes) {
            result += mesh.getVertexCount();
        }
        assert (result >= 0) : result;
        return result;
    }

    public static char describeType(Spatial spatial) {
        if (spatial instanceof AssetLinkNode) {
            return 'A';
        }
        if (spatial instanceof AudioNode) {
            return 'a';
        }
        if (spatial instanceof BatchNode) {
            return 'b';
        }
        if (spatial instanceof BitmapText) {
            return 't';
        }
        if (spatial instanceof CameraNode) {
            return 'c';
        }
        if (spatial instanceof GeometryGroupNode) {
            return 'G';
        }
        if (spatial instanceof InstancedGeometry) {
            return 'i';
        }
        if (spatial instanceof InstancedNode) {
            return 'N';
        }
        if (spatial instanceof LightNode) {
            return 'L';
        }
        if (spatial instanceof ParticleEmitter) {
            return 'e';
        }
        if (spatial instanceof Picture) {
            return 'p';
        }
        if (spatial instanceof SimpleBatchNode) {
            return 'B';
        }
        if (spatial instanceof SkeletonDebugger) {
            return 's';
        }
        if (spatial instanceof StatsView) {
            return 'S';
        }
        if (spatial.getClass().getSimpleName().equals("TerrainQuad")) {
            return 'q';
        }
        if (spatial instanceof Geometry) {
            return 'g';
        }
        if (spatial instanceof Node) {
            return 'n';
        }
        return '?';
    }

    public static Geometry findAnimatedGeometry(Spatial subtree) {
        Geometry result;
        block3: {
            block2: {
                result = null;
                if (!(subtree instanceof Geometry)) break block2;
                Geometry geometry = (Geometry)subtree;
                Mesh mesh = geometry.getMesh();
                if (!MyMesh.isAnimated(mesh)) break block3;
                result = geometry;
                break block3;
            }
            if (subtree instanceof Node) {
                Spatial child;
                Node node = (Node)subtree;
                List children = node.getChildren();
                Iterator iterator = children.iterator();
                while (iterator.hasNext() && (result = MySpatial.findAnimatedGeometry(child = (Spatial)iterator.next())) == null) {
                }
            }
        }
        return result;
    }

    public static <T extends Spatial> T findChild(Node node, Class<T> spatialType) {
        for (Spatial child : node.getChildren()) {
            if (!spatialType.isAssignableFrom(child.getClass())) continue;
            return (T)child;
        }
        return null;
    }

    public static Spatial findChild(Node node, String childName) {
        Validate.nonNull(childName, "child name");
        for (Spatial child : node.getChildren()) {
            String name = child.getName();
            if (!childName.equals(name)) continue;
            return child;
        }
        return null;
    }

    public static Spatial findControlledSpatial(Control sgc, Spatial subtree) {
        Spatial result;
        block2: {
            Spatial child;
            block3: {
                Validate.nonNull(sgc, "control");
                Validate.nonNull(subtree, "subtree");
                result = null;
                if (sgc instanceof AbstractControl) {
                    AbstractControl abstractControl = (AbstractControl)sgc;
                    result = abstractControl.getSpatial();
                }
                if (result != null) break block2;
                int sgcIndex = MyControl.findIndex(sgc, subtree);
                if (sgcIndex == -1) break block3;
                result = subtree;
                break block2;
            }
            if (!(subtree instanceof Node)) break block2;
            Node node = (Node)subtree;
            List children = node.getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && (result = MySpatial.findControlledSpatial(sgc, child = (Spatial)iterator.next())) == null) {
            }
        }
        return result;
    }

    @Deprecated
    public static int findIndex(Spatial spatial, Control sgc) {
        Validate.nonNull(spatial, "spatial");
        Validate.nonNull(sgc, "control");
        int numControls = spatial.getNumControls();
        int result = -1;
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = spatial.getControl(controlIndex);
            if (control != sgc) continue;
            result = controlIndex;
            break;
        }
        return result;
    }

    public static <T extends Light> T findLight(Spatial spatial, Class<T> lightClass) {
        Validate.nonNull(lightClass, "light class");
        for (Light light : spatial.getLocalLightList()) {
            if (!lightClass.isAssignableFrom(light.getClass())) continue;
            return (T)light;
        }
        return null;
    }

    public static Light findLight(Spatial spatial, String lightName) {
        Validate.nonNull(lightName, "light name");
        for (Light light : spatial.getLocalLightList()) {
            String name = light.getName();
            if (!lightName.equals(name)) continue;
            return light;
        }
        return null;
    }

    public static Vector3f[] findMinMaxCoords(Geometry geometry, boolean useWorld) {
        Vector3f max = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f min = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f[] result = new Vector3f[]{min, max};
        Vector3f meshLocation = new Vector3f();
        Vector3f location = new Vector3f();
        Mesh mesh = geometry.getMesh();
        int numVertices = mesh.getVertexCount();
        for (int vertexIndex = 0; vertexIndex < numVertices; ++vertexIndex) {
            MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexIndex, meshLocation);
            if (useWorld && !geometry.isIgnoreTransform()) {
                geometry.localToWorld(meshLocation, location);
            } else {
                location.set(meshLocation);
            }
            MyVector3f.accumulateMinima(min, location);
            MyVector3f.accumulateMaxima(max, location);
        }
        return result;
    }

    public static Vector3f[] findMinMaxCoords(Spatial subtree) {
        Vector3f[] result;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            result = MySpatial.findMinMaxCoords(geometry, true);
        } else if (subtree instanceof Node) {
            Vector3f maxima = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
            Vector3f minima = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
            result = new Vector3f[]{minima, maxima};
            Node node = (Node)subtree;
            for (Spatial child : node.getChildren()) {
                Vector3f[] childMm = MySpatial.findMinMaxCoords(child);
                MyVector3f.accumulateMinima(minima, childMm[0]);
                MyVector3f.accumulateMaxima(maxima, childMm[1]);
            }
        } else {
            throw new IllegalArgumentException("spatial should be a geometry or a node");
        }
        return result;
    }

    public static Spatial findNamed(Spatial subtree, String name) {
        Spatial result;
        block2: {
            Spatial child;
            block1: {
                result = null;
                String spatialName = subtree.getName();
                if (!name.equals(spatialName)) break block1;
                result = subtree;
                break block2;
            }
            if (!(subtree instanceof Node)) break block2;
            Node node = (Node)subtree;
            List children = node.getChildren();
            Iterator iterator = children.iterator();
            while (iterator.hasNext() && (result = MySpatial.findNamed(child = (Spatial)iterator.next(), name)) == null) {
            }
        }
        return result;
    }

    public static MatParamOverride findOverride(Spatial spatial, String parameterName) {
        Validate.nonNull(spatial, "spatial");
        Validate.nonEmpty(parameterName, "parameterName");
        MatParamOverride result = null;
        SafeArrayList list = spatial.getLocalMatParamOverrides();
        for (MatParamOverride override : list) {
            String name = override.getName();
            if (!parameterName.equals(name)) continue;
            result = override;
            break;
        }
        return result;
    }

    public static boolean hasLight(Spatial spatial, Light light) {
        Validate.nonNull(light, "light");
        for (Light l : spatial.getLocalLightList()) {
            if (l != light) continue;
            return true;
        }
        return false;
    }

    public static Quaternion inverseOrientation(Spatial spatial) {
        Quaternion forward = spatial.getWorldRotation();
        Quaternion result = forward.inverse();
        if (result == null) {
            throw new IllegalArgumentException("orientation not invertible");
        }
        return result;
    }

    public static boolean isIgnoringTransforms(Spatial spatial) {
        Geometry geometry;
        boolean result = false;
        if (spatial instanceof Geometry && (geometry = (Geometry)spatial).isIgnoreTransform()) {
            result = true;
        }
        return result;
    }

    public static boolean isOrphan(Spatial spatial) {
        Node parent = spatial.getParent();
        return parent == null;
    }

    public static List<Mesh> listAnimatedMeshes(Spatial subtree, List<Mesh> storeResult) {
        ArrayList<Mesh> result;
        ArrayList<Mesh> arrayList = result = storeResult == null ? new ArrayList<Mesh>(10) : storeResult;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            if (MyMesh.isAnimated(mesh) && !result.contains(mesh)) {
                result.add(mesh);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listAnimatedMeshes(child, result);
            }
        }
        return result;
    }

    public static List<Spatial> listAnimationSpatials(Spatial subtree, List<Spatial> addResults) {
        List<Spatial> results = addResults == null ? new ArrayList<Spatial>(4) : addResults;
        if (subtree != null) {
            int numControls = subtree.getNumControls();
            for (int controlI = 0; controlI < numControls; ++controlI) {
                Control control = subtree.getControl(controlI);
                if (!(control instanceof SkinningControl) && !(control instanceof SkeletonControl)) continue;
                results.add(subtree);
                break;
            }
            if (subtree instanceof Node) {
                List children = ((Node)subtree).getChildren();
                for (Spatial child : children) {
                    results = MySpatial.listAnimationSpatials(child, results);
                }
            }
        }
        return results;
    }

    public static <T extends Control> List<T> listControls(Spatial subtree, Class<T> controlType, List<T> storeResult) {
        ArrayList<Control> result = storeResult == null ? new ArrayList<Control>(4) : storeResult;
        int numControls = subtree.getNumControls();
        for (int controlIndex = 0; controlIndex < numControls; ++controlIndex) {
            Control control = subtree.getControl(controlIndex);
            if (!controlType.isAssignableFrom(control.getClass()) || result.contains(control)) continue;
            result.add(control);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listControls(child, controlType, result);
            }
        }
        return result;
    }

    public static List<Geometry> listGeometries(Spatial subtree) {
        Validate.nonNull(subtree, "subtree");
        List<Geometry> result = MySpatial.listSpatials(subtree, Geometry.class, null);
        return result;
    }

    public static List<Material> listMaterials(Spatial subtree, List<Material> storeResult) {
        ArrayList<Material> result;
        ArrayList<Material> arrayList = result = storeResult == null ? new ArrayList<Material>(10) : storeResult;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Material material = geometry.getMaterial();
            if (!result.contains(material)) {
                result.add(material);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listMaterials(child, result);
            }
        }
        return result;
    }

    public static List<Geometry> listMaterialUsers(Spatial subtree, Material material, List<Geometry> addResult) {
        ArrayList<Geometry> result;
        ArrayList<Geometry> arrayList = result = addResult == null ? new ArrayList<Geometry>(50) : addResult;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            if (geometry.getMaterial() == material) {
                result.add(geometry);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listMaterialUsers(child, material, result);
            }
        }
        return result;
    }

    public static List<Geometry> listMeshUsers(Spatial subtree, Mesh mesh, List<Geometry> addResult) {
        ArrayList<Geometry> result;
        ArrayList<Geometry> arrayList = result = addResult == null ? new ArrayList<Geometry>(50) : addResult;
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            if (geometry.getMesh() == mesh) {
                result.add(geometry);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listMeshUsers(child, mesh, result);
            }
        }
        return result;
    }

    public static List<Spatial> listSpatials(Spatial subtree) {
        Validate.nonNull(subtree, "subtree");
        List<Spatial> result = MySpatial.listSpatials(subtree, Spatial.class, null);
        return result;
    }

    public static <T extends Spatial> List<T> listSpatials(Spatial subtree, Class<T> spatialType, List<T> addResult) {
        Spatial spatial;
        ArrayList<Spatial> result;
        Validate.nonNull(subtree, "subtree");
        ArrayList<Spatial> arrayList = result = addResult == null ? new ArrayList<Spatial>(50) : addResult;
        if (spatialType.isAssignableFrom(subtree.getClass()) && !result.contains(spatial = subtree)) {
            result.add(spatial);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.listSpatials(child, spatialType, result);
            }
        }
        return result;
    }

    public static List<Texture> listTextures(Spatial subtree, List<Texture> addResult) {
        ArrayList<Texture> result = addResult == null ? new ArrayList<Texture>(32) : addResult;
        List<Material> materials = MySpatial.listMaterials(subtree, null);
        for (Material material : materials) {
            Collection parameters = material.getParams();
            for (MatParam parameter : parameters) {
                MySpatial.addTexture(result, parameter);
            }
        }
        List<Spatial> spatials = MySpatial.listSpatials(subtree);
        for (Spatial spatial : spatials) {
            SafeArrayList mpos = spatial.getLocalMatParamOverrides();
            for (MatParamOverride mpo : mpos) {
                MySpatial.addTexture(result, (MatParam)mpo);
            }
        }
        return result;
    }

    public static void prepareForCollide(Spatial subtree) {
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            geometry.updateModelBound();
            Mesh mesh = geometry.getMesh();
            mesh.clearCollisionData();
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.prepareForCollide(child);
            }
        }
    }

    public static void removeAllControls(Spatial subtree) {
        while (subtree.getNumControls() > 0) {
            Control control = subtree.getControl(0);
            subtree.removeControl(control);
        }
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                MySpatial.removeAllControls(child);
            }
        }
    }

    public static void setWorldLocation(Spatial spatial, Vector3f worldLocation) {
        Validate.finite(worldLocation, "world location");
        if (MySpatial.isIgnoringTransforms(spatial)) {
            throw new IllegalArgumentException("transform ignored");
        }
        Node parent = spatial.getParent();
        if (parent == null) {
            spatial.setLocalTranslation(worldLocation);
        } else {
            Vector3f translation = parent.worldToLocal(worldLocation, null);
            spatial.setLocalTranslation(translation);
        }
    }

    public static void setWorldOrientation(Spatial spatial, Quaternion worldOrientation) {
        Validate.nonNull(worldOrientation, "world orientation");
        if (MySpatial.isIgnoringTransforms(spatial)) {
            throw new IllegalArgumentException("transform ignored");
        }
        Node parent = spatial.getParent();
        if (parent == null) {
            spatial.setLocalRotation(worldOrientation);
        } else {
            Quaternion rotation = MySpatial.inverseOrientation((Spatial)parent);
            rotation.multLocal(worldOrientation);
            spatial.setLocalRotation(rotation);
        }
    }

    public static void setWorldScale(Spatial spatial, float worldScale) {
        Validate.positive(worldScale, "world scale");
        if (MySpatial.isIgnoringTransforms(spatial)) {
            throw new IllegalArgumentException("transform ignored");
        }
        Node parent = spatial.getParent();
        if (parent == null) {
            spatial.setLocalScale(worldScale);
        } else {
            Vector3f parentScale = parent.getWorldScale();
            if (parentScale.x == 0.0f || parentScale.y == 0.0f || parentScale.z == 0.0f) {
                String message = "parent scale = " + parentScale;
                throw new IllegalArgumentException(message);
            }
            Vector3f scale = new Vector3f(worldScale, worldScale, worldScale);
            scale.divideLocal(parentScale);
            spatial.setLocalScale(scale);
        }
    }

    public static void setWorldTransform(Spatial spatial, Transform worldTransform) {
        Validate.nonNull(worldTransform, "world transform");
        if (MySpatial.isIgnoringTransforms(spatial)) {
            throw new IllegalArgumentException("transform ignored");
        }
        Node parent = spatial.getParent();
        if (parent == null) {
            spatial.setLocalTransform(worldTransform);
        } else {
            Transform transform = worldTransform.clone();
            Vector3f translation = transform.getTranslation();
            Quaternion rotation = transform.getRotation();
            Vector3f scale = transform.getScale();
            Transform parentTransform = parent.getWorldTransform();
            Vector3f parentTranslation = parentTransform.getTranslation();
            Quaternion parentRotation = parentTransform.getRotation();
            Vector3f parentScale = parentTransform.getScale();
            if (parentScale.x == 0.0f || parentScale.y == 0.0f || parentScale.z == 0.0f) {
                throw new IllegalArgumentException("zero in scale");
            }
            Quaternion parentInvRotation = parentRotation.inverse();
            if (parentInvRotation == null) {
                throw new IllegalArgumentException("rotation not invertible");
            }
            scale.divideLocal(parentScale);
            parentInvRotation.mult(rotation, rotation);
            translation.subtractLocal(parentTranslation);
            parentInvRotation.multLocal(translation);
            translation.divideLocal(parentScale);
            spatial.setLocalTransform(transform);
        }
    }

    public static boolean subtreeContainsAny(Spatial subtree, Collection<Spatial> collection) {
        boolean result;
        if (subtree == null) {
            result = false;
        } else if (collection.isEmpty()) {
            result = false;
        } else if (collection.contains(subtree)) {
            result = true;
        } else if (subtree instanceof Node) {
            Spatial spatial;
            Node node = (Node)subtree;
            result = false;
            Iterator<Spatial> iterator = collection.iterator();
            while (iterator.hasNext() && !(result = (spatial = iterator.next()).hasAncestor(node))) {
            }
        } else {
            result = false;
        }
        return result;
    }

    public static float uniformScale(Spatial spatial) {
        float result;
        Validate.nonNull(spatial, "spatial");
        if (MySpatial.isIgnoringTransforms(spatial)) {
            result = 1.0f;
        } else {
            Vector3f worldScale = spatial.getWorldScale();
            if (!MyVector3f.isScaleUniform(worldScale)) {
                throw new IllegalArgumentException("non-uniform scaling");
            }
            result = worldScale.y;
        }
        return result;
    }

    public static void visualizeBoneWeights(Spatial subtree, ColorRGBA[] boneIndexToColor, AssetManager assetManager) {
        Geometry geometry;
        Mesh mesh;
        if (subtree instanceof Node) {
            Node node = (Node)subtree;
            for (Spatial spatial : node.getChildren()) {
                MySpatial.visualizeBoneWeights(spatial, boneIndexToColor, assetManager);
            }
        } else if (subtree instanceof Geometry && MyMesh.isAnimated(mesh = (geometry = (Geometry)subtree).getMesh())) {
            Material material = MyMesh.boneWeightMaterial(mesh, boneIndexToColor, assetManager);
            geometry.setMaterial(material);
        }
    }

    public static Vector3f worldLocation(Spatial spatial, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull(spatial, "spatial");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MySpatial.isIgnoringTransforms(spatial)) {
            result.zero();
        } else {
            Vector3f location = spatial.getWorldTranslation();
            result.set(location);
        }
        return result;
    }

    public static Quaternion worldOrientation(Spatial spatial, Quaternion storeResult) {
        Quaternion result;
        Validate.nonNull(spatial, "spatial");
        Quaternion quaternion = result = storeResult == null ? new Quaternion() : storeResult;
        if (MySpatial.isIgnoringTransforms(spatial)) {
            result.loadIdentity();
        } else {
            Quaternion orientation = spatial.getWorldRotation();
            result.set(orientation);
        }
        return result;
    }

    public static Vector3f worldScale(Spatial spatial, Vector3f storeResult) {
        Vector3f result;
        Validate.nonNull(spatial, "spatial");
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (MySpatial.isIgnoringTransforms(spatial)) {
            result.set(1.0f, 1.0f, 1.0f);
        } else {
            Vector3f scale = spatial.getWorldScale();
            result.set(scale);
        }
        return result;
    }

    public static Transform worldTransform(Spatial spatial, Transform storeResult) {
        Transform result;
        Validate.nonNull(spatial, "spatial");
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (MySpatial.isIgnoringTransforms(spatial)) {
            result.loadIdentity();
        } else {
            Transform transform2 = spatial.getWorldTransform();
            result.set(transform2);
        }
        return result;
    }

    private static void addTexture(Collection<Texture> collection, MatParam parameter) {
        VarType varType = parameter.getVarType();
        switch (varType) {
            case Texture2D: 
            case Texture3D: 
            case TextureArray: 
            case TextureCubeMap: {
                Texture texture = (Texture)parameter.getValue();
                if (texture == null || MySpatial.containsInstance(collection, texture)) break;
                collection.add(texture);
                break;
            }
        }
    }

    private static boolean containsInstance(Iterable<Texture> iterable, Texture testInstance) {
        for (Texture item : iterable) {
            if (item != testInstance) continue;
            return true;
        }
        return false;
    }
}

