/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.renderer.RenderManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.NameGenerator;
import jme3utilities.Validate;

public class NamedAppState
extends AbstractAppState {
    private static final Logger logger = Logger.getLogger(NamedAppState.class.getName());
    private final List<AppState> influenceList = new ArrayList<AppState>(2);
    private static final NameGenerator idGenerator = new NameGenerator();

    public NamedAppState(boolean initialState) {
        this(initialState ? InitialState.Enabled : InitialState.Disabled);
    }

    public NamedAppState(InitialState initialState) {
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        String id = idGenerator.unique(className);
        this.setId(id);
        super.setEnabled(initialState == InitialState.Enabled);
    }

    public Collection<AppState> getInfluence() {
        return Collections.unmodifiableCollection(this.influenceList);
    }

    public boolean hasInfluenceOver(AppState appState) {
        boolean result = this.influenceList.contains(appState);
        return result;
    }

    public final void influence(AppState appState) {
        Validate.nonNull(appState, "app state");
        if (appState == this) {
            throw new IllegalArgumentException("self-influence not allowed");
        }
        if (appState.isEnabled() != this.isEnabled()) {
            logger.log(Level.WARNING, "influenced state {0} out-of-synch with {1}", new Object[]{appState, this});
        }
        this.influenceList.add(appState);
    }

    public void stopInfluencing(AppState appState) {
        this.influenceList.remove(appState);
    }

    public void cleanup() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("should be initialized");
        }
        super.cleanup();
    }

    public void initialize(AppStateManager sm, Application app) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "initialize {0}", this.getId());
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("already initialized");
        }
        Validate.nonNull(sm, "state manager");
        if (sm != app.getStateManager()) {
            throw new IllegalArgumentException("wrong state manager");
        }
        super.initialize(sm, app);
    }

    public final boolean isEnabled() {
        return super.isEnabled();
    }

    public final boolean isInitialized() {
        return super.isInitialized();
    }

    public void postRender() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("should be initialized");
        }
        if (!this.isEnabled()) {
            throw new IllegalStateException("should be enabled");
        }
        super.postRender();
    }

    public void render(RenderManager rm) {
        Validate.nonNull(rm, "render manager");
        if (!this.isInitialized()) {
            throw new IllegalStateException("should be initialized");
        }
        if (!this.isEnabled()) {
            throw new IllegalStateException("should be enabled");
        }
        super.render(rm);
    }

    public void setEnabled(boolean newSetting) {
        boolean oldSetting = this.isEnabled();
        if (oldSetting != newSetting) {
            if (logger.isLoggable(Level.INFO)) {
                if (newSetting) {
                    logger.log(Level.INFO, "enable {0}", this.getId());
                } else {
                    logger.log(Level.INFO, "disable {0}", this.getId());
                }
            }
            super.setEnabled(newSetting);
            for (AppState as : this.influenceList) {
                as.setEnabled(newSetting);
            }
        }
    }

    public void stateAttached(AppStateManager sm) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "attach {0}", this.getId());
        }
        Validate.nonNull(sm, "state manager");
        super.stateAttached(sm);
    }

    public void stateDetached(AppStateManager sm) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "detach {0}", this.getId());
        }
        Validate.nonNull(sm, "state manager");
        super.stateDetached(sm);
    }

    public String toString() {
        String result = String.format("%s (%sinitialized, %sabled)", this.getId(), this.isInitialized() ? "" : "un", this.isEnabled() ? "en" : "dis");
        return result;
    }

    public void update(float tpf) {
        Validate.nonNegative(tpf, "time between frames");
        if (!this.isInitialized()) {
            throw new IllegalStateException("should be initialized");
        }
        if (!this.isEnabled()) {
            throw new IllegalStateException("should be enabled");
        }
        super.update(tpf);
    }
}

