/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySpatial;
import jme3utilities.SimpleControl;

public abstract class SubtreeControl
extends SimpleControl {
    private static final Logger logger = Logger.getLogger(SubtreeControl.class.getName());
    private Spatial subtree = null;

    protected SubtreeControl() {
        super.setEnabled(false);
    }

    public Spatial getSubtree() {
        return this.subtree;
    }

    protected final void setSubtree(Spatial desiredSubtree) {
        assert (desiredSubtree != null);
        assert (MySpatial.isOrphan(desiredSubtree));
        assert (this.subtree == null);
        this.subtree = desiredSubtree;
    }

    public SubtreeControl clone() throws CloneNotSupportedException {
        SubtreeControl clone = (SubtreeControl)((Object)super.clone());
        return clone;
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.subtree = (Spatial)cloner.clone((Object)this.subtree);
    }

    public Control cloneForSpatial(Spatial cloneNode) {
        throw new UnsupportedOperationException();
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule ic = importer.getCapsule((Savable)this);
        this.subtree = (Spatial)ic.readSavable("subtree", null);
    }

    public void setEnabled(boolean newState) {
        Node node = (Node)this.spatial;
        if (this.enabled && !newState) {
            if (node != null && this.subtree != null) {
                int position = node.detachChild(this.subtree);
                assert (position != -1) : position;
            }
        } else if (!this.enabled && newState) {
            if (node == null) {
                throw new IllegalStateException("control should be added to a node");
            }
            if (this.subtree == null) {
                throw new IllegalStateException("subtree should be initialized");
            }
            node.attachChild(this.subtree);
        }
        super.setEnabled(newState);
    }

    public void setSpatial(Spatial newSpatial) {
        if (newSpatial != null && !(newSpatial instanceof Node)) {
            throw new IllegalArgumentException("Controlled spatial must be a Node or null.");
        }
        if (this.subtree != null && this.subtree.getParent() != newSpatial) {
            this.subtree.removeFromParent();
            if (this.enabled && newSpatial != null) {
                Node newNode = (Node)newSpatial;
                newNode.attachChild(this.subtree);
            }
        }
        super.setSpatial(newSpatial);
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule oc = exporter.getCapsule((Savable)this);
        oc.write((Savable)this.subtree, "subtree", null);
    }
}

