/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.SimpleAppState;

public class ViewPortAppState
extends SimpleAppState {
    private static final Logger logger = Logger.getLogger(ViewPortAppState.class.getName());
    private float tpf;
    private final List<Spatial> updateList = new ArrayList<Spatial>(10);

    public ViewPortAppState() {
        super(InitialState.Enabled);
    }

    @Override
    public void render(RenderManager rm) {
        super.render(rm);
        this.updateList.clear();
        List viewPorts = rm.getPreViews();
        this.addToUpdateList(viewPorts);
        viewPorts = rm.getMainViews();
        this.addToUpdateList(viewPorts);
        viewPorts = rm.getPostViews();
        this.addToUpdateList(viewPorts);
        for (Spatial root : this.updateList) {
            root.updateLogicalState(this.tpf);
            root.updateGeometricState();
        }
    }

    @Override
    public void update(float elapsedTime) {
        super.update(elapsedTime);
        this.tpf = elapsedTime;
    }

    private void addToUpdateList(List<ViewPort> viewPortList) {
        for (ViewPort vp : viewPortList) {
            if (!vp.isEnabled()) continue;
            SafeArrayList sceneList = vp.getScenes();
            for (Spatial root : sceneList) {
                if (root == this.rootNode || root == this.guiNode || "Physics Debug Root Node".equals(root.getName()) || this.updateList.contains(root)) continue;
                this.updateList.add(root);
            }
        }
    }
}

