/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.asset.AssetManager;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.WireBox;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.MySpatial;
import jme3utilities.SubtreeControl;
import jme3utilities.Validate;
import jme3utilities.debug.SphereMeshes;
import jme3utilities.math.MyVector3f;

public class BoundsVisualizer
extends SubtreeControl {
    private static final boolean defaultDepthTest = false;
    private static final ColorRGBA defaultLineColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    private static final float defaultLineWidth = 1.0f;
    private static final int linesChildPosition = 0;
    private static final Logger logger = Logger.getLogger(BoundsVisualizer.class.getName());
    private static final String linesName = "bound lines";
    private static final String subtreeName = "bound node";
    private static final String tagBillboardAxis = "billboardAxis";
    private static final String tagCamera = "camera";
    private static final String tagLineMaterial = "lineMaterial";
    private static final String tagLineWidth = "lineWidth";
    private static final String tagSphereType = "sphereType";
    private static final String tagSubject = "subject";
    private Camera camera = null;
    private float effectiveLineWidth = 1.0f;
    private int billboardAxis = 0;
    private Material lineMaterial;
    private Spatial subject = null;
    private SphereMeshes sphereType = SphereMeshes.WireSphere;

    protected BoundsVisualizer() {
    }

    public BoundsVisualizer(AssetManager assetManager) {
        Validate.nonNull(assetManager, "asset manager");
        this.lineMaterial = MyAsset.createWireframeMaterial(assetManager, defaultLineColor);
        RenderState rs = this.lineMaterial.getAdditionalRenderState();
        rs.setDepthTest(false);
        this.lineMaterial.setName("bound mat");
        assert (!this.isEnabled());
    }

    public int billboardAxis() {
        int result = this.camera == null ? -1 : this.billboardAxis;
        return result;
    }

    public ColorRGBA copyLineColor(ColorRGBA storeResult) {
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        MatParam parameter = this.lineMaterial.getParam("Color");
        ColorRGBA color = (ColorRGBA)parameter.getValue();
        result.set(color);
        return result;
    }

    public void disableBillboarding() {
        this.camera = null;
    }

    public void enableBillboarding(Camera camera, int axisIndex) {
        Validate.nonNull(camera, tagCamera);
        Validate.axisIndex(axisIndex, "axis index");
        this.camera = camera;
        this.billboardAxis = axisIndex;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Spatial getSubject() {
        return this.subject;
    }

    public boolean isDepthTest() {
        RenderState rs = this.lineMaterial.getAdditionalRenderState();
        boolean result = rs.isDepthTest();
        return result;
    }

    public float lineWidth() {
        assert (this.effectiveLineWidth >= 0.0f) : this.effectiveLineWidth;
        return this.effectiveLineWidth;
    }

    public void setColor(ColorRGBA newColor) {
        ColorRGBA colorClone = newColor.clone();
        this.lineMaterial.setColor("Color", colorClone);
    }

    public void setDepthTest(boolean newSetting) {
        RenderState rs = this.lineMaterial.getAdditionalRenderState();
        rs.setDepthTest(newSetting);
    }

    public void setLineWidth(float newWidth) {
        Validate.nonNegative(newWidth, "new width");
        this.effectiveLineWidth = newWidth;
    }

    public void setSphereType(SphereMeshes type) {
        Validate.nonNull((Object)type, "type");
        this.sphereType = type;
    }

    public void setSubject(Spatial newSubject) {
        this.subject = newSubject;
    }

    public SphereMeshes sphereType() {
        assert (this.sphereType != null);
        return this.sphereType;
    }

    @Override
    public BoundsVisualizer clone() throws CloneNotSupportedException {
        BoundsVisualizer clone = (BoundsVisualizer)super.clone();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.camera = (Camera)cloner.clone((Object)this.camera);
        this.lineMaterial = (Material)cloner.clone((Object)this.lineMaterial);
        this.subject = (Spatial)cloner.clone((Object)this.subject);
    }

    @Override
    protected void controlUpdate(float updateInterval) {
        super.controlUpdate(updateInterval);
        Node subtreeNode = (Node)this.getSubtree();
        if (this.subject == null || this.effectiveLineWidth < 1.0f) {
            subtreeNode.detachAllChildren();
        } else if (subtreeNode.getQuantity() == 0) {
            this.addLines();
        } else {
            Geometry lines = (Geometry)subtreeNode.getChild(0);
            BoundingVolume bound = this.subject.getWorldBound();
            Mesh mesh = lines.getMesh();
            if (bound instanceof BoundingBox && mesh instanceof WireBox) {
                this.updateBox();
            } else if (bound instanceof BoundingSphere && this.sphereType.isInstance(mesh)) {
                this.updateSphere();
            } else {
                subtreeNode.detachAllChildren();
                this.addLines();
            }
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.billboardAxis = capsule.readInt(tagBillboardAxis, 0);
        this.camera = (Camera)capsule.readSavable(tagCamera, null);
        this.lineMaterial = (Material)capsule.readSavable(tagLineMaterial, null);
        this.effectiveLineWidth = capsule.readFloat(tagLineWidth, 0.0f);
        this.sphereType = (SphereMeshes)capsule.readEnum(tagSphereType, SphereMeshes.class, null);
        this.subject = (Spatial)capsule.readSavable(tagSubject, null);
    }

    @Override
    public void setEnabled(boolean newState) {
        if (newState && this.getSubtree() == null) {
            Node subtreeNode = new Node(subtreeName);
            subtreeNode.setQueueBucket(RenderQueue.Bucket.Transparent);
            subtreeNode.setShadowMode(RenderQueue.ShadowMode.Off);
            this.setSubtree((Spatial)subtreeNode);
        }
        super.setEnabled(newState);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.billboardAxis, tagBillboardAxis, 0);
        capsule.write((Savable)this.camera, tagCamera, null);
        capsule.write((Savable)this.lineMaterial, tagLineMaterial, null);
        capsule.write(this.effectiveLineWidth, tagLineWidth, 0.0f);
        capsule.write((Enum)this.sphereType, tagSphereType, null);
        capsule.write((Savable)this.subject, tagSubject, null);
    }

    private void addLines() {
        WireBox mesh;
        assert (((Node)this.getSubtree()).getQuantity() == 0);
        BoundingVolume bound = this.subject.getWorldBound();
        if (bound instanceof BoundingBox) {
            mesh = new WireBox();
        } else if (bound instanceof BoundingSphere) {
            float radius = 1.0f;
            boolean wantNormals = false;
            boolean wantUVs = false;
            mesh = this.sphereType.makeSphere(radius, wantNormals, wantUVs);
        } else {
            throw new IllegalStateException(bound.getClass().getName());
        }
        Geometry lines = new Geometry(linesName, (Mesh)mesh);
        lines.setMaterial(this.lineMaterial);
        ((Node)this.getSubtree()).attachChildAt((Spatial)lines, 0);
        if (bound instanceof BoundingBox) {
            this.updateBox();
        } else {
            this.updateSphere();
        }
    }

    private void updateBox() {
        BoundingVolume bound = this.subject.getWorldBound();
        BoundingBox boundingBox = (BoundingBox)bound;
        Node subtreeNode = (Node)this.getSubtree();
        Geometry lines = (Geometry)subtreeNode.getChild(0);
        WireBox boxMesh = (WireBox)lines.getMesh();
        float xExtent = boundingBox.getXExtent();
        float yExtent = boundingBox.getYExtent();
        float zExtent = boundingBox.getZExtent();
        assert (xExtent >= 0.0f) : xExtent;
        assert (yExtent >= 0.0f) : yExtent;
        assert (zExtent >= 0.0f) : zExtent;
        boxMesh.updatePositions(xExtent, yExtent, zExtent);
        Transform transform = new Transform();
        Vector3f center = boundingBox.getCenter();
        transform.setTranslation(center);
        MySpatial.setWorldTransform((Spatial)lines, transform);
        this.updateLineWidth();
    }

    private void updateLineWidth() {
        Node subtreeNode = (Node)this.getSubtree();
        Geometry lines = (Geometry)subtreeNode.getChild(0);
        assert (this.effectiveLineWidth >= 1.0f) : this.effectiveLineWidth;
        assert (this.lineMaterial == lines.getMaterial());
        RenderState rs = this.lineMaterial.getAdditionalRenderState();
        rs.setLineWidth(this.effectiveLineWidth);
    }

    private void updateSphere() {
        BoundingVolume bound = this.subject.getWorldBound();
        BoundingSphere boundingSphere = (BoundingSphere)bound;
        Node subtreeNode = (Node)this.getSubtree();
        Geometry lines = (Geometry)subtreeNode.getChild(0);
        Transform transform = new Transform();
        Vector3f center = boundingSphere.getCenter();
        transform.setTranslation(center);
        if (this.camera != null) {
            Vector3f offset = this.camera.getLocation().subtract(center);
            Vector3f axis1 = new Vector3f();
            Vector3f axis2 = new Vector3f();
            MyVector3f.generateBasis(offset, axis1, axis2);
            Quaternion orientation = transform.getRotation();
            if (this.billboardAxis == 0) {
                orientation.fromAxes(offset, axis1, axis2);
            } else if (this.billboardAxis == 1) {
                orientation.fromAxes(axis2, offset, axis1);
            } else if (this.billboardAxis == 2) {
                orientation.fromAxes(axis1, axis2, offset);
            } else {
                String message = "billboardAxis = " + this.billboardAxis;
                throw new IllegalStateException(message);
            }
        }
        float radius = boundingSphere.getRadius();
        transform.setScale(radius);
        MySpatial.setWorldTransform((Spatial)lines, transform);
        this.updateLineWidth();
    }
}

