/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.MyAsset;
import jme3utilities.SimpleAppState;
import jme3utilities.Validate;

public class PerformanceAppState
extends SimpleAppState {
    private static final float backgroundWidth = 250.0f;
    private static final Logger logger = Logger.getLogger(PerformanceAppState.class.getName());
    private static final String fontPath = "Interface/Fonts/Default.fnt";
    private BitmapText text = null;
    private final ColorRGBA backgroundColor = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private final ColorRGBA textColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private double secondsRemaining = 0.0;
    private float maxTPF = 0.0f;
    private float measurementInterval = 1.0f;
    private Geometry background;

    public PerformanceAppState() {
        super(InitialState.Enabled);
    }

    public void setUpdateInterval(float newInterval) {
        Validate.positive(newInterval, "new interval");
        this.measurementInterval = newInterval;
    }

    public float updateInterval() {
        assert (this.measurementInterval > 0.0f) : this.measurementInterval;
        return this.measurementInterval;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.guiNode.detachChild((Spatial)this.background);
        this.guiNode.detachChild((Spatial)this.text);
    }

    @Override
    public void initialize(AppStateManager stateManager, Application application) {
        super.initialize(stateManager, application);
        BitmapFont font = this.assetManager.loadFont(fontPath);
        this.text = new BitmapText(font);
        float lineHeight = this.text.getLineHeight();
        this.text.setColor(this.textColor);
        this.text.setCullHint(Spatial.CullHint.Never);
        this.text.setLocalTranslation(0.0f, lineHeight, 0.0f);
        this.guiNode.attachChild((Spatial)this.text);
        Material backgroundMaterial = MyAsset.createUnshadedMaterial(this.assetManager);
        backgroundMaterial.setColor("Color", this.backgroundColor.clone());
        RenderState renderState = backgroundMaterial.getAdditionalRenderState();
        renderState.setBlendMode(RenderState.BlendMode.Alpha);
        Quad quad = new Quad(250.0f, lineHeight);
        this.background = new Geometry("perf stats background", (Mesh)quad);
        this.background.setCullHint(Spatial.CullHint.Never);
        this.background.setLocalTranslation(0.0f, 0.0f, -1.0f);
        this.background.setMaterial(backgroundMaterial);
        this.guiNode.attachChild((Spatial)this.background);
        this.reset();
    }

    @Override
    public void setEnabled(boolean newSetting) {
        boolean oldSetting = this.isEnabled();
        super.setEnabled(newSetting);
        if (oldSetting != newSetting) {
            Spatial.CullHint cull;
            if (newSetting) {
                this.reset();
                cull = Spatial.CullHint.Never;
            } else {
                cull = Spatial.CullHint.Always;
            }
            this.background.setCullHint(cull);
            this.text.setCullHint(cull);
        }
    }

    @Override
    public void update(float timePerFrame) {
        super.update(timePerFrame);
        this.maxTPF = Math.max(this.maxTPF, timePerFrame);
        this.secondsRemaining -= (double)timePerFrame;
        if (this.secondsRemaining < 0.0) {
            this.updateText();
            this.maxTPF = 0.0f;
            this.secondsRemaining = this.measurementInterval;
        }
    }

    private void reset() {
        this.maxTPF = 0.0f;
        this.secondsRemaining = this.measurementInterval;
        this.text.setText("(awaiting update)");
    }

    private void updateText() {
        float milliseconds = 1000.0f * this.maxTPF;
        String message = String.format("Max time per frame = %.1f msec", Float.valueOf(milliseconds));
        this.text.setText(message);
    }
}

