/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Vector3f;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;

public class DistinctVectorValues {
    private static final Logger logger = Logger.getLogger(DistinctVectorValues.class.getName());
    private final int numDistinctValues;
    private final int numVectors;
    private final int[] vectorIndex2Vvid;
    private final Map<Vector3f, Integer> value2Vvid;
    private final Vector3f tmpVector = new Vector3f();

    public DistinctVectorValues(FloatBuffer buffer, int startPosition, int endPosition) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        Validate.require(numFloats % 3 == 0, "whole number of vectors");
        this.numVectors = numFloats / 3;
        this.value2Vvid = new HashMap<Vector3f, Integer>(this.numVectors);
        this.vectorIndex2Vvid = new int[this.numVectors];
        Arrays.fill(this.vectorIndex2Vvid, -1);
        int nextVvid = 0;
        for (int vectorIndex = 0; vectorIndex < this.numVectors; ++vectorIndex) {
            int position = startPosition + 3 * vectorIndex;
            Vector3f vector = new Vector3f();
            MyBuffer.get(buffer, position, vector);
            MyVector3f.standardize(vector, this.tmpVector);
            Integer vvid = this.value2Vvid.get(this.tmpVector);
            if (vvid == null) {
                vvid = nextVvid;
                ++nextVvid;
                this.value2Vvid.put(vector, vvid);
            }
            this.vectorIndex2Vvid[vectorIndex] = vvid;
        }
        this.numDistinctValues = nextVvid;
    }

    public DistinctVectorValues(FloatBuffer buffer, int startPosition, int endPosition, float tolerance) {
        Validate.nonNull(buffer, "buffer");
        Validate.inRange(startPosition, "start position", 0, endPosition);
        Validate.inRange(endPosition, "end position", startPosition, buffer.capacity());
        int numFloats = endPosition - startPosition;
        Validate.require(numFloats % 3 == 0, "whole number of vectors");
        Validate.positive(tolerance, "tolerance");
        this.numVectors = numFloats / 3;
        this.value2Vvid = new HashMap<Vector3f, Integer>(this.numVectors);
        this.vectorIndex2Vvid = new int[this.numVectors];
        Arrays.fill(this.vectorIndex2Vvid, -1);
        double tt = tolerance;
        double toleranceSquared = tt * tt;
        int nextVvid = 0;
        for (int vectorIndex = 0; vectorIndex < this.numVectors; ++vectorIndex) {
            int position = startPosition + 3 * vectorIndex;
            Vector3f vector = new Vector3f();
            MyBuffer.get(buffer, position, vector);
            int vvid = -1;
            for (Map.Entry<Vector3f, Integer> entry : this.value2Vvid.entrySet()) {
                Vector3f v = entry.getKey();
                if (!MyVector3f.doCoincide(v, vector, toleranceSquared)) continue;
                vvid = entry.getValue();
                assert (vvid >= 0) : vvid;
                break;
            }
            if (vvid == -1) {
                vvid = nextVvid++;
                this.value2Vvid.put(vector, vvid);
            }
            this.vectorIndex2Vvid[vectorIndex] = vvid;
        }
        this.numDistinctValues = nextVvid;
    }

    public int countDistinct() {
        assert (this.numDistinctValues >= 0) : this.numDistinctValues;
        return this.numDistinctValues;
    }

    public int findVvid(int vectorIndex) {
        Validate.nonNegative(vectorIndex, "vector index");
        int result = this.vectorIndex2Vvid[vectorIndex];
        assert (result >= -1) : result;
        assert (result < this.numDistinctValues);
        return result;
    }
}

