/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class RectSizeLimits {
    private static final Logger logger = Logger.getLogger(RectSizeLimits.class.getName());
    public final int maxHeight;
    public final int maxWidth;
    public final int minHeight;
    public final int minWidth;

    public RectSizeLimits(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        Validate.inRange(minWidth, "minimum width", 1, maxWidth);
        Validate.inRange(minHeight, "minimum height", 1, maxHeight);
        Validate.inRange(maxWidth, "maximum width", minWidth, Integer.MAX_VALUE);
        Validate.inRange(maxHeight, "maximum height", minHeight, Integer.MAX_VALUE);
        this.minWidth = minWidth;
        this.minHeight = minHeight;
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public int clampHeight(int height) {
        int result = MyMath.clamp(height, this.minHeight, this.maxHeight);
        return result;
    }

    public int clampWidth(int width) {
        int result = MyMath.clamp(width, this.minWidth, this.maxWidth);
        return result;
    }

    public String feedbackInRange(int width, int height) {
        if (width < this.minWidth) {
            return String.format("width must not be < %d", this.minWidth);
        }
        if (width > this.maxWidth) {
            return String.format("width must not be > %d", this.maxWidth);
        }
        if (height < this.minHeight) {
            return String.format("height must not be < %d", this.minHeight);
        }
        if (height > this.maxHeight) {
            return String.format("height must not be > %d", this.maxHeight);
        }
        return "";
    }

    public boolean isInRange(int width, int height) {
        if (!MyMath.isBetween(this.minHeight, height, this.maxHeight)) {
            return false;
        }
        return MyMath.isBetween(this.minWidth, width, this.maxWidth);
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (otherObject == this) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            RectSizeLimits other = (RectSizeLimits)otherObject;
            result = other.maxHeight == this.maxHeight && other.maxWidth == this.maxWidth && other.minHeight == this.minHeight && other.minWidth == this.minWidth;
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int result = 707;
        result = 29 * result + this.maxHeight;
        result = 29 * result + this.maxWidth;
        result = 29 * result + this.minHeight;
        result = 29 * result + this.minWidth;
        return result;
    }

    public String toString() {
        String result = String.format("(%d,%d)-(%d,%d)", this.minWidth, this.minHeight, this.maxWidth, this.maxHeight);
        return result;
    }
}

