/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.ReadXZ;

public class VectorXZ
implements Comparable<ReadXZ>,
ReadXZ,
Savable {
    public static final Logger logger = Logger.getLogger(VectorXZ.class.getName());
    private static final Vector3f unitY = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final VectorXZ backward = new VectorXZ(-1.0f, 0.0f);
    public static final VectorXZ east = new VectorXZ(0.0f, 1.0f);
    public static final VectorXZ forward = new VectorXZ(1.0f, 0.0f);
    public static final VectorXZ left = new VectorXZ(0.0f, -1.0f);
    public static final VectorXZ north = forward;
    public static final VectorXZ right = east;
    public static final VectorXZ south = backward;
    public static final VectorXZ west = left;
    public static final VectorXZ zero = new VectorXZ(0.0f, 0.0f);
    private float x;
    private float z;

    public VectorXZ() {
        this.x = 0.0f;
        this.z = 0.0f;
    }

    public VectorXZ(float azimuth) {
        this.x = FastMath.cos((float)azimuth);
        this.z = FastMath.sin((float)azimuth);
    }

    public VectorXZ(Vector3f vector3D) {
        this.x = vector3D.x;
        this.z = vector3D.z;
    }

    public VectorXZ(float x, float z) {
        this.x = x;
        this.z = z;
    }

    public static void validateNonZero(ReadXZ vector, String description) {
        Validate.nonNull(vector, description);
        if (vector.isZero()) {
            String what = description == null ? "VectorXZ argument" : description;
            String message = String.format("%s must not be zero.", what);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public boolean aboutEquals(ReadXZ otherVector, float absoluteTolerance) {
        float otherZ;
        float dz;
        float otherX;
        float dx;
        Validate.nonNull(otherVector, "other vector");
        Validate.nonNegative(absoluteTolerance, "absolute tolerance");
        boolean result = this.equals(otherVector);
        if (!result && (dx = Math.abs(this.x - (otherX = otherVector.getX()))) <= absoluteTolerance && (dz = Math.abs(this.z - (otherZ = otherVector.getZ()))) <= absoluteTolerance) {
            result = true;
        }
        return result;
    }

    @Override
    public ReadXZ add(ReadXZ increment) {
        float sumZ;
        float sumX = this.x + increment.getX();
        VectorXZ sum = this.equals(sumX, sumZ = this.z + increment.getZ()) ? this : new VectorXZ(sumX, sumZ);
        return sum;
    }

    @Override
    public float azimuth() {
        float result = (float)Math.atan2(this.z, this.x);
        return result;
    }

    @Override
    public ReadXZ cardinalize() {
        float newZ;
        float newX;
        float absZ;
        if (this.isZero()) {
            return zero;
        }
        float absX = FastMath.abs((float)this.x);
        if (absX > (absZ = FastMath.abs((float)this.z))) {
            newX = FastMath.sign((float)this.x);
            newZ = 0.0f;
        } else {
            newX = 0.0f;
            newZ = FastMath.sign((float)this.z);
        }
        VectorXZ result = this.equals(newX, newZ) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public ReadXZ clampDirection(float maxAbsAngle) {
        float length;
        float minX;
        Validate.inRange(maxAbsAngle, "angle", 0.0f, (float)Math.PI);
        if (this.x >= 0.0f) {
            if (maxAbsAngle >= 1.5707964f) {
                return this;
            }
            if (this.z == 0.0f) {
                return this;
            }
        }
        if (this.x >= (minX = (length = this.length()) * FastMath.cos((float)maxAbsAngle))) {
            return this;
        }
        float newZ = length * FastMath.sin((float)maxAbsAngle);
        if (this.z < 0.0f) {
            newZ = -newZ;
        }
        VectorXZ result = new VectorXZ(minX, newZ);
        return result;
    }

    @Override
    public ReadXZ clampElliptical(float maxX, float maxZ) {
        Validate.nonNegative(maxX, "maximum X");
        Validate.nonNegative(maxZ, "maximum Z");
        if (this.isZero()) {
            return zero;
        }
        float length = this.length();
        float sineTheta = this.z / length;
        float cosineTheta = this.x / length;
        float aSin = maxX * sineTheta;
        float bCos = maxZ * cosineTheta;
        double denominator = MyMath.sumOfSquares(aSin, bCos);
        double product = maxX * maxZ;
        double rSquared = product * product / denominator;
        double lengthSquared = this.lengthSquared();
        if (lengthSquared <= rSquared) {
            return this;
        }
        float scale = (float)Math.sqrt(rSquared / lengthSquared);
        float clampedX = this.x * scale;
        float clampedZ = this.z * scale;
        VectorXZ result = new VectorXZ(clampedX, clampedZ);
        return result;
    }

    @Override
    public ReadXZ clampLength(float radius) {
        double dRadius;
        double rSquared;
        Validate.nonNegative(radius, "radius");
        if (this.isZero()) {
            return zero;
        }
        double lengthSquared = this.lengthSquared();
        if (lengthSquared <= (rSquared = (dRadius = (double)radius) * dRadius)) {
            return this;
        }
        float scale = (float)Math.sqrt(rSquared / lengthSquared);
        float clampedX = this.x * scale;
        float clampedZ = this.z * scale;
        VectorXZ result = new VectorXZ(clampedX, clampedZ);
        return result;
    }

    @Override
    public int compareTo(float hX, float hZ) {
        int result = Float.compare(this.x, hX);
        if (result == 0) {
            result = Float.compare(this.z, hZ);
        }
        return result;
    }

    @Override
    public double cosineAngleBetween(ReadXZ otherVector) {
        double z2;
        double x1 = this.x;
        double z1 = this.z;
        double lengthSquared = x1 * x1 + z1 * z1;
        double x2 = otherVector.getX();
        double otherLengthSquared = x2 * x2 + (z2 = (double)otherVector.getZ()) * z2;
        double lsProduct = lengthSquared * otherLengthSquared;
        if (lsProduct == 0.0) {
            return 1.0;
        }
        double dotProduct = x1 * x2 + z1 * z2;
        double cosine = dotProduct / Math.sqrt(lsProduct);
        cosine = MyMath.clamp(cosine, 1.0);
        return cosine;
    }

    @Override
    public float cross(ReadXZ otherVector) {
        float product = this.x * otherVector.getZ() - this.z * otherVector.getX();
        return product;
    }

    @Override
    public float directionError(ReadXZ directionGoal) {
        VectorXZ.validateNonZero(this, "this direction");
        VectorXZ.validateNonZero(directionGoal, "goal direction");
        float cross = this.cross(directionGoal);
        double dot = this.dot(directionGoal);
        if (dot >= 0.0) {
            double lpSquared = this.lengthSquared() * directionGoal.lengthSquared();
            float lengthProduct = (float)Math.sqrt(lpSquared);
            float sine = cross / lengthProduct;
            return sine;
        }
        if (cross > 0.0f) {
            return 1.0f;
        }
        return -1.0f;
    }

    @Override
    public ReadXZ divide(float scalar) {
        Validate.nonZero(scalar, "scalar");
        if (scalar == 1.0f) {
            return this;
        }
        float scaledX = this.x / scalar;
        float scaledZ = this.z / scalar;
        VectorXZ result = new VectorXZ(scaledX, scaledZ);
        return result;
    }

    @Override
    public double dot(ReadXZ otherVector) {
        double x1 = this.x;
        double x2 = otherVector.getX();
        double z1 = this.z;
        double z2 = otherVector.getZ();
        double product = x1 * x2 + z1 * z2;
        return product;
    }

    @Override
    public boolean equals(float hX, float hZ) {
        int compare = this.compareTo(hX, hZ);
        return compare == 0;
    }

    @Override
    public ReadXZ firstQuadrant() {
        if (this.isFirstQuadrant()) {
            return this;
        }
        float newX = FastMath.abs((float)this.x);
        float newZ = FastMath.abs((float)this.z);
        VectorXZ result = new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getZ() {
        return this.z;
    }

    @Override
    public ReadXZ interpolate(ReadXZ otherVector, float otherFraction) {
        float zBlend;
        float thisFraction = 1.0f - otherFraction;
        float xBlend = this.x * thisFraction + otherVector.getX() * otherFraction;
        VectorXZ blend = this.equals(xBlend, zBlend = this.z * thisFraction + otherVector.getZ() * otherFraction) ? this : new VectorXZ(xBlend, zBlend);
        return blend;
    }

    @Override
    public boolean isFirstQuadrant() {
        boolean result = this.x >= 0.0f && this.z >= 0.0f;
        return result;
    }

    @Override
    public boolean isZero() {
        boolean result = this.x == 0.0f && this.z == 0.0f;
        return result;
    }

    @Override
    public float length() {
        float result = MyMath.hypotenuse(this.x, this.z);
        return result;
    }

    @Override
    public double lengthSquared() {
        double result = MyMath.sumOfSquares(this.x, this.z);
        return result;
    }

    @Override
    public ReadXZ mirrorZ() {
        if (this.z == 0.0f) {
            return this;
        }
        VectorXZ result = new VectorXZ(this.x, -this.z);
        return result;
    }

    @Override
    public ReadXZ mult(float multiplier) {
        if (multiplier == 1.0f) {
            return this;
        }
        float scaledX = this.x * multiplier;
        float scaledZ = this.z * multiplier;
        VectorXZ result = new VectorXZ(scaledX, scaledZ);
        return result;
    }

    @Override
    public ReadXZ mult(ReadXZ multiplier) {
        float newZ;
        float sine;
        float cosine = multiplier.getX();
        float newX = cosine * this.x - (sine = multiplier.getZ()) * this.z;
        VectorXZ result = this.equals(newX, newZ = cosine * this.z + sine * this.x) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public ReadXZ negate() {
        if (this.isZero()) {
            return zero;
        }
        VectorXZ result = new VectorXZ(-this.x, -this.z);
        return result;
    }

    @Override
    public ReadXZ normalize() {
        float newZ;
        if (this.isZero()) {
            logger.info("Normalizing a zero vector.");
            return zero;
        }
        double lengthSquared = this.lengthSquared();
        if ((float)lengthSquared == 1.0f) {
            return this;
        }
        float length = (float)Math.sqrt(lengthSquared);
        float newX = this.x / length;
        VectorXZ result = this.equals(newX, newZ = this.z / length) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public ReadXZ rotate(float radians) {
        float newZ;
        float sine;
        if (radians == 0.0f) {
            return this;
        }
        float cosine = FastMath.cos((float)radians);
        float newX = cosine * this.x - (sine = FastMath.sin((float)radians)) * this.z;
        VectorXZ result = this.equals(newX, newZ = cosine * this.z + sine * this.x) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public ReadXZ scale(ReadXZ multiplier) {
        float newZ;
        float newX = this.x * multiplier.getX();
        VectorXZ result = this.equals(newX, newZ = this.z * multiplier.getZ()) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public ReadXZ subtract(ReadXZ decrement) {
        float newZ;
        float newX = this.x - decrement.getX();
        VectorXZ result = this.equals(newX, newZ = this.z - decrement.getZ()) ? this : new VectorXZ(newX, newZ);
        return result;
    }

    @Override
    public Quaternion toQuaternion() {
        Quaternion result = this.toQuaternion(null);
        return result;
    }

    @Override
    public Quaternion toQuaternion(Quaternion storeResult) {
        Quaternion result = storeResult == null ? new Quaternion() : storeResult;
        Vector3f direction = new Vector3f(-this.z, 0.0f, this.x);
        result.lookAt(direction, unitY);
        return result;
    }

    @Override
    public Vector3f toVector3f() {
        Vector3f result = this.toVector3f(0.0f, null);
        return result;
    }

    @Override
    public Vector3f toVector3f(float y) {
        Vector3f result = this.toVector3f(y, null);
        return result;
    }

    @Override
    public Vector3f toVector3f(float y, Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f(this.x, y, this.z) : storeResult.set(this.x, y, this.z);
        return result;
    }

    @Override
    public int compareTo(ReadXZ otherVector) {
        float otherX = otherVector.getX();
        int result = Float.compare(this.x, otherX);
        if (result == 0) {
            float otherZ = otherVector.getZ();
            result = Float.compare(this.z, otherZ);
        }
        return result;
    }

    public boolean equals(Object otherObject) {
        boolean result;
        if (this == otherObject) {
            result = true;
        } else if (otherObject != null && otherObject.getClass() == this.getClass()) {
            ReadXZ otherVector = (ReadXZ)otherObject;
            float otherX = otherVector.getX();
            float otherZ = otherVector.getZ();
            result = this.equals(otherX, otherZ);
        } else {
            result = false;
        }
        return result;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.x);
        hash = 71 * hash + Float.floatToIntBits(this.z);
        return hash;
    }

    public String toString() {
        String result = String.format("(x=%.3f, z=%.3f)", Float.valueOf(this.x), Float.valueOf(this.z));
        return result;
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.x = capsule.readFloat("x", 0.0f);
        this.z = capsule.readFloat("z", 0.0f);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.x, "x", 0.0f);
        capsule.write(this.z, "z", 0.0f);
    }
}

