/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math.noise;

import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.noise.Generator;
import jme3utilities.math.noise.Noise2;

public final class Noise {
    private static final Logger logger = Logger.getLogger(Noise.class.getName());
    private static final Generator generator = new Generator();

    private Noise() {
    }

    public static float fbmNoise(Noise2 noise2, float sampleX, float sampleY, int numOctaves, float fundamental, float gain, float lacunarity) {
        Validate.nonNull(noise2, "noise2");
        Validate.positive(numOctaves, "octaves");
        Validate.positive(fundamental, "fundamental");
        if (!(gain > 0.0f) || !(gain < 1.0f)) {
            logger.log(Level.SEVERE, "gain={0}", Float.valueOf(gain));
            throw new IllegalArgumentException("gain should be between 0 and 1");
        }
        if (!(lacunarity > 1.0f)) {
            logger.log(Level.SEVERE, "lacunarity={0}", Float.valueOf(lacunarity));
            throw new IllegalArgumentException("lacunarity should be greater than 1");
        }
        float amplitude = 1.0f;
        float frequency = fundamental;
        float total = 0.0f;
        for (int octave = 0; octave < numOctaves; ++octave) {
            float sample = noise2.sampleNormalized(sampleX * frequency, sampleY * frequency);
            total += amplitude * sample;
            frequency *= lacunarity;
            amplitude *= gain;
        }
        return total;
    }

    public static Generator getSharedGenerator() {
        return generator;
    }

    public static float nextFloat() {
        return generator.nextFloat();
    }

    public static void reseedGenerator(long newSeed) {
        generator.setSeed(newSeed);
    }
}

