/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math.noise;

import java.util.Random;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Permutation {
    private static final Logger logger = Logger.getLogger(Permutation.class.getName());
    private final int[] indices;

    public Permutation(int length, long seed) {
        Validate.inRange(length, "length", 2, Integer.MAX_VALUE);
        this.indices = new int[length];
        for (int i = 0; i < length; ++i) {
            this.indices[i] = i;
        }
        Random swapGenerator = new Random(seed);
        for (int sequential = 0; sequential < length; ++sequential) {
            int nextInt = swapGenerator.nextInt();
            int random = MyMath.modulo(nextInt, length);
            this.swapTableEntries(sequential, random);
        }
    }

    public int permute(int index) {
        int wrapped = MyMath.modulo(index, this.indices.length);
        int result = this.indices[wrapped];
        assert (result >= 0) : result;
        assert (result < this.indices.length) : result;
        return result;
    }

    private void swapTableEntries(int first, int second) {
        int savedValue = this.indices[first];
        this.indices[first] = this.indices[second];
        this.indices[second] = savedValue;
    }
}

