/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Dodecahedron
extends Mesh {
    public static final Logger logger = Logger.getLogger(Dodecahedron.class.getName());

    protected Dodecahedron() {
    }

    public Dodecahedron(float radius, Mesh.Mode mode) {
        Validate.positive(radius, "radius");
        Validate.nonNull(mode, "mode");
        float phi = MyMath.phi;
        float denom = MyMath.hypotenuse(2.0f, phi + 1.0f) / radius;
        float za = (phi + 1.0f) / denom;
        float xa0 = 2.0f / denom;
        float xa1 = xa0 * FastMath.cos((float)1.2566371f);
        float xa2 = xa0 * FastMath.cos((float)2.5132742f);
        float xa3 = xa0 * FastMath.cos((float)3.7699115f);
        float xa4 = xa0 * FastMath.cos((float)5.0265484f);
        float ya1 = xa0 * FastMath.sin((float)1.2566371f);
        float ya2 = xa0 * FastMath.sin((float)2.5132742f);
        float ya3 = xa0 * FastMath.sin((float)3.7699115f);
        float ya4 = xa0 * FastMath.sin((float)5.0265484f);
        float zb = (phi - 1.0f) / denom;
        float xb0 = 2.0f * phi / denom;
        float xb1 = phi * xa1;
        float xb2 = phi * xa2;
        float xb3 = phi * xa3;
        float xb4 = phi * xa4;
        float yb1 = phi * ya1;
        float yb2 = phi * ya2;
        float yb3 = phi * ya3;
        float yb4 = phi * ya4;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((float[])new float[]{xa0, 0.0f, za, xa1, ya1, za, xa2, ya2, za, xa3, ya3, za, xa4, ya4, za, xb0, 0.0f, zb, xb1, yb1, zb, xb2, yb2, zb, xb3, yb3, zb, xb4, yb4, zb, -xb0, 0.0f, -zb, -xb1, -yb1, -zb, -xb2, -yb2, -zb, -xb3, -yb3, -zb, -xb4, -yb4, -zb, -xa0, 0.0f, -za, -xa1, -ya1, -za, -xa2, -ya2, -za, -xa3, -ya3, -za, -xa4, -ya4, -za});
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        positionBuffer.clear();
        if (mode == Mesh.Mode.Lines) {
            IntBuffer indexBuffer = BufferUtils.createIntBuffer((int[])new int[]{0, 1, 1, 2, 2, 3, 3, 4, 4, 0, 0, 5, 1, 6, 2, 7, 3, 8, 4, 9, 5, 13, 6, 14, 7, 10, 8, 11, 9, 12, 5, 12, 6, 13, 7, 14, 8, 10, 9, 11, 10, 15, 11, 16, 12, 17, 13, 18, 14, 19, 15, 16, 16, 17, 17, 18, 18, 19, 19, 15});
            indexBuffer.clear();
            this.setBuffer(VertexBuffer.Type.Index, 2, indexBuffer);
        } else if (mode == Mesh.Mode.Triangles) {
            IntBuffer indexBuffer = BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 0, 2, 3, 0, 3, 4, 0, 5, 13, 0, 13, 6, 0, 6, 1, 1, 6, 14, 1, 14, 7, 1, 7, 2, 2, 7, 10, 2, 10, 8, 2, 8, 3, 3, 8, 11, 3, 11, 9, 3, 9, 4, 4, 9, 12, 4, 12, 5, 4, 5, 0, 5, 12, 17, 5, 17, 18, 5, 18, 13, 6, 13, 18, 6, 18, 19, 6, 19, 14, 7, 14, 19, 7, 19, 15, 7, 15, 10, 8, 10, 15, 8, 15, 16, 8, 16, 11, 9, 11, 16, 9, 16, 17, 9, 17, 12, 15, 19, 18, 15, 18, 17, 15, 17, 16});
            indexBuffer.clear();
            this.setBuffer(VertexBuffer.Type.Index, 3, indexBuffer);
        } else if (mode != Mesh.Mode.Points) {
            String message = "mode = " + mode;
            throw new IllegalArgumentException(message);
        }
        this.setMode(mode);
        this.updateBound();
        this.setStatic();
    }
}

