/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class LoopMesh
extends Mesh {
    private static final int numAxes = 3;
    private static final Logger logger = Logger.getLogger(LoopMesh.class.getName());

    protected LoopMesh() {
    }

    public LoopMesh(int vertexCount) {
        this(vertexCount, 1.0f);
    }

    public LoopMesh(int vertexCount, float radius) {
        Validate.inRange(vertexCount, "vertex count", 3, Integer.MAX_VALUE);
        Validate.nonNegative(radius, "radius");
        this.setMode(Mesh.Mode.LineLoop);
        this.updateCoordinates(vertexCount, radius);
        this.updateBound();
        this.setStatic();
    }

    public LoopMesh(Vector3f[] cornerArray) {
        Validate.nonNullArray(cornerArray, "corner array");
        int vertexCount = cornerArray.length;
        Validate.inRange(vertexCount, "length of corner array", 3, Integer.MAX_VALUE);
        this.setMode(Mesh.Mode.LineLoop);
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((Vector3f[])cornerArray);
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        this.updateBound();
        this.setStatic();
    }

    private void updateCoordinates(int vertexCount, float radius) {
        int numFloats = 3 * vertexCount;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        float increment = (float)Math.PI * 2 / (float)vertexCount;
        for (int vertexIndex = 0; vertexIndex < vertexCount; ++vertexIndex) {
            float longitude = increment * (float)vertexIndex;
            float x = radius * FastMath.cos((float)longitude);
            float z = radius * FastMath.sin((float)longitude);
            positionBuffer.put(x).put(0.0f).put(z);
        }
        positionBuffer.flip();
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
    }
}

