/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PointMesh
extends Mesh {
    private static final int numAxes = 3;
    private static final Logger logger = Logger.getLogger(PointMesh.class.getName());
    private final FloatBuffer fPositions = BufferUtils.createFloatBuffer((int)3);

    public PointMesh() {
        this.fPositions.clear();
        this.fPositions.put(0.0f);
        this.fPositions.put(0.0f);
        this.fPositions.put(0.0f);
        this.fPositions.flip();
        VertexBuffer vPositions = new VertexBuffer(VertexBuffer.Type.Position);
        vPositions.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)this.fPositions);
        this.setBuffer(vPositions);
        this.setMode(Mesh.Mode.Points);
        this.updateBound();
    }

    public void setLocation(Vector3f newLocation) {
        Validate.finite(newLocation, "new location");
        this.fPositions.clear();
        this.fPositions.put(newLocation.x);
        this.fPositions.put(newLocation.y);
        this.fPositions.put(newLocation.z);
        this.fPositions.flip();
        VertexBuffer positions = this.getBuffer(VertexBuffer.Type.Position);
        positions.updateData((Buffer)this.fPositions);
        this.updateBound();
    }
}

