/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RoundedRectangle
extends Mesh {
    private static final int epa = 4;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    private static final Logger logger = Logger.getLogger(RoundedRectangle.class.getName());

    public RoundedRectangle() {
        this(0.0f, 1.0f, 0.0f, 1.0f, 0.1f, 1.0f);
    }

    public RoundedRectangle(float x1, float x2, float y1, float y2, float cornerRadius, float zNorm) {
        float cos;
        float sin;
        float theta;
        int edge;
        Validate.nonNegative(cornerRadius, "corner radius");
        assert (x2 - x1 > 2.0f * cornerRadius) : cornerRadius;
        assert (y2 - y1 > 2.0f * cornerRadius) : cornerRadius;
        if (zNorm != -1.0f && zNorm != 1.0f) {
            logger.log(Level.SEVERE, "zNorm={0}", Float.valueOf(zNorm));
            throw new IllegalArgumentException("zNorm must be +1 or -1.");
        }
        this.setMode(Mesh.Mode.TriangleFan);
        int numVertices = 21;
        int numIndices = numVertices + 1;
        short[] indices = new short[numIndices];
        float[] normals = new float[3 * numVertices];
        float[] positions = new float[3 * numVertices];
        float[] texCoords = new float[2 * numVertices];
        positions[0] = (x1 + x2) / 2.0f;
        positions[1] = (y1 + y2) / 2.0f;
        int vIndex = 1;
        float centerX = x1 + cornerRadius;
        float centerY = y1 + cornerRadius;
        for (edge = 0; edge <= 4; ++edge) {
            theta = 1.5707964f * (float)edge / 4.0f;
            sin = FastMath.sin((float)theta);
            cos = FastMath.cos((float)theta);
            positions[3 * vIndex] = centerX - cornerRadius * cos;
            positions[3 * vIndex + 1] = centerY - cornerRadius * sin;
            ++vIndex;
        }
        centerX = x2 - cornerRadius;
        for (edge = 0; edge <= 4; ++edge) {
            theta = 1.5707964f * (float)edge / 4.0f;
            sin = FastMath.sin((float)theta);
            cos = FastMath.cos((float)theta);
            positions[3 * vIndex] = centerX + cornerRadius * sin;
            positions[3 * vIndex + 1] = centerY - cornerRadius * cos;
            ++vIndex;
        }
        centerY = y2 - cornerRadius;
        for (edge = 0; edge <= 4; ++edge) {
            theta = 1.5707964f * (float)edge / 4.0f;
            sin = FastMath.sin((float)theta);
            cos = FastMath.cos((float)theta);
            positions[3 * vIndex] = centerX + cornerRadius * cos;
            positions[3 * vIndex + 1] = centerY + cornerRadius * sin;
            ++vIndex;
        }
        centerX = x1 + cornerRadius;
        for (edge = 0; edge <= 4; ++edge) {
            theta = 1.5707964f * (float)edge / 4.0f;
            sin = FastMath.sin((float)theta);
            cos = FastMath.cos((float)theta);
            positions[3 * vIndex] = centerX - cornerRadius * sin;
            positions[3 * vIndex + 1] = centerY + cornerRadius * cos;
            ++vIndex;
        }
        assert (vIndex == numVertices) : vIndex;
        for (int vi = 0; vi < numVertices; ++vi) {
            indices[vi] = (short)vi;
            normals[3 * vi] = 0.0f;
            normals[3 * vi + 1] = 0.0f;
            normals[3 * vi + 2] = zNorm;
            positions[3 * vi + 2] = 0.0f;
            float x = positions[3 * vi];
            float y = positions[3 * vi + 1];
            texCoords[2 * vi] = (x - x1) / (x2 - x1);
            texCoords[2 * vi + 1] = (y - y1) / (y2 - y1);
        }
        indices[numVertices] = 1;
        this.setBuffer(VertexBuffer.Type.Normal, 3, normals);
        this.setBuffer(VertexBuffer.Type.Index, 3, indices);
        this.setBuffer(VertexBuffer.Type.Position, 3, positions);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texCoords);
        this.updateBound();
        this.setStatic();
    }
}

