/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class DecalManager {
    public static final Logger logger = Logger.getLogger(DecalManager.class.getName());
    private final Deque<Geometry> fifo = new LinkedList<Geometry>();
    private int maxTriangles = 9999;
    private int nextId = 0;
    private int totalTriangles = 0;
    private final Node decalNode = new Node("Decal Node");

    public void addCloneOf(Geometry active) {
        Geometry decal = (Geometry)active.deepClone();
        this.addDecal(decal);
    }

    public void addDecal(Geometry decal) {
        int triangleCount = decal.getTriangleCount();
        assert (triangleCount > 0) : triangleCount;
        decal.setName("decal #" + this.nextId);
        ++this.nextId;
        this.fifo.addLast(decal);
        this.decalNode.attachChild((Spatial)decal);
        this.totalTriangles += triangleCount;
        this.purge();
    }

    public int getMaxTriangles() {
        return this.maxTriangles;
    }

    public Node getNode() {
        return this.decalNode;
    }

    public void purge() {
        while (this.totalTriangles > this.maxTriangles) {
            Geometry oldest = this.fifo.removeFirst();
            oldest.removeFromParent();
            int count = oldest.getTriangleCount();
            this.totalTriangles -= count;
        }
    }

    public void removeAll() {
        this.fifo.clear();
        this.decalNode.detachAllChildren();
        this.totalTriangles = 0;
    }

    public void setMaxTriangles(int newLimit) {
        Validate.positive(newLimit, "new limit");
        this.maxTriangles = newLimit;
        this.purge();
    }

    public void translateAll(Vector3f offset) {
        Validate.finite(offset, "offset");
        for (Geometry geometry : this.fifo) {
            geometry.move(offset);
        }
    }
}

