/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.system.NullContext;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jme3utilities.Validate;

public final class DsUtils {
    public static final Logger logger;
    private static final Pattern dimensionsPattern;
    private static final boolean hasLwjglVersion2;
    private static final boolean hasLwjglVersion3;
    private static final Field lwjglListenerField;
    private static final Field nullListenerField;
    private static final Method get;
    private static final Method getBitsPerPixel;
    private static final Method getBlueBits;
    private static final Method getFrequency;
    private static final Method getGreenBits;
    private static final Method getMode;
    private static final Method getModeHeight;
    private static final Method getModeWidth;
    private static final Method getModes;
    private static final Method getPrimaryMonitor;
    private static final Method getRedBits;
    private static final Method hasRemaining;

    private DsUtils() {
    }

    public static String describeDimensions(int width, int height) {
        Validate.positive(width, "width");
        Validate.positive(height, "height");
        String result = String.format("%d x %d", width, height);
        return result;
    }

    public static String describeMsaaFactor(int factor) {
        String description = factor <= 1 ? "disabled" : String.format("%dx", factor);
        return description;
    }

    public static DisplayMode displayMode() {
        DisplayMode result;
        if (hasLwjglVersion2) {
            result = DsUtils.displayMode2();
        } else if (hasLwjglVersion3) {
            result = DsUtils.displayMode3();
        } else {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            result = device.getDisplayMode();
        }
        return result;
    }

    public static boolean hasLwjglVersion3() {
        return hasLwjglVersion3;
    }

    public static List<DisplayMode> listDisplayModes() {
        List<DisplayMode> result;
        if (hasLwjglVersion2) {
            result = DsUtils.listDisplayModes2();
        } else if (hasLwjglVersion3) {
            result = DsUtils.listDisplayModes3();
        } else {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            DisplayMode[] modeArray = device.getDisplayModes();
            result = Arrays.asList(modeArray);
        }
        return result;
    }

    public static int[] parseDimensions(String description) {
        Validate.nonEmpty(description, "text");
        String lcText = description.toLowerCase(Locale.ROOT);
        Matcher matcher = dimensionsPattern.matcher(lcText);
        int[] result = null;
        if (matcher.find()) {
            result = new int[2];
            String widthText = matcher.group(1);
            result[0] = Integer.parseInt(widthText);
            String heightText = matcher.group(2);
            result[1] = Integer.parseInt(heightText);
        }
        return result;
    }

    private static DisplayMode displayMode2() {
        assert (hasLwjglVersion2);
        try {
            Object glMode = getMode.invoke(null, new Object[0]);
            DisplayMode result = DsUtils.makeDisplayMode2(glMode);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static DisplayMode displayMode3() {
        assert (hasLwjglVersion3);
        try {
            Object monitorId = getPrimaryMonitor.invoke(null, new Object[0]);
            Object vidMode = getMode.invoke(null, monitorId);
            DisplayMode result = DsUtils.makeDisplayMode3(vidMode);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static List<DisplayMode> listDisplayModes2() {
        assert (hasLwjglVersion2);
        try {
            Object[] glModes = (Object[])getModes.invoke(null, new Object[0]);
            ArrayList<DisplayMode> result = new ArrayList<DisplayMode>(glModes.length);
            for (Object glMode : glModes) {
                DisplayMode mode = DsUtils.makeDisplayMode2(glMode);
                result.add(mode);
            }
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static List<DisplayMode> listDisplayModes3() {
        assert (hasLwjglVersion3);
        try {
            Object monitorId = getPrimaryMonitor.invoke(null, new Object[0]);
            if (monitorId == null || 0L == (Long)monitorId) {
                return new ArrayList<DisplayMode>(1);
            }
            Object buf = getModes.invoke(null, monitorId);
            ArrayList<DisplayMode> result = new ArrayList<DisplayMode>(32);
            while (((Boolean)hasRemaining.invoke(buf, new Object[0])).booleanValue()) {
                Object vidMode = get.invoke(buf, new Object[0]);
                DisplayMode mode = DsUtils.makeDisplayMode3(vidMode);
                result.add(mode);
            }
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static DisplayMode makeDisplayMode2(Object glMode) throws IllegalAccessException, InvocationTargetException {
        assert (hasLwjglVersion2);
        int width = (Integer)getModeWidth.invoke(glMode, new Object[0]);
        int height = (Integer)getModeHeight.invoke(glMode, new Object[0]);
        int bitDepth = (Integer)getBitsPerPixel.invoke(glMode, new Object[0]);
        int rate = (Integer)getFrequency.invoke(glMode, new Object[0]);
        DisplayMode result = new DisplayMode(width, height, bitDepth, rate);
        return result;
    }

    private static DisplayMode makeDisplayMode3(Object glfwVidMode) throws IllegalAccessException, InvocationTargetException {
        assert (hasLwjglVersion3);
        int width = (Integer)getModeWidth.invoke(glfwVidMode, new Object[0]);
        int height = (Integer)getModeHeight.invoke(glfwVidMode, new Object[0]);
        int redBits = (Integer)getRedBits.invoke(glfwVidMode, new Object[0]);
        int greenBits = (Integer)getGreenBits.invoke(glfwVidMode, new Object[0]);
        int blueBits = (Integer)getBlueBits.invoke(glfwVidMode, new Object[0]);
        int rate = (Integer)getFrequency.invoke(glfwVidMode, new Object[0]);
        int bitDepth = redBits + greenBits + blueBits;
        DisplayMode result = new DisplayMode(width, height, bitDepth, rate);
        return result;
    }

    static {
        boolean foundVersion3;
        boolean foundVersion2;
        logger = Logger.getLogger(DsUtils.class.getName());
        dimensionsPattern = Pattern.compile("^\\s*(\\d+)\\s*[x,]\\s*(\\d+)\\s*");
        try {
            Class.forName("org.lwjgl.opengl.Display");
            foundVersion2 = true;
        }
        catch (ClassNotFoundException exception) {
            foundVersion2 = false;
        }
        hasLwjglVersion2 = foundVersion2;
        try {
            Class.forName("com.jme3.system.lwjgl.LwjglWindow");
            foundVersion3 = true;
        }
        catch (ClassNotFoundException exception) {
            foundVersion3 = false;
        }
        hasLwjglVersion3 = foundVersion3;
        try {
            Class<?> contextClass = Class.forName("com.jme3.system.lwjgl.LwjglContext");
            lwjglListenerField = contextClass.getDeclaredField("listener");
            lwjglListenerField.setAccessible(true);
            nullListenerField = NullContext.class.getDeclaredField("listener");
            nullListenerField.setAccessible(true);
            if (foundVersion2) {
                get = null;
                getBlueBits = null;
                getGreenBits = null;
                getPrimaryMonitor = null;
                getRedBits = null;
                hasRemaining = null;
                Class<?> displayClass = Class.forName("org.lwjgl.opengl.Display");
                getMode = displayClass.getDeclaredMethod("getDesktopDisplayMode", new Class[0]);
                getModes = displayClass.getDeclaredMethod("getAvailableDisplayModes", new Class[0]);
                Class<?> displayModeClass = Class.forName("org.lwjgl.opengl.DisplayMode");
                getBitsPerPixel = displayModeClass.getDeclaredMethod("getBitsPerPixel", new Class[0]);
                getFrequency = displayModeClass.getDeclaredMethod("getFrequency", new Class[0]);
                getModeHeight = displayModeClass.getDeclaredMethod("getHeight", new Class[0]);
                getModeWidth = displayModeClass.getDeclaredMethod("getWidth", new Class[0]);
            } else if (foundVersion3) {
                getBitsPerPixel = null;
                Class<?> glfwClass = Class.forName("org.lwjgl.glfw.GLFW");
                getMode = glfwClass.getDeclaredMethod("glfwGetVideoMode", Long.TYPE);
                getModes = glfwClass.getDeclaredMethod("glfwGetVideoModes", Long.TYPE);
                getPrimaryMonitor = glfwClass.getDeclaredMethod("glfwGetPrimaryMonitor", new Class[0]);
                Class<?> vidModeClass = Class.forName("org.lwjgl.glfw.GLFWVidMode");
                getBlueBits = vidModeClass.getDeclaredMethod("blueBits", new Class[0]);
                getFrequency = vidModeClass.getDeclaredMethod("refreshRate", new Class[0]);
                getGreenBits = vidModeClass.getDeclaredMethod("greenBits", new Class[0]);
                getModeHeight = vidModeClass.getDeclaredMethod("height", new Class[0]);
                getModeWidth = vidModeClass.getDeclaredMethod("width", new Class[0]);
                getRedBits = vidModeClass.getDeclaredMethod("redBits", new Class[0]);
                Class<?>[] vmInnerClasses = vidModeClass.getDeclaredClasses();
                assert (vmInnerClasses.length == 1) : vmInnerClasses.length;
                Class<?> vmBufferClass = vmInnerClasses[0];
                get = vmBufferClass.getMethod("get", new Class[0]);
                hasRemaining = vmBufferClass.getMethod("hasRemaining", new Class[0]);
            } else {
                get = null;
                getBitsPerPixel = null;
                getBlueBits = null;
                getFrequency = null;
                getGreenBits = null;
                getMode = null;
                getModeHeight = null;
                getModeWidth = null;
                getModes = null;
                getPrimaryMonitor = null;
                getRedBits = null;
                hasRemaining = null;
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
    }
}

