/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.input.InputManager;
import com.jme3.input.KeyInput;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.ViewPort;
import com.jme3.util.clone.Cloner;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.IntPair;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.Vector3i;
import jme3utilities.math.VectorXZ;

public final class Heart {
    private static final Logger logger = Logger.getLogger(Heart.class.getName());
    private static FileHandler fileHandler = null;

    private Heart() {
    }

    public static boolean areAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public static boolean browseWeb(String startUriString) {
        Validate.nonNull(startUriString, "start uri");
        boolean success = false;
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                URI startUri = new URI(startUriString);
                Desktop.getDesktop().browse(startUri);
                success = true;
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static <T> T deepCopy(T object) {
        Object copy = object == null ? null : (object instanceof Cloneable || object.getClass().isArray() ? Cloner.deepClone(object) : (object instanceof Boolean || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Enum || object instanceof Float || object instanceof Integer || object instanceof IntPair || object instanceof Long || object instanceof RectangularSolid || object instanceof Short || object instanceof String || object instanceof Vector3i || object instanceof VectorXZ ? object : Cloner.deepClone(object)));
        return (T)copy;
    }

    public static void deleteStoredSettings(String applicationName) {
        try {
            if (Preferences.userRoot().nodeExists(applicationName)) {
                Preferences.userRoot().node(applicationName).removeNode();
                logger.log(Level.WARNING, "The stored settings for \"{0}\" were deleted.", applicationName);
            } else {
                logger.log(Level.WARNING, "No stored settings were found for \"{0}\".", applicationName);
            }
        }
        catch (BackingStoreException exception) {
            logger.log(Level.SEVERE, "The stored settings for \"{0}\" are inaccessible.", applicationName);
        }
    }

    public static <T extends AppState> void detachAll(AppStateManager stateManager, Class<T> whichClass) {
        Validate.nonNull(whichClass, "class");
        AppState state = stateManager.getState(whichClass);
        while (state != null) {
            stateManager.detach(state);
            state = stateManager.getState(whichClass);
        }
    }

    public static Map<String, File> driveMap() {
        File[] roots;
        TreeMap<String, File> result = new TreeMap<String, File>();
        for (File root : roots = File.listRoots()) {
            if (!root.isDirectory()) continue;
            String absoluteDirPath = Heart.fixedPath(root);
            File oldFile = result.put(absoluteDirPath, root);
            assert (oldFile == null) : oldFile;
        }
        return result;
    }

    public static <T> T first(Collection<T> collection) {
        Object result = null;
        if (!collection.isEmpty()) {
            Object[] members = collection.toArray(new Object[0]);
            result = members[0];
        }
        return (T)result;
    }

    public static String fixedPath(File inputFile) {
        String result;
        Validate.nonNull(inputFile, "input file");
        try {
            result = inputFile.getCanonicalPath();
        }
        catch (IOException exception) {
            result = inputFile.getAbsolutePath();
        }
        result = result.replaceAll("\\\\", "/");
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public static String fixPath(String inputPath) {
        Validate.nonEmpty(inputPath, "input path");
        File file = new File(inputPath);
        String result = Heart.fixedPath(file);
        return result;
    }

    public static FileHandler getFileHandler() {
        if (fileHandler == null) {
            Calendar rightNow = Calendar.getInstance();
            int hours = rightNow.get(11);
            int minutes = rightNow.get(12);
            int seconds = rightNow.get(13);
            String hhmmss = String.format("%02d%02d%02d", hours, minutes, seconds);
            String fileName = hhmmss + ".txt";
            try {
                fileHandler = new FileHandler(fileName);
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
            SimpleFormatter formatter = new SimpleFormatter();
            fileHandler.setFormatter(formatter);
            File file = new File(fileName);
            String filePath = Heart.fixedPath(file);
            System.out.println("logging to file " + MyString.quote(filePath));
        }
        return fileHandler;
    }

    public static FilterPostProcessor getFpp(ViewPort viewPort, AssetManager assetManager, int numSamples) {
        Validate.nonNull(viewPort, "viewport");
        Validate.nonNull(assetManager, "asset manager");
        Validate.inRange(numSamples, "number of samples", 0, 16);
        for (SceneProcessor processor : viewPort.getProcessors()) {
            if (!(processor instanceof FilterPostProcessor)) continue;
            return (FilterPostProcessor)processor;
        }
        FilterPostProcessor fpp = new FilterPostProcessor(assetManager);
        if (numSamples > 0) {
            fpp.setNumSamples(numSamples);
        }
        viewPort.addProcessor((SceneProcessor)fpp);
        return fpp;
    }

    public static KeyInput getKeyInput(InputManager inputManager) {
        KeyInput result;
        Field keyInputField;
        try {
            keyInputField = InputManager.class.getDeclaredField("keys");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        keyInputField.setAccessible(true);
        try {
            result = (KeyInput)keyInputField.get(inputManager);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static boolean hasStoredSettings(String applicationName) {
        try {
            if (Preferences.userRoot().nodeExists(applicationName)) {
                return true;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return false;
    }

    public static String homePath(String fileName) {
        Validate.nonEmpty(fileName, "file name");
        String homePath = System.getProperty("user.home");
        File file = new File(homePath, fileName);
        String result = Heart.fixedPath(file);
        return result;
    }

    public static List<String> listZipEntries(String zipPath, String namePrefix) {
        Validate.nonEmpty(zipPath, "zip path");
        Validate.nonNull(namePrefix, "name prefix");
        ArrayList<String> result = new ArrayList<String>(90);
        try (FileInputStream fileIn = new FileInputStream(zipPath);
             ZipInputStream zipIn = new ZipInputStream(fileIn);){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String entryName = "/" + entry.getName();
                if (entryName.startsWith(namePrefix)) {
                    result.add(entryName);
                }
                entry = zipIn.getNextEntry();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String loadResourceAsString(String resourceName) {
        String result;
        InputStream stream = Heart.class.getResourceAsStream(resourceName);
        if (stream == null) {
            String quotedName = MyString.quote(resourceName);
            throw new RuntimeException("resource not found:  " + quotedName);
        }
        String charsetName = StandardCharsets.UTF_8.name();
        try (Scanner scanner = new Scanner(stream, charsetName);){
            scanner.useDelimiter("\\Z");
            result = scanner.next();
        }
        return result;
    }

    public static void parseAppArgs(SimpleApplication application, String ... arguments) {
        boolean showSettingsDialog = false;
        Level loggingLevel = Level.WARNING;
        String[] stringArray = arguments;
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String arg;
            switch (arg = stringArray[i]) {
                case "-s": 
                case "--showSettingsDialog": {
                    showSettingsDialog = true;
                    continue block10;
                }
                case "-v": 
                case "--verbose": {
                    loggingLevel = Level.INFO;
                    continue block10;
                }
                default: {
                    logger.log(Level.INFO, "Unknown command-line argument {0} skipped", MyString.quote(arg));
                }
            }
        }
        Heart.setLoggingLevels(loggingLevel);
        application.setShowSettings(showSettingsDialog);
    }

    public static void setGrayPixel(Graphics2D graphics, int x, int y, float brightness, float opacity) {
        GraphicsConfiguration configuration = graphics.getDeviceConfiguration();
        Rectangle bounds = configuration.getBounds();
        Validate.inRange(x, "X coordinate", 0, bounds.width - 1);
        Validate.inRange(y, "Y coordinate", 0, bounds.height - 1);
        Validate.fraction(brightness, "brightness");
        Validate.fraction(opacity, "opacity");
        Color color = new Color(brightness, brightness, brightness, opacity);
        graphics.setColor(color);
        graphics.fillRect(x, y, 1, 1);
    }

    public static void setLoggingLevels(Level newLevel) {
        Validate.nonNull(newLevel, "level");
        Logger.getLogger("").setLevel(newLevel);
    }

    public static String version() {
        return "Heart Heart master $Rev: 9.1.0 $";
    }

    public static String versionShort() {
        String verbose = Heart.version();
        String[] words = verbose.split("\\s+");
        assert (words.length == 6) : words.length;
        String result = String.format("%s %s", words[2], words[4]);
        assert (!result.isEmpty());
        return result;
    }

    public static void writeImage(String filePath, RenderedImage image) throws IOException {
        Validate.nonEmpty(filePath, "path");
        Validate.nonNull(image, "image");
        String formatName = "png";
        String lowerCase = filePath.toLowerCase();
        if (lowerCase.endsWith(".bmp")) {
            formatName = "bmp";
        } else if (lowerCase.endsWith(".gif")) {
            formatName = "gif";
        } else if (lowerCase.endsWith(".jpg") || lowerCase.endsWith(".jpeg")) {
            formatName = "jpeg";
        }
        boolean hasAlpha = image.getColorModel().hasAlpha();
        if (hasAlpha && (formatName.equals("bmp") || formatName.equals("jpeg"))) {
            logger.log(Level.SEVERE, "unable to write alpha channel to a {0}", formatName.toUpperCase());
        }
        String quotedPath = MyString.quote(filePath);
        File textureFile = new File(filePath);
        try {
            boolean success;
            File parentDirectory = textureFile.getParentFile();
            if (parentDirectory != null && !parentDirectory.exists() && !(success = parentDirectory.mkdirs())) {
                String parentPath = parentDirectory.toString();
                quotedPath = MyString.quote(parentPath);
                throw new IOException("Unable to create " + quotedPath);
            }
            success = ImageIO.write(image, formatName, textureFile);
            if (!success) {
                logger.log(Level.SEVERE, "write to {0} failed; no writer for {1} format", new Object[]{quotedPath, MyString.quote(formatName)});
            }
            if (logger.isLoggable(Level.INFO)) {
                int height = image.getHeight();
                int width = image.getWidth();
                logger.log(Level.INFO, "wrote {0}-by-{1} texture to {2}", new Object[]{width, height, quotedPath});
            }
        }
        catch (IOException exception) {
            logger.log(Level.SEVERE, "write to {0} failed", quotedPath);
            boolean success = textureFile.delete();
            if (success) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "deleted file {0}", quotedPath);
                }
            } else {
                logger.log(Level.SEVERE, "deletion of {0} failed", quotedPath);
            }
            throw exception;
        }
    }

    public static void writeJ3O(String filePath, Savable savable) {
        Validate.nonEmpty(filePath, "file path");
        Validate.nonNull(savable, "savable");
        BinaryExporter exporter = BinaryExporter.getInstance();
        File file = new File(filePath);
        try {
            exporter.save(savable, file);
        }
        catch (IOException exception) {
            logger.log(Level.SEVERE, "write to {0} failed", MyString.quote(filePath));
            throw new RuntimeException(exception);
        }
        if (logger.isLoggable(Level.INFO)) {
            int version = 2;
            logger.log(Level.INFO, "wrote version-{0} binary to {1}", new Object[]{version, MyString.quote(filePath)});
        }
    }
}

