/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.input.InputManager;
import com.jme3.math.FastMath;
import com.jme3.math.Line;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;
import jme3utilities.math.MyVector3f;

public final class MyCamera {
    public static final float farZ = 1.0f;
    public static final float nearZ = 0.0f;
    private static final Logger logger = Logger.getLogger(MyCamera.class.getName());
    private static final Vector3f unitX = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f unitY = new Vector3f(0.0f, 1.0f, 0.0f);

    private MyCamera() {
    }

    public static float azimuth(Camera camera) {
        Vector3f direction = camera.getDirection();
        float result = MyVector3f.azimuth(direction);
        return result;
    }

    public static boolean contains(ViewPort viewPort, Vector2f screenXY) {
        Camera camera = viewPort.getCamera();
        float xFraction = screenXY.x / (float)camera.getWidth();
        float leftX = camera.getViewPortLeft();
        float rightX = camera.getViewPortRight();
        boolean result = false;
        if (xFraction >= leftX && xFraction < rightX) {
            float yFraction = screenXY.y / (float)camera.getHeight();
            float bottomY = camera.getViewPortBottom();
            float topY = camera.getViewPortTop();
            if (yFraction >= bottomY && yFraction < topY) {
                result = true;
            }
        }
        return result;
    }

    public static String describe(Camera camera) {
        String result;
        if (camera == null) {
            result = "null";
        } else {
            String name = camera.getName();
            Vector3f location = camera.getLocation();
            String locString = MyVector3f.describe(location);
            Vector3f direction = camera.getDirection();
            String dirString = MyVector3f.describeDirection(direction);
            result = String.format("camera%s (%s; %s)", MyString.quoteName(name), locString, dirString);
        }
        return result;
    }

    public static String describeMore(Camera camera) {
        StringBuilder builder = new StringBuilder(100);
        String projection = camera.isParallelProjection() ? "para" : "persp";
        builder.append(projection);
        builder.append(" F");
        float frustrumAspectRatio = MyCamera.frustumAspectRatio(camera);
        builder.append(MyString.describeFraction(frustrumAspectRatio));
        builder.append(":1 V");
        float viewAspectRatio = MyCamera.viewAspectRatio(camera);
        builder.append(MyString.describeFraction(viewAspectRatio));
        builder.append(":1");
        if (camera.isParallelProjection()) {
            builder.append(" fx[");
            float left = camera.getFrustumLeft();
            float right = camera.getFrustumRight();
            builder.append(MyString.describe(left));
            builder.append(' ');
            builder.append(MyString.describe(right));
            builder.append("] fy[");
            float bottom = camera.getFrustumBottom();
            float top = camera.getFrustumTop();
            builder.append(MyString.describe(bottom));
            builder.append(' ');
            builder.append(MyString.describe(top));
            builder.append(']');
        }
        builder.append(" fz[");
        float near = camera.getFrustumNear();
        float far = camera.getFrustumFar();
        builder.append(MyString.describe(near));
        builder.append(' ');
        builder.append(MyString.describe(far));
        builder.append("] vx[");
        float left = camera.getViewPortLeft();
        float right = camera.getViewPortRight();
        builder.append(MyString.describeFraction(left));
        builder.append(' ');
        builder.append(MyString.describeFraction(right));
        builder.append("] vy[");
        float bottom = camera.getViewPortBottom();
        float top = camera.getViewPortTop();
        builder.append(MyString.describeFraction(bottom));
        builder.append(' ');
        builder.append(MyString.describeFraction(top));
        builder.append("] ");
        int dWidth = camera.getWidth();
        builder.append(dWidth);
        builder.append('x');
        int dHeight = camera.getHeight();
        builder.append(dHeight);
        if (!camera.isParallelProjection()) {
            builder.append(" fovDeg[x=");
            float xDegrees = MyCamera.xDegrees(camera);
            float yDegrees = MyCamera.yDegrees(camera);
            builder.append(MyString.describe(xDegrees));
            builder.append(" y=");
            builder.append(MyString.describe(yDegrees));
            builder.append(']');
        }
        String result = builder.toString();
        return result;
    }

    public static float displayAspectRatio(Camera camera) {
        float height = camera.getHeight();
        assert (height > 0.0f) : height;
        float width = camera.getWidth();
        assert (width > 0.0f) : width;
        float result = width / height;
        assert (result > 0.0f) : result;
        return result;
    }

    public static float fovX(Camera camera) {
        Validate.nonNull(camera, "camera");
        float xTangent = MyCamera.xTangent(camera);
        float result = 2.0f * FastMath.atan((float)xTangent);
        return result;
    }

    public static float fovY(Camera camera) {
        Validate.nonNull(camera, "camera");
        float yTangent = MyCamera.yTangent(camera);
        float result = 2.0f * FastMath.atan((float)yTangent);
        return result;
    }

    public static float frustumAspectRatio(Camera camera) {
        float height = camera.getFrustumTop() - camera.getFrustumBottom();
        assert (height > 0.0f) : height;
        float width = camera.getFrustumRight() - camera.getFrustumLeft();
        assert (width > 0.0f) : width;
        float result = width / height;
        assert (result > 0.0f) : result;
        return result;
    }

    public static boolean isFullWidth(Camera camera) {
        float leftEdge = camera.getViewPortLeft();
        float rightEdge = camera.getViewPortRight();
        boolean result = leftEdge <= 0.0f && rightEdge >= 1.0f;
        return result;
    }

    public static List<ViewPort> listViewPorts(RenderManager renderManager, Vector2f screenXY) {
        Validate.nonNull(screenXY, "screen xy");
        ArrayList<ViewPort> result = new ArrayList<ViewPort>(4);
        List preViews = renderManager.getPreViews();
        for (Object preView : preViews) {
            if (!MyCamera.contains((ViewPort)preView, screenXY)) continue;
            result.add((ViewPort)preView);
        }
        List mainViews = renderManager.getMainViews();
        for (ViewPort mainView : mainViews) {
            if (!MyCamera.contains(mainView, screenXY)) continue;
            result.add(mainView);
        }
        List postViews = renderManager.getPostViews();
        for (ViewPort postView : postViews) {
            if (!MyCamera.contains(postView, screenXY)) continue;
            result.add(postView);
        }
        return result;
    }

    public static void look(Camera camera, Vector3f direction) {
        Validate.nonZero(direction, "new direction");
        if (direction.x == 0.0f && direction.z == 0.0f) {
            camera.lookAtDirection(direction, unitX);
        } else {
            camera.lookAtDirection(direction, unitY);
        }
    }

    public static Line mouseLine(Camera camera, InputManager inputManager) {
        Vector2f screenXY = inputManager.getCursorPosition();
        Vector3f vertex = camera.getWorldCoordinates(screenXY, 0.0f);
        Vector3f far = camera.getWorldCoordinates(screenXY, 1.0f);
        Vector3f direction = far.subtract(vertex);
        Line result = new Line(vertex, direction);
        return result;
    }

    public static Ray mouseRay(Camera camera, InputManager inputManager) {
        Vector2f screenXY = inputManager.getCursorPosition();
        Vector3f vertex = camera.getWorldCoordinates(screenXY, 0.0f);
        Vector3f far = camera.getWorldCoordinates(screenXY, 1.0f);
        Vector3f direction = far.subtract(vertex);
        MyVector3f.normalizeLocal(direction);
        Ray result = new Ray(vertex, direction);
        return result;
    }

    public static void setNearFar(Camera camera, float newNear, float newFar) {
        Validate.positive(newNear, "near");
        if (!(newFar > newNear)) {
            logger.log(Level.SEVERE, "far={0} near={1}", new Object[]{Float.valueOf(newFar), Float.valueOf(newNear)});
            throw new IllegalArgumentException("far should be greater than near");
        }
        if (camera.isParallelProjection()) {
            camera.setFrustumFar(newFar);
            camera.setFrustumNear(newNear);
        } else {
            float fAspect = MyCamera.frustumAspectRatio(camera);
            float yDegrees = MyCamera.yDegrees(camera);
            camera.setFrustumPerspective(yDegrees, fAspect, newNear, newFar);
        }
    }

    public static void setYTangent(Camera camera, float newTangent) {
        Validate.nonNull(camera, "camera");
        Validate.positive(newTangent, "tangent");
        if (camera.isParallelProjection()) {
            throw new IllegalArgumentException("camera must have perspective enabled");
        }
        float yTangent = MyCamera.yTangent(camera);
        float factor = newTangent / yTangent;
        MyCamera.zoom(camera, factor);
    }

    public static float viewAspectRatio(Camera camera) {
        float bottom = camera.getViewPortBottom();
        assert (bottom >= 0.0f) : bottom;
        assert (bottom <= 1.0f) : bottom;
        float top = camera.getViewPortTop();
        assert (top >= 0.0f) : top;
        assert (top <= 1.0f) : top;
        float yFraction = top - bottom;
        assert (yFraction > 0.0f) : yFraction;
        float height = (float)camera.getHeight() * yFraction;
        assert (height > 0.0f) : height;
        float left = camera.getViewPortLeft();
        assert (left >= 0.0f) : left;
        assert (left <= 1.0f) : left;
        float right = camera.getViewPortRight();
        assert (right >= 0.0f) : right;
        assert (right <= 1.0f) : right;
        float xFraction = right - left;
        assert (xFraction > 0.0f) : xFraction;
        float width = (float)camera.getWidth() * xFraction;
        assert (width > 0.0f) : width;
        float result = width / height;
        assert (result > 0.0f) : result;
        return result;
    }

    public static float xDegrees(Camera camera) {
        if (camera.isParallelProjection()) {
            return 0.0f;
        }
        float xTangent = MyCamera.xTangent(camera);
        float xRadians = 2.0f * FastMath.atan((float)xTangent);
        float result = MyMath.toDegrees(xRadians);
        return result;
    }

    public static float xTangent(Camera camera) {
        float result;
        if (camera.isParallelProjection()) {
            result = 0.0f;
        } else {
            float near = camera.getFrustumNear();
            assert (near > 0.0f) : near;
            float width = camera.getFrustumRight() - camera.getFrustumLeft();
            assert (width > 0.0f) : width;
            float halfWidth = width / 2.0f;
            result = halfWidth / near;
            assert (result > 0.0f) : result;
        }
        return result;
    }

    public static float yDegrees(Camera camera) {
        if (camera.isParallelProjection()) {
            return 0.0f;
        }
        float yTangent = MyCamera.yTangent(camera);
        float yRadians = 2.0f * FastMath.atan((float)yTangent);
        float result = MyMath.toDegrees(yRadians);
        return result;
    }

    public static float yTangent(Camera camera) {
        float result;
        if (camera.isParallelProjection()) {
            result = 0.0f;
        } else {
            float near = camera.getFrustumNear();
            assert (near > 0.0f) : near;
            float height = camera.getFrustumTop() - camera.getFrustumBottom();
            assert (height > 0.0f) : height;
            float halfHeight = height / 2.0f;
            result = halfHeight / near;
            assert (result > 0.0f) : result;
        }
        return result;
    }

    public static void zoom(Camera camera, float factor) {
        Validate.positive(factor, "factor");
        float bottom = camera.getFrustumBottom();
        camera.setFrustumBottom(bottom * factor);
        float left = camera.getFrustumLeft();
        camera.setFrustumLeft(left * factor);
        float right = camera.getFrustumRight();
        camera.setFrustumRight(right * factor);
        float top = camera.getFrustumTop();
        camera.setFrustumTop(top * factor);
    }
}

