/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;

public class NameGenerator
implements Savable {
    private static final char separator = '.';
    private static final int firstSequenceNumber = 1;
    private static final Logger logger = Logger.getLogger(NameGenerator.class.getName());
    private final Map<String, Integer> nextSequenceNumbers = new TreeMap<String, Integer>();

    public static String getPrefix(String name) {
        int separatorIndex = name.indexOf(46);
        if (separatorIndex < 0) {
            return null;
        }
        String prefix = name.substring(0, separatorIndex);
        return prefix;
    }

    public static boolean isFrom(String name, String prefix) {
        int separatorIndex = name.indexOf(46);
        if (separatorIndex == -1) {
            return false;
        }
        String pre = name.substring(0, separatorIndex);
        if (!pre.equals(prefix)) {
            return false;
        }
        int length = name.length();
        String post = name.substring(separatorIndex + 1, length);
        boolean result = post.matches("^\\d+$");
        return result;
    }

    public void reset() {
        this.nextSequenceNumbers.clear();
    }

    public String unique(String prefix) {
        int separatorIndex = prefix.indexOf(46);
        if (separatorIndex >= 0) {
            logger.log(Level.SEVERE, "prefix={0}", MyString.quote(prefix));
            String message = String.format("prefix must not contain the separator '%c'", Character.valueOf('.'));
            throw new IllegalArgumentException(message);
        }
        Integer sequenceNumber = this.nextSequenceNumbers.get(prefix);
        if (sequenceNumber == null) {
            sequenceNumber = 1;
        }
        this.nextSequenceNumbers.put(prefix, sequenceNumber + 1);
        String sequenceString = String.valueOf(sequenceNumber);
        String name = prefix + '.' + sequenceString;
        return name;
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        String[] keys = capsule.readStringArray("keys", null);
        int[] values = capsule.readIntArray("values", null);
        int size = keys.length;
        assert (values.length == size) : size;
        this.reset();
        for (int i = 0; i < size; ++i) {
            String key = keys[i];
            int value = values[i];
            this.nextSequenceNumbers.put(key, value);
        }
    }

    public void write(JmeExporter exporter) throws IOException {
        int size = this.nextSequenceNumbers.size();
        String[] keys = new String[size];
        int[] values = new int[size];
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.nextSequenceNumbers.entrySet()) {
            keys[i] = entry.getKey();
            values[i] = entry.getValue();
            ++i;
        }
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(keys, "keys", null);
        capsule.write(values, "values", null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("{ ");
        for (Map.Entry<String, Integer> entry : this.nextSequenceNumbers.entrySet()) {
            String piece = String.format("%s:%s ", entry.getKey(), entry.getValue());
            builder.append(piece);
        }
        builder.append("}");
        String result = builder.toString();
        return result;
    }
}

