/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.MySpatial;
import jme3utilities.SubtreeControl;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class AxesVisualizer
extends SubtreeControl {
    private static final boolean defaultDepthTest = false;
    private static final ColorRGBA xColor = new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
    private static final ColorRGBA yColor = new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f);
    private static final ColorRGBA zColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    public static final float widthForSolid = 0.0f;
    private static final Logger logger = Logger.getLogger(AxesVisualizer.class.getName());
    private static final String modelAssetPath = "Models/indicators/arrow/arrow.j3o";
    private static final String subtreeName = "axes node";
    private static final String tagAxisLength = "axisLength";
    private static final String tagDepthTest = "depthTest";
    private static final String tagLineWidth = "lineWidth";
    private static final String tagNumAxes = "numAxes";
    private static final Vector3f unitX = new Vector3f(1.0f, 0.0f, 0.0f);
    private static final Vector3f unitY = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f unitZ = new Vector3f(0.0f, 0.0f, 1.0f);
    private AssetManager assetManager;
    private boolean depthTest = false;
    private float axisLength;
    private float lineWidth;
    private int numAxes = 3;

    protected AxesVisualizer() {
    }

    public AxesVisualizer(AssetManager manager, float length) {
        Validate.nonNull(manager, "asset manager");
        Validate.positive(length, "axis length");
        this.assetManager = manager;
        this.axisLength = length;
        this.lineWidth = 0.0f;
    }

    public AxesVisualizer(AssetManager manager, float length, float width) {
        Validate.nonNull(manager, "asset manager");
        Validate.positive(length, "axis length");
        Validate.inRange(width, "line width", 1.0f, Float.MAX_VALUE);
        this.assetManager = manager;
        this.axisLength = length;
        this.lineWidth = width;
    }

    public float axisLength() {
        assert (this.axisLength > 0.0f) : this.axisLength;
        return this.axisLength;
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public float lineWidth() {
        assert (this.lineWidth >= 0.0f) : this.lineWidth;
        return this.lineWidth;
    }

    public int numAxes() {
        assert (this.numAxes >= 1) : this.numAxes;
        assert (this.numAxes <= 3) : this.numAxes;
        return this.numAxes;
    }

    public void setAxisLength(float length) {
        Validate.positive(length, "length");
        this.axisLength = length;
    }

    public void setDepthTest(boolean newSetting) {
        this.depthTest = newSetting;
    }

    public void setNumAxes(int newNumber) {
        Validate.inRange(newNumber, "new number", 1, 3);
        this.numAxes = newNumber;
    }

    public void setLineWidth(float width) {
        Validate.nonNegative(width, "width");
        this.lineWidth = width;
    }

    public Vector3f tipLocation(int axisIndex) {
        Validate.axisIndex(axisIndex, "axis index");
        Vector3f result = null;
        if (this.isEnabled() && axisIndex < this.numAxes) {
            Node subtreeNode = (Node)this.getSubtree();
            MySpatial.setWorldScale((Spatial)subtreeNode, this.axisLength);
            Geometry arrow = (Geometry)subtreeNode.getChild(axisIndex);
            result = arrow.localToWorld(unitX, null);
        }
        return result;
    }

    @Override
    public AxesVisualizer clone() throws CloneNotSupportedException {
        AxesVisualizer clone = (AxesVisualizer)super.clone();
        return clone;
    }

    @Override
    protected void controlUpdate(float updateInterval) {
        super.controlUpdate(updateInterval);
        Node subtreeNode = (Node)this.getSubtree();
        int numChildren = subtreeNode.getQuantity();
        if (numChildren == this.numAxes) {
            Geometry xArrow = (Geometry)subtreeNode.getChild(0);
            Mesh xMesh = xArrow.getMesh();
            boolean arrowMesh = xMesh instanceof Arrow;
            if (this.lineWidth >= 1.0f && arrowMesh) {
                this.updateArrows();
            } else if (this.lineWidth < 1.0f && !arrowMesh) {
                this.updateArrows();
            } else {
                subtreeNode.detachAllChildren();
                this.addArrows();
            }
        } else {
            subtreeNode.detachAllChildren();
            this.addArrows();
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        this.assetManager = importer.getAssetManager();
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.axisLength = capsule.readFloat(tagAxisLength, 1.0f);
        this.depthTest = capsule.readBoolean(tagDepthTest, false);
        this.lineWidth = capsule.readFloat(tagLineWidth, 0.0f);
        this.numAxes = capsule.readInt(tagNumAxes, 3);
    }

    @Override
    public void setEnabled(boolean newState) {
        if (newState && this.getSubtree() == null) {
            Node subtreeNode = new Node(subtreeName);
            subtreeNode.setQueueBucket(RenderQueue.Bucket.Transparent);
            subtreeNode.setShadowMode(RenderQueue.ShadowMode.Off);
            this.setSubtree((Spatial)subtreeNode);
        }
        super.setEnabled(newState);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.axisLength, tagAxisLength, 1.0f);
        capsule.write(this.depthTest, tagDepthTest, false);
        capsule.write(this.lineWidth, tagLineWidth, 0.0f);
        capsule.write(this.numAxes, tagNumAxes, 3);
    }

    private void addArrows() {
        assert (((Node)this.getSubtree()).getQuantity() == 0);
        if (this.lineWidth >= 1.0f) {
            this.addWireArrow(xColor, "xAxis", unitX);
            if (this.numAxes > 1) {
                this.addWireArrow(yColor, "yAxis", unitY);
                if (this.numAxes > 2) {
                    this.addWireArrow(zColor, "zAxis", unitZ);
                }
            }
        } else {
            this.addSolidArrow(xColor, "xAxis", unitX);
            if (this.numAxes > 1) {
                this.addSolidArrow(yColor, "yAxis", unitY);
                if (this.numAxes > 2) {
                    this.addSolidArrow(zColor, "zAxis", unitZ);
                }
            }
        }
        this.updateArrows();
    }

    private void addSolidArrow(ColorRGBA color, String name, Vector3f direction) {
        assert (this.assetManager != null);
        assert (color != null);
        assert (name != null);
        assert (direction != null);
        assert (direction.isUnitVector()) : direction;
        Node node = (Node)this.assetManager.loadModel(modelAssetPath);
        Node node2 = (Node)node.getChild(0);
        Node node3 = (Node)node2.getChild(0);
        Geometry geometry = (Geometry)node3.getChild(0);
        ((Node)this.getSubtree()).attachChild((Spatial)geometry);
        Vector3f xDir = direction.clone();
        Vector3f yDir = new Vector3f();
        Vector3f zDir = new Vector3f();
        MyVector3f.generateBasis(xDir, yDir, zDir);
        Quaternion orientation = new Quaternion();
        orientation.fromAxes(xDir, yDir, zDir);
        geometry.setLocalRotation(orientation);
        geometry.setName(name);
        Material material = MyAsset.createUnshadedMaterial(this.assetManager, color);
        geometry.setMaterial(material);
        material.getAdditionalRenderState().setDepthTest(this.depthTest);
        material.setName(name + "Material");
    }

    private void addWireArrow(ColorRGBA color, String name, Vector3f direction) {
        assert (this.assetManager != null);
        assert (color != null);
        assert (name != null);
        assert (direction != null);
        assert (direction.isUnitVector()) : direction;
        Arrow mesh = new Arrow(direction);
        Geometry geometry = new Geometry(name, (Mesh)mesh);
        ((Node)this.getSubtree()).attachChild((Spatial)geometry);
        Material material = MyAsset.createWireframeMaterial(this.assetManager, color);
        geometry.setMaterial(material);
        material.getAdditionalRenderState().setDepthTest(this.depthTest);
        material.setName(name + "Material");
    }

    private void updateArrows() {
        Node subtreeNode = (Node)this.getSubtree();
        MySpatial.setWorldScale((Spatial)subtreeNode, this.axisLength);
        for (Spatial axis : subtreeNode.getChildren()) {
            Geometry geometry = (Geometry)axis;
            Material material = geometry.getMaterial();
            RenderState state = material.getAdditionalRenderState();
            state.setDepthTest(this.depthTest);
            if (!(this.lineWidth >= 1.0f)) continue;
            state.setLineWidth(this.lineWidth);
        }
    }
}

