/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.anim.Armature;
import com.jme3.anim.SkinningControl;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.MatParam;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Transform;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.texture.Texture;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.MySpatial;
import jme3utilities.SubtreeControl;
import jme3utilities.Validate;
import jme3utilities.debug.SkeletonMesh;

public class SkeletonVisualizer
extends SubtreeControl {
    private static final ColorRGBA defaultHeadColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private static final ColorRGBA defaultLineColor = new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f);
    private static final float defaultHeadSize = 4.0f;
    private static final float defaultLineWidth = 1.0f;
    private static final int headsChildPosition = 0;
    private static final int linksChildPosition = 1;
    private static final Logger logger = Logger.getLogger(SkeletonVisualizer.class.getName());
    private static final String defaultShapeAssetPath = "Textures/shapes/solid circle.png";
    private static final String headsName = "skeleton heads";
    private static final String linksName = "skeleton links";
    private static final String subtreeName = "skeleton node";
    private static final String tagArmature = "armature";
    private static final String tagCustomColorIndices = "customColorKeys";
    private static final String tagCustomColors = "customColors";
    private static final String tagHeadColor = "headColor";
    private static final String tagHeadMaterial = "headMaterial";
    private static final String tagLineMaterial = "lineMaterial";
    private static final String tagLineWidth = "lineWidth";
    private static final String tagSkeleton = "skeleton";
    private static final String tagTransformSpatial = "transformSpatial";
    private static final Transform transformIdentity = new Transform();
    private Armature armature = null;
    private ColorRGBA headColor = defaultHeadColor.clone();
    private float effectiveLineWidth = 1.0f;
    private Map<Integer, ColorRGBA> customColors = new TreeMap<Integer, ColorRGBA>();
    private Material headMaterial;
    private Material lineMaterial;
    private Skeleton skeleton = null;
    private Spatial transformSpatial = null;

    protected SkeletonVisualizer() {
    }

    public SkeletonVisualizer(AssetManager assetManager, AbstractControl subject) {
        Validate.nonNull(assetManager, "asset manager");
        this.lineMaterial = MyAsset.createMulticolor2Material(assetManager, null, 0.0f);
        this.lineMaterial.setBoolean("UseVertexColor", true);
        this.lineMaterial.setColor("Color", defaultLineColor.clone());
        this.lineMaterial.setFloat("AlphaDiscardThreshold", 0.9999f);
        RenderState lineState = this.lineMaterial.getAdditionalRenderState();
        lineState.setBlendMode(RenderState.BlendMode.Alpha);
        lineState.setDepthTest(false);
        boolean mipmaps = false;
        Texture headShape = MyAsset.loadTexture(assetManager, defaultShapeAssetPath, mipmaps);
        this.headMaterial = MyAsset.createMulticolor2Material(assetManager, headShape, 4.0f);
        this.headMaterial.setBoolean("UseVertexColor", true);
        this.headMaterial.setFloat("AlphaDiscardThreshold", 1.0E-4f);
        RenderState headState = this.headMaterial.getAdditionalRenderState();
        headState.setBlendMode(RenderState.BlendMode.Alpha);
        headState.setDepthTest(false);
        this.setSubject(subject);
        assert (!this.isEnabled());
    }

    public ColorRGBA copyHeadColor(int boneIndex, ColorRGBA storeResult) {
        Validate.nonNegative(boneIndex, "bone index");
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        ColorRGBA color = this.customColors.get(boneIndex);
        if (color == null) {
            color = this.headColor;
        }
        result.set(color);
        return result;
    }

    public ColorRGBA copyLineColor(ColorRGBA storeResult) {
        ColorRGBA result = storeResult == null ? new ColorRGBA() : storeResult;
        MatParam parameter = this.lineMaterial.getParam("Color");
        ColorRGBA color = (ColorRGBA)parameter.getValue();
        result.set(color);
        return result;
    }

    public int countBones() {
        int result = 0;
        if (this.armature != null) {
            result = this.armature.getJointCount();
        } else if (this.skeleton != null) {
            result = this.skeleton.getBoneCount();
        }
        return result;
    }

    public float headSize() {
        MatParam parameter = this.headMaterial.getParam("PointSize");
        float result = ((Float)parameter.getValue()).floatValue();
        assert (result >= 1.0f) : result;
        return result;
    }

    public float lineWidth() {
        assert (this.effectiveLineWidth >= 0.0f) : this.effectiveLineWidth;
        return this.effectiveLineWidth;
    }

    public void setColor(ColorRGBA newColor) {
        Validate.nonNull(newColor, "new color");
        this.setLineColor(newColor);
        this.setHeadColor(newColor);
    }

    public void setHeadColor(ColorRGBA newColor) {
        Validate.nonNull(newColor, "new color");
        this.headColor.set(newColor);
        this.customColors.clear();
    }

    public void setHeadColor(int boneIndex, ColorRGBA newColor) {
        Validate.nonNegative(boneIndex, "bone index");
        Validate.nonNull(newColor, "new color");
        this.customColors.put(boneIndex, newColor.clone());
    }

    public void setHeadShape(Texture shape) {
        Validate.nonNull(shape, "shape");
        this.headMaterial.setTexture("PointShape", shape);
    }

    public void setHeadSize(float size) {
        Validate.nonNegative(size, "size");
        this.headMaterial.setFloat("PointSize", size);
    }

    public void setLineColor(ColorRGBA newColor) {
        Validate.nonNull(newColor, "new color");
        this.lineMaterial.setColor("Color", newColor.clone());
    }

    public void setLineWidth(float width) {
        Validate.nonNegative(width, "width");
        this.effectiveLineWidth = width;
    }

    public final void setSubject(AbstractControl subject) {
        if (subject == null) {
            this.setSkeleton(null, null);
            this.transformSpatial = null;
        } else {
            SkeletonControl sc;
            if (subject instanceof SkeletonControl) {
                sc = (SkeletonControl)subject;
                Skeleton newSkeleton = sc.getSkeleton();
                this.setSkeleton(null, newSkeleton);
            } else {
                sc = (SkinningControl)subject;
                Armature newArmature = sc.getArmature();
                this.setSkeleton(newArmature, null);
            }
            Spatial controlledSpatial = subject.getSpatial();
            Geometry animatedGeometry = MySpatial.findAnimatedGeometry(controlledSpatial);
            this.transformSpatial = animatedGeometry == null ? controlledSpatial : animatedGeometry;
        }
    }

    public void setTransformSpatial(Spatial spatial) {
        this.transformSpatial = spatial;
    }

    @Override
    public SkeletonVisualizer clone() throws CloneNotSupportedException {
        SkeletonVisualizer clone = (SkeletonVisualizer)super.clone();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        SkeletonVisualizer originalVisualizer = (SkeletonVisualizer)((Object)original);
        this.customColors = new TreeMap<Integer, ColorRGBA>();
        for (Map.Entry<Integer, ColorRGBA> entry : originalVisualizer.customColors.entrySet()) {
            int boneIndex = entry.getKey();
            ColorRGBA color = entry.getValue();
            ColorRGBA copyColor = (ColorRGBA)cloner.clone((Object)color);
            this.customColors.put(boneIndex, copyColor);
        }
        this.armature = (Armature)cloner.clone((Object)this.armature);
        this.headColor = (ColorRGBA)cloner.clone((Object)this.headColor);
        this.headMaterial = (Material)cloner.clone((Object)this.headMaterial);
        this.lineMaterial = (Material)cloner.clone((Object)this.lineMaterial);
        this.skeleton = (Skeleton)cloner.clone((Object)this.skeleton);
        this.transformSpatial = (Spatial)cloner.clone((Object)this.transformSpatial);
    }

    @Override
    protected void controlUpdate(float updateInterval) {
        super.controlUpdate(updateInterval);
        Node subtreeNode = (Node)this.getSubtree();
        if (this.countBones() == 0) {
            subtreeNode.detachAllChildren();
        } else if (subtreeNode.getQuantity() == 0) {
            this.addGeometries();
        } else {
            this.updateGeometries();
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.armature = (Armature)capsule.readSavable(tagArmature, null);
        int[] indices = capsule.readIntArray(tagCustomColorIndices, null);
        Savable[] savables = capsule.readSavableArray(tagCustomColors, null);
        assert (indices.length == savables.length);
        for (int j = 0; j < indices.length; ++j) {
            int index = indices[j];
            ColorRGBA color = (ColorRGBA)savables[j];
            this.customColors.put(index, color);
        }
        this.headColor = (ColorRGBA)capsule.readSavable(tagHeadColor, (Savable)defaultHeadColor);
        this.headMaterial = (Material)capsule.readSavable(tagHeadMaterial, null);
        this.lineMaterial = (Material)capsule.readSavable(tagLineMaterial, null);
        this.effectiveLineWidth = capsule.readFloat(tagLineWidth, 1.0f);
        this.skeleton = (Skeleton)capsule.readSavable(tagSkeleton, null);
        this.transformSpatial = (Spatial)capsule.readSavable(tagTransformSpatial, null);
    }

    @Override
    public void setEnabled(boolean newState) {
        if (newState && this.getSubtree() == null) {
            Node subtreeNode = new Node(subtreeName);
            subtreeNode.setQueueBucket(RenderQueue.Bucket.Transparent);
            subtreeNode.setShadowMode(RenderQueue.ShadowMode.Off);
            this.setSubtree((Spatial)subtreeNode);
        }
        super.setEnabled(newState);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.armature, tagArmature, null);
        int numEntries = this.customColors.size();
        int[] indices = new int[numEntries];
        Savable[] savables = new Savable[numEntries];
        int j = 0;
        for (Map.Entry<Integer, ColorRGBA> entry : this.customColors.entrySet()) {
            indices[j] = entry.getKey();
            savables[j] = (Savable)entry.getValue();
            ++j;
        }
        capsule.write(indices, tagCustomColorIndices, null);
        capsule.write(savables, tagCustomColors, null);
        capsule.write((Savable)this.headColor, tagHeadColor, (Savable)defaultHeadColor);
        capsule.write((Savable)this.headMaterial, tagHeadMaterial, null);
        capsule.write((Savable)this.lineMaterial, tagLineMaterial, null);
        capsule.write(this.effectiveLineWidth, tagLineWidth, 1.0f);
        capsule.write((Savable)this.skeleton, tagSkeleton, null);
        capsule.write((Savable)this.transformSpatial, tagTransformSpatial, null);
    }

    private void addGeometries() {
        Node subtreeNode = (Node)this.getSubtree();
        assert (subtreeNode.getQuantity() == 0);
        SkeletonMesh headsMesh = new SkeletonMesh(this.armature, this.skeleton, Mesh.Mode.Points);
        Geometry headsGeometry = new Geometry(headsName, (Mesh)headsMesh);
        assert (this.headMaterial != null);
        headsGeometry.setMaterial(this.headMaterial);
        subtreeNode.attachChildAt((Spatial)headsGeometry, 0);
        SkeletonMesh linksMesh = new SkeletonMesh(this.armature, this.skeleton, Mesh.Mode.Lines);
        Geometry linksGeometry = new Geometry(linksName, (Mesh)linksMesh);
        linksGeometry.setMaterial(this.lineMaterial);
        subtreeNode.attachChildAt((Spatial)linksGeometry, 1);
        this.updateGeometries();
    }

    private void setSkeleton(Armature newArmature, Skeleton newSkeleton) {
        if (this.armature != newArmature || this.skeleton != newSkeleton) {
            if (this.getSubtree() != null) {
                ((Node)this.getSubtree()).detachAllChildren();
            }
            this.armature = newArmature;
            this.skeleton = newSkeleton;
        }
    }

    private void updateGeometries() {
        Transform worldTransform = this.transformSpatial == null || MySpatial.isIgnoringTransforms(this.transformSpatial) ? transformIdentity : this.transformSpatial.getWorldTransform();
        Node subtreeNode = (Node)this.getSubtree();
        MySpatial.setWorldTransform((Spatial)subtreeNode, worldTransform);
        Geometry headsGeometry = (Geometry)subtreeNode.getChild(0);
        SkeletonMesh headsMesh = (SkeletonMesh)headsGeometry.getMesh();
        headsMesh.updateColors(this);
        headsMesh.updatePositions(this.armature, this.skeleton);
        Geometry linksGeometry = (Geometry)subtreeNode.getChild(1);
        SkeletonMesh linksMesh = (SkeletonMesh)linksGeometry.getMesh();
        linksMesh.updateColors(this);
        linksMesh.updatePositions(this.armature, this.skeleton);
        if (this.effectiveLineWidth >= 1.0f) {
            assert (this.lineMaterial == linksGeometry.getMaterial());
            RenderState rs = this.lineMaterial.getAdditionalRenderState();
            rs.setLineWidth(this.effectiveLineWidth);
            linksGeometry.setCullHint(Spatial.CullHint.Inherit);
        } else {
            linksGeometry.setCullHint(Spatial.CullHint.Always);
        }
    }
}

