/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.noise.Generator;

public class Population<Fitness extends Comparable<Fitness>, Element> {
    private static final Logger logger = Logger.getLogger(Population.class.getName());
    private int capacity;
    private int numElements = 0;
    private final TreeMap<Fitness, List<Element>> elementsByFitness = new TreeMap();

    public Population(int capacity) {
        Validate.positive(capacity, "capacity");
        this.capacity = capacity;
    }

    public void add(Element element, Fitness score) {
        List<Element> list;
        Validate.nonNull(element, "element");
        if (this.numElements >= this.capacity) {
            assert (this.numElements == this.capacity) : this.numElements;
            if (this.worstScore().compareTo(score) >= 0) {
                return;
            }
        }
        if ((list = this.elementsByFitness.get(score)) == null) {
            list = new ArrayList<Element>(1);
            List<Element> previousList = this.elementsByFitness.put(score, list);
            assert (previousList == null);
        } else assert (!list.isEmpty());
        if (!list.contains(element)) {
            list.add(element);
            ++this.numElements;
            this.cull(this.capacity);
        }
        if (list.isEmpty()) {
            list = this.elementsByFitness.remove(score);
            assert (list != null);
        }
    }

    public void add(List<Element> addList, Fitness score) {
        Validate.nonNull(addList, "list");
        if (this.numElements >= this.capacity) {
            assert (this.numElements == this.capacity) : this.numElements;
            if (this.worstScore().compareTo(score) >= 0) {
                return;
            }
        }
        int addCount = addList.size();
        List<Element> list = this.elementsByFitness.get(score);
        if (list == null) {
            list = new ArrayList<Element>(addCount);
            List<Element> previousList = this.elementsByFitness.put(score, list);
            assert (previousList == null);
        } else assert (!list.isEmpty());
        for (Element element : addList) {
            if (list.contains(element)) continue;
            list.add(element);
            ++this.numElements;
        }
        if (list.isEmpty()) {
            list = this.elementsByFitness.remove(score);
            assert (list != null);
        }
        this.cull(this.capacity);
    }

    public Fitness bestScore() {
        Map.Entry<Fitness, List<Element>> bestEntry = this.elementsByFitness.lastEntry();
        if (bestEntry == null) {
            return null;
        }
        Comparable result = (Comparable)bestEntry.getKey();
        return (Fitness)result;
    }

    public void cull(int targetSize) {
        Validate.nonNegative(targetSize, "target size");
        while (this.numElements > targetSize) {
            Comparable worst = (Comparable)this.elementsByFitness.firstKey();
            List<Element> list = this.elementsByFitness.get(worst);
            int listSize = list.size();
            assert (listSize > 0) : listSize;
            if (this.numElements - listSize >= targetSize) {
                List<Element> old = this.elementsByFitness.remove(worst);
                assert (old != null);
                this.numElements -= listSize;
                continue;
            }
            Iterator<Element> it = list.iterator();
            while (it.hasNext()) {
                it.next();
                if (this.numElements <= targetSize) continue;
                it.remove();
                --this.numElements;
            }
        }
    }

    public Element fittest() {
        Map.Entry<Fitness, List<Element>> bestEntry = this.elementsByFitness.lastEntry();
        if (bestEntry == null) {
            return null;
        }
        List<Element> bestElements = bestEntry.getValue();
        assert (!bestElements.isEmpty());
        Element result = bestElements.get(0);
        return result;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public List<Element> listElements() {
        ArrayList result = new ArrayList(this.numElements);
        for (Map.Entry entry : this.elementsByFitness.descendingMap().entrySet()) {
            List list = (List)entry.getValue();
            assert (!list.isEmpty());
            result.addAll(list);
        }
        return result;
    }

    public int mergeFittestTo(int maxCount, Population<Fitness, Element> destination) {
        Validate.nonNegative(maxCount, "maxCount");
        Validate.nonNull(destination, "destination");
        int numMerged = 0;
        for (Map.Entry entry : this.elementsByFitness.descendingMap().entrySet()) {
            List list = (List)entry.getValue();
            assert (!list.isEmpty());
            Comparable score = (Comparable)entry.getKey();
            if (numMerged + list.size() <= maxCount) {
                destination.add(list, (Fitness)score);
                numMerged += list.size();
                continue;
            }
            Iterator it = list.iterator();
            while (numMerged < maxCount) {
                Object element = it.next();
                destination.add(element, score);
                ++numMerged;
            }
            return numMerged;
        }
        return numMerged;
    }

    public int mergeSubsetTo(BitSet subset, Population<Fitness, Element> destination) {
        Validate.nonNull(subset, "subset");
        Validate.nonNull(destination, "destination");
        int currentIndex = 0;
        int nextIndex = subset.nextSetBit(0);
        if (nextIndex == -1) {
            return 0;
        }
        int numMerged = 0;
        for (Map.Entry<Fitness, List<Element>> entry : this.elementsByFitness.entrySet()) {
            List<Element> list = entry.getValue();
            assert (!list.isEmpty());
            if (currentIndex + list.size() <= nextIndex) {
                currentIndex += list.size();
                continue;
            }
            Comparable score = (Comparable)entry.getKey();
            for (Element element : list) {
                if (currentIndex == nextIndex) {
                    destination.add(element, score);
                    ++numMerged;
                    nextIndex = subset.nextSetBit(nextIndex + 1);
                    if (nextIndex == -1) {
                        return numMerged;
                    }
                }
                ++currentIndex;
            }
        }
        return numMerged;
    }

    public void mergeTo(Population<Fitness, Element> destination) {
        Validate.nonNull(destination, "destination");
        for (Map.Entry<Fitness, List<Element>> entry : this.elementsByFitness.entrySet()) {
            List<Element> list = entry.getValue();
            assert (!list.isEmpty());
            Comparable score = (Comparable)entry.getKey();
            destination.add(list, score);
        }
    }

    public int mergeUniformTo(int maxCount, Generator generator, Population<Fitness, Element> destination) {
        Validate.nonNegative(maxCount, "maxCount");
        Validate.nonNull(generator, "generator");
        Validate.nonNull(destination, "destination");
        if (maxCount >= this.numElements) {
            this.mergeTo(destination);
            return this.numElements;
        }
        BitSet selected = new BitSet(this.numElements);
        int lastIndex = this.numElements - 1;
        for (int i = 0; i < maxCount; ++i) {
            int bitIndex = generator.pick(selected, lastIndex, false);
            assert (bitIndex != -1);
            selected.set(bitIndex);
        }
        int result = this.mergeSubsetTo(selected, destination);
        return result;
    }

    public void setCapacity(int newCapacity) {
        Validate.positive(newCapacity, "new capacity");
        this.capacity = newCapacity;
        this.cull(this.capacity);
    }

    public int size() {
        assert (this.numElements >= 0) : this.numElements;
        assert (this.numElements <= this.capacity) : this.numElements;
        assert (this.numElements >= this.elementsByFitness.size()) : this.numElements;
        return this.numElements;
    }

    public Fitness worstScore() {
        Map.Entry<Fitness, List<Element>> worstEntry = this.elementsByFitness.firstEntry();
        if (worstEntry == null) {
            return null;
        }
        Comparable result = (Comparable)worstEntry.getKey();
        return (Fitness)result;
    }
}

