/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.math;

import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.VectorSet;

public class VectorSetUsingCollection
implements VectorSet {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(VectorSetUsingCollection.class.getName());
    private final Set<Vector3f> set;

    public VectorSetUsingCollection(int numVectors) {
        Validate.positive(numVectors, "number of vectors");
        this.set = new HashSet<Vector3f>(numVectors);
    }

    @Override
    public void add(float x, float y, float z) {
        Vector3f v = new Vector3f(x, y, z);
        this.set.add(v);
    }

    @Override
    public void add(Vector3f vector) {
        Validate.nonNull(vector, "vector");
        this.set.add(vector.clone());
    }

    @Override
    public void addAll(Iterable<Vector3f> vectors) {
        for (Vector3f vector : vectors) {
            this.set.add(vector.clone());
        }
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public boolean contains(float x, float y, float z) {
        Vector3f v = new Vector3f(x, y, z);
        boolean result = this.set.contains(v);
        return result;
    }

    @Override
    public boolean contains(Vector3f vector) {
        boolean result = this.set.contains(vector);
        return result;
    }

    @Override
    public Matrix3f covariance(Matrix3f storeResult) {
        Matrix3f result = storeResult == null ? new Matrix3f() : storeResult;
        int numSamples = this.numVectors();
        assert (numSamples > 1) : numSamples;
        Vector3f sampleMean = this.mean(null);
        result.zero();
        float[] aboveMean = new float[3];
        for (Vector3f v : this.set) {
            aboveMean[0] = v.x - sampleMean.x;
            aboveMean[1] = v.y - sampleMean.y;
            aboveMean[2] = v.z - sampleMean.z;
            for (int rowI = 0; rowI < 3; ++rowI) {
                for (int columnI = rowI; columnI < 3; ++columnI) {
                    float sum = result.get(rowI, columnI);
                    result.set(rowI, columnI, sum += aboveMean[rowI] * aboveMean[columnI]);
                }
            }
        }
        float nMinus1 = numSamples - 1;
        for (int rowI = 0; rowI < 3; ++rowI) {
            for (int columnI = rowI; columnI < 3; ++columnI) {
                float sum = result.get(rowI, columnI);
                float element = sum / nMinus1;
                result.set(rowI, columnI, element);
                result.set(columnI, rowI, element);
            }
        }
        return result;
    }

    @Override
    public Vector3f maxAbs(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f tempVector : this.set) {
            result.x = Math.max(result.x, Math.abs(tempVector.x));
            result.y = Math.max(result.y, Math.abs(tempVector.y));
            result.z = Math.max(result.z, Math.abs(tempVector.z));
        }
        return result;
    }

    @Override
    public float maxLength() {
        double maxLengthSquared = 0.0;
        for (Vector3f tempVector : this.set) {
            double lengthSquared = MyVector3f.lengthSquared(tempVector);
            if (!(lengthSquared > maxLengthSquared)) continue;
            maxLengthSquared = lengthSquared;
        }
        float length = (float)Math.sqrt(maxLengthSquared);
        assert (length >= 0.0f) : length;
        return length;
    }

    @Override
    public void maxMin(Vector3f storeMaxima, Vector3f storeMinima) {
        storeMaxima.set(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        storeMinima.set(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        for (Vector3f tempVector : this.set) {
            MyVector3f.accumulateMinima(storeMinima, tempVector);
            MyVector3f.accumulateMaxima(storeMaxima, tempVector);
        }
    }

    @Override
    public Vector3f mean(Vector3f storeResult) {
        int numVectors = this.numVectors();
        assert (numVectors > 0) : numVectors;
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.zero();
        for (Vector3f tempVector : this.set) {
            result.addLocal(tempVector);
        }
        result.divideLocal((float)numVectors);
        return result;
    }

    @Override
    public int numVectors() {
        int numVectors = this.set.size();
        assert (numVectors >= 0) : numVectors;
        return numVectors;
    }

    @Override
    public FloatBuffer toBuffer() {
        int numFloats = 3 * this.set.size();
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)numFloats);
        for (Vector3f tempVector : this.set) {
            buffer.put(tempVector.x);
            buffer.put(tempVector.y);
            buffer.put(tempVector.z);
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public float[] toFloatArray() {
        int numFloats = 3 * this.numVectors();
        float[] result = new float[numFloats];
        int vectorIndex = 0;
        for (Vector3f tempVector : this.set) {
            int startIndex = 3 * vectorIndex;
            result[startIndex + 0] = tempVector.x;
            result[startIndex + 1] = tempVector.y;
            result[startIndex + 2] = tempVector.z;
            ++vectorIndex;
        }
        return result;
    }

    @Override
    public Vector3f[] toVectorArray() {
        int numVectors = this.numVectors();
        Vector3f[] result = new Vector3f[numVectors];
        int vectorIndex = 0;
        for (Vector3f tempVector : this.set) {
            result[vectorIndex] = tempVector.clone();
            ++vectorIndex;
        }
        return result;
    }

    public String toString() {
        int numVectors = this.numVectors();
        StringBuilder builder = new StringBuilder(numVectors * 32);
        builder.append("VectorSet[ n=");
        builder.append(numVectors);
        String separator = System.lineSeparator();
        builder.append(separator);
        for (Vector3f tmpVector : this.set) {
            builder.append("  ");
            builder.append(tmpVector);
            builder.append(separator);
        }
        builder.append("]");
        builder.append(separator);
        return builder.toString();
    }
}

