/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class CapsuleMesh
extends Mesh {
    private static final int numAxes = 3;
    private static final int[] octaIndices = new int[]{0, 2, 5, 1, 4, 3, 0, 3, 4, 1, 5, 2, 0, 4, 2, 1, 3, 5, 0, 5, 3, 1, 2, 4};
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(CapsuleMesh.class.getName());
    private static final Vector3f[] octaLocations = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    private int nextVertexIndex = 0;
    private final List<Vector3f> sphereNormals = new ArrayList<Vector3f>(258);
    private final Map<Long, Integer> midpointCache = new HashMap<Long, Integer>(252);

    protected CapsuleMesh() {
    }

    public CapsuleMesh(int numRefineSteps, float radius, float height) {
        Validate.inRange(numRefineSteps, "number of refinement steps", 0, 13);
        Validate.positive(radius, "radius");
        Validate.positive(height, "height");
        this.addVertex(octaLocations[0]);
        this.addVertex(octaLocations[1]);
        this.addVertex(octaLocations[2]);
        this.addVertex(octaLocations[3]);
        this.addVertex(octaLocations[4]);
        this.addVertex(octaLocations[5]);
        ArrayList<Integer> faces = new ArrayList<Integer>(24);
        for (int octaIndex : octaIndices) {
            faces.add(octaIndex);
        }
        for (int stepIndex = 0; stepIndex < numRefineSteps; ++stepIndex) {
            ArrayList<Integer> newFaces = new ArrayList<Integer>(4 * faces.size());
            for (int j = 0; j < faces.size(); j += 3) {
                int v1 = (Integer)faces.get(j);
                int v2 = (Integer)faces.get(j + 1);
                int v3 = (Integer)faces.get(j + 2);
                int a = this.midpointIndex(v1, v2);
                int b = this.midpointIndex(v2, v3);
                int c = this.midpointIndex(v3, v1);
                newFaces.add(v1);
                newFaces.add(a);
                newFaces.add(c);
                newFaces.add(v2);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(v3);
                newFaces.add(c);
                newFaces.add(b);
                newFaces.add(a);
                newFaces.add(b);
                newFaces.add(c);
            }
            faces = newFaces;
        }
        this.midpointCache.clear();
        assert (faces.size() == 3 << 3 + 2 * numRefineSteps);
        int numEquatoralVertices = 0;
        for (Vector3f normal : this.sphereNormals) {
            if (normal.y != 0.0f) continue;
            ++numEquatoralVertices;
        }
        HashMap<Integer, Integer> mapN2S = new HashMap<Integer, Integer>(numEquatoralVertices);
        int numVertices = this.sphereNormals.size() + numEquatoralVertices;
        int numFloats = 3 * numVertices;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        float halfHeight = height / 2.0f;
        for (Vector3f normal : this.sphereNormals) {
            posBuffer.put(radius * normal.x);
            if (normal.y >= 0.0f) {
                posBuffer.put(halfHeight + radius * normal.y);
            } else {
                posBuffer.put(-halfHeight + radius * normal.y);
            }
            posBuffer.put(radius * normal.z);
            normalBuffer.put(normal.x).put(normal.y).put(normal.z);
        }
        for (int northI = 0; northI < this.sphereNormals.size(); ++northI) {
            Vector3f normal = this.sphereNormals.get(northI);
            if (normal.y != 0.0f) continue;
            int southIndex = posBuffer.position() / 3;
            mapN2S.put(northI, southIndex);
            posBuffer.put(radius * normal.x);
            posBuffer.put(-halfHeight);
            posBuffer.put(radius * normal.z);
            normalBuffer.put(normal.x);
            normalBuffer.put(0.0f);
            normalBuffer.put(normal.z);
        }
        posBuffer.flip();
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        normalBuffer.flip();
        this.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
        int numIndices = faces.size() + 6 * numEquatoralVertices;
        IndexBuffer ib = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        int numDomeTriangles = faces.size() / 3;
        assert (3 * numDomeTriangles == faces.size());
        for (int triangleI = 0; triangleI < numDomeTriangles; ++triangleI) {
            int vi0 = (Integer)faces.get(3 * triangleI);
            int vi1 = (Integer)faces.get(3 * triangleI + 1);
            int vi2 = (Integer)faces.get(3 * triangleI + 2);
            float v0y = this.sphereNormals.get((int)vi0).y;
            float v1y = this.sphereNormals.get((int)vi1).y;
            float v2y = this.sphereNormals.get((int)vi2).y;
            if ((v0y == 0.0f || v1y == 0.0f || v2y == 0.0f) && (v0y < 0.0f || v1y < 0.0f || v2y < 0.0f)) {
                if (v0y == 0.0f) {
                    vi0 = (Integer)mapN2S.get(vi0);
                }
                if (v1y == 0.0f) {
                    vi1 = (Integer)mapN2S.get(vi1);
                }
                if (v2y == 0.0f) {
                    vi2 = (Integer)mapN2S.get(vi2);
                }
            }
            ib.put(vi0);
            ib.put(vi1);
            ib.put(vi2);
        }
        Integer[] northIndices = mapN2S.keySet().toArray(new Integer[0]);
        Arrays.sort(northIndices, new Comparator<Integer>(){

            @Override
            public int compare(Integer vi1, Integer vi2) {
                Vector3f sn1 = (Vector3f)CapsuleMesh.this.sphereNormals.get(vi1);
                double atan1 = Math.atan2(sn1.x, sn1.z);
                Vector3f sn2 = (Vector3f)CapsuleMesh.this.sphereNormals.get(vi2);
                double atan2 = Math.atan2(sn2.x, sn2.z);
                int result = Double.compare(atan1, atan2);
                return result;
            }
        });
        this.sphereNormals.clear();
        for (int evI = 0; evI < numEquatoralVertices - 1; ++evI) {
            int ni0 = northIndices[evI];
            int ni1 = northIndices[evI + 1];
            int si0 = (Integer)mapN2S.get(ni0);
            int si1 = (Integer)mapN2S.get(ni1);
            ib.put(si0).put(si1).put(ni1);
            ib.put(si0).put(ni1).put(ni0);
        }
        int ni0 = northIndices[numEquatoralVertices - 1];
        int ni1 = northIndices[0];
        int si0 = (Integer)mapN2S.get(ni0);
        int si1 = (Integer)mapN2S.get(ni1);
        mapN2S.clear();
        ib.put(si0).put(si1).put(ni1);
        ib.put(si0).put(ni1).put(ni0);
        VertexBuffer.Format ibFormat = ib.getFormat();
        Buffer ibData = ib.getBuffer();
        ibData.flip();
        this.setBuffer(VertexBuffer.Type.Index, 3, ibFormat, ibData);
        this.updateBound();
        this.setStatic();
    }

    private int addVertex(Vector3f normal) {
        float length = normal.length();
        this.sphereNormals.add(normal.mult(1.0f / length));
        int result = this.nextVertexIndex++;
        return result;
    }

    private int midpointIndex(int p1, int p2) {
        long greaterIndex;
        boolean firstIsSmaller = p1 < p2;
        long smallerIndex = firstIsSmaller ? (long)p1 : (long)p2;
        long key = (smallerIndex << 32) + (greaterIndex = firstIsSmaller ? (long)p2 : (long)p1);
        Integer cachedIndex = this.midpointCache.get(key);
        if (cachedIndex != null) {
            return cachedIndex;
        }
        Vector3f sn1 = this.sphereNormals.get(p1);
        Vector3f sn2 = this.sphereNormals.get(p2);
        Vector3f middleNormal = MyVector3f.midpoint(sn1, sn2, null);
        int newIndex = this.addVertex(middleNormal);
        this.midpointCache.put(key, newIndex);
        return newIndex;
    }
}

