/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.mesh.IndexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class DividedLine
extends Mesh {
    private static final int numAxes = 3;
    public static final Logger logger = Logger.getLogger(DividedLine.class.getName());

    protected DividedLine() {
    }

    public DividedLine(Vector3f endPoint1, Vector3f endPoint2, int numSegments) {
        Validate.positive(numSegments, "number of segments");
        this.setMode(Mesh.Mode.Lines);
        int numVertices = numSegments + 1;
        int numFloats = 3 * numVertices;
        FloatBuffer posBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Position, 3, posBuffer);
        Vector3f temp = new Vector3f();
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            float t = (float)vIndex / (float)numSegments;
            MyVector3f.lerp(t, endPoint1, endPoint2, temp);
            posBuffer.put(temp.x).put(temp.y).put(temp.z);
        }
        assert (posBuffer.position() == numFloats);
        posBuffer.flip();
        int numIndices = 2 * numSegments;
        IndexBuffer indexBuffer = IndexBuffer.createIndexBuffer((int)numVertices, (int)numIndices);
        VertexBuffer.Format ibFormat = indexBuffer.getFormat();
        Buffer ibData = indexBuffer.getBuffer();
        this.setBuffer(VertexBuffer.Type.Index, 1, ibFormat, ibData);
        for (int edgeIndex = 0; edgeIndex < numSegments; ++edgeIndex) {
            indexBuffer.put(edgeIndex);
            indexBuffer.put(edgeIndex + 1);
        }
        ibData.flip();
        assert (indexBuffer.size() == numIndices);
        this.updateBound();
        this.setStatic();
    }
}

