/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.texture.Texture;
import com.jme3.util.SkyFactory;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.mesh.RectangleMesh;

public final class MyAsset {
    private static final Logger logger = Logger.getLogger(MyAsset.class.getName());
    private static final Mesh squareMesh = new RectangleMesh(-1.0f, 1.0f, -1.0f, 1.0f, 1.0f);
    public static final String debugMaterialAssetPath = "MatDefs/debug/ShowNormals.j3md";
    public static final String multicolor2MaterialAssetPath = "MatDefs/wireframe/multicolor2.j3md";
    public static final String particleMaterialAssetPath = "Common/MatDefs/Misc/Particle.j3md";
    public static final String shadedMaterialAssetPath = "Common/MatDefs/Light/Lighting.j3md";
    public static final String unshadedMaterialAssetPath = "Common/MatDefs/Misc/Unshaded.j3md";
    public static final String wireframeMaterialAssetPath = "MatDefs/wireframe/wireframe.j3md";
    private static final Vector3f scaleIdentity = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Vector3f[] faceDirection = new Vector3f[]{new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
    private static final Vector3f[] uDirection = new Vector3f[]{new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)};
    private static final Vector3f[] vDirection = new Vector3f[]{new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f)};

    private MyAsset() {
    }

    public static Vector3f copyFaceDirection(int faceIndex) {
        Vector3f result = faceDirection[faceIndex].normalize();
        return result;
    }

    public static Vector3f copyUDirection(int faceIndex) {
        Vector3f result = uDirection[faceIndex].normalize();
        return result;
    }

    public static Vector3f copyVDirection(int faceIndex) {
        Vector3f result = vDirection[faceIndex].normalize();
        return result;
    }

    public static Material createDebugMaterial(AssetManager assetManager, float gamma) {
        Validate.positive(gamma, "gamma");
        Validate.nonNull(assetManager, "asset manager");
        Material material = new Material(assetManager, debugMaterialAssetPath);
        material.setFloat("Gamma", gamma);
        material.setName("debug");
        return material;
    }

    public static Material createInvisibleMaterial(AssetManager assetManager) {
        Validate.nonNull(assetManager, "asset manager");
        Material material = MyAsset.createUnshadedMaterial(assetManager);
        material.setColor("Color", new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        material.setName("invisible");
        RenderState additional = material.getAdditionalRenderState();
        additional.setBlendMode(RenderState.BlendMode.Alpha);
        additional.setDepthWrite(false);
        additional.setFaceCullMode(RenderState.FaceCullMode.FrontAndBack);
        return material;
    }

    public static Material createMulticolor2Material(AssetManager assetManager, Texture pointShape, float pointSize) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNegative(pointSize, "point size");
        Material material = new Material(assetManager, multicolor2MaterialAssetPath);
        material.setTexture("PointShape", pointShape);
        material.setFloat("PointSize", pointSize);
        return material;
    }

    public static Material createParticleMaterial(AssetManager assetManager, Texture texture) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(texture, "texture");
        Material material = new Material(assetManager, particleMaterialAssetPath);
        material.setTexture("Texture", texture);
        return material;
    }

    public static Material createShadedMaterial(AssetManager assetManager, ColorRGBA color) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(color, "color");
        Material material = new Material(assetManager, shadedMaterialAssetPath);
        material.setBoolean("UseMaterialColors", true);
        material.setColor("Ambient", color.clone());
        material.setColor("Diffuse", color.clone());
        return material;
    }

    public static Material createShadedMaterial(AssetManager assetManager, Texture texture) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(texture, "texture");
        Material material = new Material(assetManager, shadedMaterialAssetPath);
        material.setTexture("DiffuseMap", texture);
        return material;
    }

    public static Material createShinyMaterial(AssetManager assetManager, ColorRGBA color) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(color, "color");
        Material material = MyAsset.createShadedMaterial(assetManager, color);
        material.setColor("Specular", new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        material.setFloat("Shininess", 1.0f);
        return material;
    }

    public static Node createStarMapQuads(AssetManager assetManager, String name) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonEmpty(name, "star map name");
        Texture[] faceTexture = new Texture[]{MyAsset.loadFace(assetManager, name, "right1", false), MyAsset.loadFace(assetManager, name, "left2", false), MyAsset.loadFace(assetManager, name, "top3", false), MyAsset.loadFace(assetManager, name, "bottom4", false), MyAsset.loadFace(assetManager, name, "front5", false), MyAsset.loadFace(assetManager, name, "back6", false)};
        Node result = new Node("star map");
        result.setQueueBucket(RenderQueue.Bucket.Sky);
        for (int faceIndex = 0; faceIndex < 6; ++faceIndex) {
            String faceName = String.format("%s_face%d", name, faceIndex + 1);
            Geometry geometry = new Geometry(faceName, squareMesh);
            result.attachChild((Spatial)geometry);
            Texture texture = faceTexture[faceIndex];
            Material material = MyAsset.createUnshadedMaterial(assetManager, texture);
            geometry.setMaterial(material);
            Vector3f offset = faceDirection[faceIndex].clone();
            geometry.setLocalTranslation(offset);
            Vector3f u = uDirection[faceIndex];
            Vector3f v = vDirection[faceIndex];
            Vector3f w = faceDirection[faceIndex].negate();
            Quaternion orientation = new Quaternion();
            orientation.fromAxes(u, v, w);
            geometry.setLocalRotation(orientation);
        }
        return result;
    }

    public static Geometry createStarMapSphere(AssetManager assetManager, String name, float radius) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonEmpty(name, "star map name");
        Validate.positive(radius, "radius");
        Texture right = MyAsset.loadFace(assetManager, name, "right1", true);
        Texture left = MyAsset.loadFace(assetManager, name, "left2", true);
        Texture top = MyAsset.loadFace(assetManager, name, "top3", true);
        Texture bottom = MyAsset.loadFace(assetManager, name, "bottom4", true);
        Texture front = MyAsset.loadFace(assetManager, name, "front5", true);
        Texture back = MyAsset.loadFace(assetManager, name, "back6", true);
        Spatial starMap = SkyFactory.createSky((AssetManager)assetManager, (Texture)right, (Texture)left, (Texture)back, (Texture)front, (Texture)top, (Texture)bottom, (Vector3f)scaleIdentity, (float)radius);
        return (Geometry)starMap;
    }

    public static Material createUnshadedMaterial(AssetManager assetManager) {
        Validate.nonNull(assetManager, "asset manager");
        Material material = new Material(assetManager, unshadedMaterialAssetPath);
        return material;
    }

    public static Material createUnshadedMaterial(AssetManager assetManager, ColorRGBA color) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(color, "color");
        Material material = MyAsset.createUnshadedMaterial(assetManager);
        material.setColor("Color", color.clone());
        return material;
    }

    public static Material createUnshadedMaterial(AssetManager assetManager, String assetPath) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonEmpty(assetPath, "path");
        Texture texture = MyAsset.loadTexture(assetManager, assetPath, false);
        Material material = MyAsset.createUnshadedMaterial(assetManager, texture);
        return material;
    }

    public static Material createUnshadedMaterial(AssetManager assetManager, Texture texture) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(texture, "texture");
        Material material = MyAsset.createUnshadedMaterial(assetManager);
        material.setTexture("ColorMap", texture);
        return material;
    }

    public static Material createWireframeMaterial(AssetManager assetManager, ColorRGBA color) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(color, "color");
        float pointSize = 1.0f;
        Material material = MyAsset.createWireframeMaterial(assetManager, color, pointSize);
        return material;
    }

    public static Material createWireframeMaterial(AssetManager assetManager, ColorRGBA color, float pointSize) {
        Validate.nonNull(assetManager, "asset manager");
        Validate.nonNull(color, "color");
        Validate.nonNegative(pointSize, "point size");
        Material material = new Material(assetManager, wireframeMaterialAssetPath);
        material.setColor("Color", color.clone());
        material.setFloat("PointSize", pointSize);
        return material;
    }

    public static Texture loadFace(AssetManager assetManager, String mapName, String faceName, boolean flipY) {
        Validate.nonEmpty(mapName, "folder name");
        Validate.nonEmpty(faceName, "face name");
        String path = String.format("Textures/skies/star-maps/%s/%s_%s.png", mapName, mapName, faceName);
        TextureKey key = new TextureKey(path, flipY);
        key.setGenerateMips(true);
        Texture texture = assetManager.loadTexture(key);
        assert (texture != null);
        return texture;
    }

    public static Texture loadTexture(AssetManager assetManager, String assetPath, boolean generateMips) {
        Validate.nonEmpty(assetPath, "path");
        boolean flipY = false;
        TextureKey key = new TextureKey(assetPath, flipY);
        key.setGenerateMips(generateMips);
        Texture texture = assetManager.loadTexture(key);
        assert (texture != null);
        return texture;
    }
}

