/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class SignalTracker {
    public static final Logger logger = Logger.getLogger(SignalTracker.class.getName());
    private final Map<String, Set<Integer>> statusMap = new TreeMap<String, Set<Integer>>();

    public void add(String name) {
        Validate.nonNull(name, "signal name");
        Set<Integer> status = this.statusMap.get(name);
        if (status == null) {
            status = new TreeSet<Integer>();
            this.statusMap.put(name, status);
        }
    }

    public void setActive(String signalName, int sourceIndex, boolean newState) {
        Validate.nonNull(signalName, "signal name");
        Set<Integer> status = this.statusMap.get(signalName);
        if (status == null) {
            logger.log(Level.WARNING, "Unknown signal: {0}", MyString.quote(signalName));
            return;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "name = {0}, newState = {1}", new Object[]{MyString.quote(signalName), newState});
        }
        if (newState) {
            status.add(sourceIndex);
        } else {
            status.remove(sourceIndex);
        }
    }

    public boolean test(String signalName) {
        Validate.nonNull(signalName, "signal name");
        Set<Integer> status = this.statusMap.get(signalName);
        if (status == null) {
            logger.log(Level.WARNING, "Testing a signal which has not yet been added: {0}.", MyString.quote(signalName));
            status = new TreeSet<Integer>();
            this.statusMap.put(signalName, status);
        }
        boolean result = !status.isEmpty();
        return result;
    }
}

