/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppStateManager;
import com.jme3.asset.AssetManager;
import com.jme3.input.FlyByCamera;
import com.jme3.input.InputManager;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.NamedAppState;

public class SimpleAppState
extends NamedAppState {
    private static final Logger logger = Logger.getLogger(SimpleAppState.class.getName());
    protected AppStateManager stateManager;
    protected AssetManager assetManager;
    protected Camera cam;
    protected FlyByCamera flyCam;
    protected InputManager inputManager;
    protected Node guiNode;
    protected Node rootNode;
    protected RenderManager renderManager;
    protected SimpleApplication simpleApplication;
    protected ViewPort guiViewPort;
    protected ViewPort viewPort;

    public SimpleAppState(boolean initialState) {
        super(initialState);
    }

    public SimpleAppState(InitialState initialState) {
        super(initialState);
    }

    public void refreshCachedFields() {
        this.stateManager = this.simpleApplication.getStateManager();
        assert (this.stateManager != null);
        this.assetManager = this.simpleApplication.getAssetManager();
        assert (this.assetManager != null);
        this.cam = this.simpleApplication.getCamera();
        assert (this.cam != null);
        this.flyCam = this.simpleApplication.getFlyByCamera();
        this.inputManager = this.simpleApplication.getInputManager();
        assert (this.inputManager != null);
        this.guiNode = this.simpleApplication.getGuiNode();
        assert (this.guiNode != null);
        this.rootNode = this.simpleApplication.getRootNode();
        assert (this.rootNode != null);
        this.renderManager = this.simpleApplication.getRenderManager();
        assert (this.renderManager != null);
        this.guiViewPort = this.simpleApplication.getGuiViewPort();
        assert (this.guiViewPort != null);
        this.viewPort = this.simpleApplication.getViewPort();
        assert (this.viewPort != null);
    }

    @Override
    public void initialize(AppStateManager sm, Application app) {
        if (!(app instanceof SimpleApplication)) {
            throw new IllegalArgumentException("application should be a SimpleApplication");
        }
        super.initialize(sm, app);
        this.simpleApplication = (SimpleApplication)app;
        this.refreshCachedFields();
        assert (this.isInitialized());
    }

    @Override
    public void render(RenderManager rm) {
        if (rm != this.renderManager) {
            throw new IllegalArgumentException("wrong render manager");
        }
        super.render(rm);
    }

    @Override
    public void stateDetached(AppStateManager sm) {
        if (sm != this.stateManager) {
            throw new IllegalArgumentException("wrong state manager");
        }
        super.stateDetached(sm);
    }
}

