/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities;

import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.InitialState;
import jme3utilities.NamedAppState;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class TimeOfDay
extends NamedAppState {
    public static final int hoursPerDay = 24;
    public static final int minutesPerHour = 60;
    public static final int secondsPerMinute = 60;
    public static final int secondsPerHour = 3600;
    public static final int secondsPerDay = 86400;
    private static final Logger logger = Logger.getLogger(TimeOfDay.class.getName());
    private double timeOfDay;
    private float rate = 1.0f;

    public TimeOfDay(float startHour) {
        super(InitialState.Enabled);
        if (!(startHour >= 0.0f) || !(startHour < 24.0f)) {
            logger.log(Level.SEVERE, "startHour={0}", Float.valueOf(startHour));
            throw new IllegalArgumentException("hour should be between 0 and 24");
        }
        this.timeOfDay = startHour * 3600.0f;
    }

    public float getRate() {
        return this.rate;
    }

    public float hour() {
        float result = (float)this.timeOfDay / 3600.0f;
        if (result == 24.0f) {
            result = 0.0f;
        }
        assert (result >= 0.0f) : result;
        assert (result <= 24.0f) : result;
        return result;
    }

    public int second() {
        int result = (int)Math.round(this.timeOfDay);
        if (result == 86400) {
            result = 0;
        }
        assert (result >= 0) : result;
        assert (result < 86400) : result;
        return result;
    }

    public void setHour(float newHour) {
        Validate.inRange(newHour, "new hour", 0.0f, 24.0f);
        this.timeOfDay = 3600.0 * (double)newHour;
    }

    public void setRate(float newRate) {
        this.rate = newRate;
    }

    @Override
    public String toString() {
        int second = this.second();
        int ss = second % 60;
        int minute = second / 60;
        int mm = minute % 60;
        int hh = minute / 60;
        String result = String.format("%02d:%02d:%02d", hh, mm, ss);
        return result;
    }

    @Override
    public void update(float interval) {
        super.update(interval);
        double simulatedSeconds = this.rate * interval;
        this.timeOfDay += simulatedSeconds;
        this.timeOfDay = MyMath.modulo(this.timeOfDay, 86400.0);
    }
}

