/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.util.HasLocalTransform;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.asset.TextureKey;
import com.jme3.audio.AudioData;
import com.jme3.audio.AudioNode;
import com.jme3.audio.AudioSource;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.LightList;
import com.jme3.light.LightProbe;
import com.jme3.light.PointLight;
import com.jme3.light.SpotLight;
import com.jme3.material.MatParam;
import com.jme3.material.MatParamOverride;
import com.jme3.material.Material;
import com.jme3.material.MaterialDef;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.math.Vector4f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.Camera;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.Control;
import com.jme3.scene.mesh.MorphTarget;
import com.jme3.shadow.AbstractShadowRenderer;
import com.jme3.shadow.CompareMode;
import com.jme3.shadow.DirectionalLightShadowFilter;
import com.jme3.shadow.DirectionalLightShadowRenderer;
import com.jme3.shadow.EdgeFilteringMode;
import com.jme3.shadow.PointLightShadowFilter;
import com.jme3.shadow.PointLightShadowRenderer;
import com.jme3.shadow.SpotLightShadowFilter;
import com.jme3.shadow.SpotLightShadowRenderer;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.texture.TextureCubeMap;
import com.jme3.util.IntMap;
import com.jme3.util.SafeArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import jme3utilities.MyCamera;
import jme3utilities.MyControl;
import jme3utilities.MyLight;
import jme3utilities.MyMesh;
import jme3utilities.MySkeleton;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyColor;
import jme3utilities.math.MyQuaternion;
import jme3utilities.math.MyVector3f;

public class Describer
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Describer.class.getName());
    private String listSeparator = " ";

    public String describe(Armature armature) {
        Validate.nonNull(armature, "armature");
        int numRoots = MySkeleton.countRootJoints(armature);
        int numJoints = armature.getJointCount();
        String result = String.format("Armature with %d root%s and %d joint%s:", numRoots, numRoots == 1 ? "" : "s", numJoints, numJoints == 1 ? "" : "s");
        return result;
    }

    public String describe(Bone bone) {
        ArrayList children;
        StringBuilder builder = new StringBuilder(30);
        String nameText = MyString.quote(bone.getName());
        builder.append(nameText);
        String flags = "";
        if (MySkeleton.getAttachments(bone) != null) {
            flags = flags + 'A';
        }
        if (bone.hasUserControl()) {
            flags = flags + 'U';
        }
        if (!flags.isEmpty()) {
            builder.append(' ');
            builder.append(flags);
        }
        if (!(children = bone.getChildren()).isEmpty()) {
            int numChildren = children.size();
            String childText = String.format(" with %d child%s:", numChildren, numChildren == 1 ? "" : "ren");
            builder.append(childText);
        }
        return builder.toString();
    }

    public String describe(BoundingBox aabb) {
        StringBuilder builder = new StringBuilder(80);
        builder.append("loc[");
        Vector3f location = aabb.getCenter();
        String desc = MyVector3f.describe(location);
        builder.append(desc);
        builder.append(']');
        Vector3f he = aabb.getExtent(null);
        desc = this.describeHalfExtents(he);
        builder.append(desc);
        return builder.toString();
    }

    public String describe(BoundingSphere sphere) {
        StringBuilder builder = new StringBuilder(80);
        builder.append("r=");
        float radius = sphere.getRadius();
        String desc = MyString.describe(radius);
        builder.append(desc);
        builder.append(' ');
        Vector3f location = sphere.getCenter();
        desc = MyVector3f.describe(location);
        builder.append(desc);
        return builder.toString();
    }

    public String describe(BoundingVolume boundingVolume) {
        String result;
        if (boundingVolume == null) {
            result = "null";
        } else if (boundingVolume instanceof BoundingSphere) {
            result = this.describe((BoundingSphere)boundingVolume);
        } else {
            BoundingBox aabb = (BoundingBox)boundingVolume;
            result = this.describe(aabb);
        }
        return result;
    }

    public String describe(Joint joint) {
        List children;
        StringBuilder builder = new StringBuilder(30);
        String nameText = MyString.quote(joint.getName());
        builder.append(nameText);
        if (MySkeleton.getAttachments(joint) != null) {
            builder.append(" A");
        }
        if (!(children = joint.getChildren()).isEmpty()) {
            int numChildren = children.size();
            String childText = String.format(" with %d child%s:", numChildren, numChildren == 1 ? "" : "ren");
            builder.append(childText);
        }
        return builder.toString();
    }

    public String describe(Material material) {
        if (material == null) {
            return "";
        }
        StringBuilder result = new StringBuilder(80);
        String name = material.getName();
        result.append(MyString.quoteName(name));
        result.append(" def");
        MaterialDef def = material.getMaterialDef();
        String defName = def == null ? null : def.getName();
        String description = MyString.quote(defName);
        result.append(description);
        result.append(' ');
        RenderState state = material.getAdditionalRenderState();
        description = this.describe(state);
        result.append(description);
        Collection params = material.getParams();
        int numParams = params.size();
        String count = String.format(" with %d parm%s", numParams, numParams == 1 ? "" : "s");
        result.append(count);
        return result.toString();
    }

    public String describe(MatParam matParam) {
        String valueString;
        StringBuilder result = new StringBuilder(80);
        result.append(' ');
        String paramName = matParam.getName();
        result.append(paramName);
        result.append(": ");
        Object obj = matParam.getValue();
        if (obj instanceof ColorRGBA) {
            ColorRGBA color = (ColorRGBA)obj;
            valueString = MyColor.describe(color);
        } else if (obj instanceof Float) {
            float value = ((Float)obj).floatValue();
            valueString = MyString.describe(value);
        } else if (obj instanceof Texture) {
            Texture texture = (Texture)obj;
            valueString = this.describe(texture);
        } else {
            valueString = matParam.getValueAsString();
        }
        result.append(valueString);
        return result.toString();
    }

    public String describe(Mesh mesh) {
        StringBuilder result = new StringBuilder(80);
        boolean addSeparators = false;
        String name = mesh.getClass().getSimpleName();
        result.append(name);
        result.append(" mode=");
        Mesh.Mode mode = mesh.getMode();
        result.append(mode);
        result.append(" numV=");
        int numV = mesh.getVertexCount();
        result.append(numV);
        result.append(" bufs[");
        IntMap buffers = mesh.getBuffers();
        for (IntMap.Entry bufferEntry : buffers) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            VertexBuffer buffer = (VertexBuffer)bufferEntry.getValue();
            String desc = this.describe(buffer);
            result.append(desc);
        }
        result.append(']');
        MorphTarget[] targets = mesh.getMorphTargets();
        int numTargets = targets.length;
        if (numTargets > 0) {
            result.append(" with ");
            result.append(numTargets);
            result.append(" target");
            if (numTargets > 1) {
                result.append('s');
            }
        }
        return result.toString();
    }

    public String describe(Skeleton skeleton) {
        int numRoots = MySkeleton.countRootBones(skeleton);
        int numBones = skeleton.getBoneCount();
        String result = String.format("Skeleton with %d root%s and %d bone%s:", numRoots, numRoots == 1 ? "" : "s", numBones, numBones == 1 ? "" : "s");
        return result;
    }

    public String describe(Texture texture) {
        String result = "null";
        if (texture != null) {
            TextureKey textureKey = (TextureKey)texture.getKey();
            result = textureKey == null ? "(no key)" : this.describe(textureKey);
            Texture.MagFilter mag = texture.getMagFilter();
            result = result + " mag:" + mag.toString();
            Texture.MinFilter min = texture.getMinFilter();
            result = result + " min:" + min.toString();
            int aniso = texture.getAnisotropicFilter();
            result = result + " aniso:" + aniso;
            if (texture instanceof Texture3D || texture instanceof TextureCubeMap) {
                Texture.WrapMode rWrap = texture.getWrap(Texture.WrapAxis.R);
                result = result + " r:" + rWrap.toString();
            }
            Texture.WrapMode sWrap = texture.getWrap(Texture.WrapAxis.S);
            result = result + " s:" + sWrap.toString();
            Texture.WrapMode tWrap = texture.getWrap(Texture.WrapAxis.T);
            result = result + " t:" + tWrap.toString();
        }
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    public String describe(VertexBuffer buffer) {
        String formatString;
        VertexBuffer.Format format = buffer.getFormat();
        if (format == null) {
            formatString = "nofmt";
        } else {
            formatString = format.toString();
            formatString = formatString.toLowerCase(Locale.ROOT);
            formatString = formatString.replace("float", "f");
            formatString = formatString.replace("unsigned", "u");
        }
        int numComponents = buffer.getNumComponents();
        VertexBuffer.Type type = buffer.getBufferType();
        String result = type + "%" + numComponents + formatString;
        return result;
    }

    public String describeAudioNode(Spatial spatial) {
        AudioNode audioNode = (AudioNode)spatial;
        StringBuilder result = new StringBuilder(80);
        AudioSource.Status status = audioNode.getStatus();
        result.append(status);
        if (status == AudioSource.Status.Playing) {
            result.append(",");
            AudioData.DataType type = audioNode.getAudioData().getDataType();
            result.append(type);
            result.append(",");
            boolean isDirectional = audioNode.isDirectional();
            if (!isDirectional) {
                result.append("NOT");
            }
            result.append("directional,");
            boolean isLooping = audioNode.isLooping();
            if (!isLooping) {
                result.append("NOT");
            }
            result.append("looping,");
            result.append("pitch=");
            float pitch = audioNode.getPitch();
            result.append(MyString.describe(pitch));
            result.append(",channel=");
            int channel = audioNode.getChannel();
            result.append(channel);
        }
        return result.toString();
    }

    public String describeBucket(Spatial spatial) {
        StringBuilder result = new StringBuilder(20);
        result.append("bucket=");
        RenderQueue.Bucket bucket = spatial.getLocalQueueBucket();
        result.append(bucket);
        if (bucket == RenderQueue.Bucket.Inherit) {
            result.append('/');
            bucket = spatial.getQueueBucket();
            result.append(bucket);
        }
        return result.toString();
    }

    public String describeControls(Spatial spatial) {
        Validate.nonNull(spatial, "spatial");
        StringBuilder result = new StringBuilder(50);
        int count = spatial.getNumControls();
        boolean addSeparators = false;
        for (int controlI = 0; controlI < count; ++controlI) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            Control control = spatial.getControl(controlI);
            boolean isEnabled = this.isControlEnabled(control);
            if (!isEnabled) continue;
            String description = this.describe(control);
            result.append(description);
        }
        return result.toString();
    }

    public String describeCull(Spatial spatial) {
        StringBuilder result = new StringBuilder(20);
        result.append("cull=");
        Spatial.CullHint mode = spatial.getLocalCullHint();
        result.append(mode);
        if (mode == Spatial.CullHint.Inherit) {
            result.append('/');
            mode = spatial.getCullHint();
            result.append(mode);
        }
        return result.toString();
    }

    public String describeFilters(FilterPostProcessor fpp) {
        StringBuilder result = new StringBuilder(20);
        boolean addSeparators = false;
        List list = fpp.getFilterList();
        for (Filter filter : list) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            String description = this.describe(filter);
            result.append(description);
        }
        return result.toString();
    }

    public String describeFlags(ViewPort viewPort) {
        StringBuilder result = new StringBuilder(32);
        if (!viewPort.isClearColor()) {
            result.append("NO");
        }
        result.append("clColor,");
        if (!viewPort.isClearDepth()) {
            result.append("NO");
        }
        result.append("clDepth,");
        if (!viewPort.isClearStencil()) {
            result.append("NO");
        }
        result.append("clStencil");
        return result.toString();
    }

    public String describeFloats(float ... data) {
        StringBuilder result = new StringBuilder(170);
        result.append('(');
        result.append(data.length);
        result.append(')');
        for (float value : data) {
            if (result.length() > 150) {
                result.append(" ...");
                break;
            }
            result.append(this.listSeparator);
            String description = MyString.describe(value);
            result.append(description);
        }
        return result.toString();
    }

    public String describeLocation(Spatial spatial) {
        Validate.nonNull(spatial, "spatial");
        StringBuilder result = new StringBuilder(30);
        Vector3f location = MySpatial.worldLocation(spatial, null);
        if (!MyVector3f.isZero(location)) {
            result.append("loc[");
            String locText = MyVector3f.describe(location);
            result.append(locText);
            result.append(']');
        }
        return result.toString();
    }

    public String describeOrientation(Spatial spatial) {
        Validate.nonNull(spatial, "spatial");
        StringBuilder result = new StringBuilder(30);
        Quaternion orientation = MySpatial.worldOrientation(spatial, null);
        if (!MyQuaternion.isRotationIdentity(orientation)) {
            result.append("orient[");
            String orientText = MyQuaternion.describe(orientation);
            result.append(orientText);
            result.append(']');
        }
        return result.toString();
    }

    public String describeOverrides(Spatial spatial) {
        Validate.nonNull(spatial, "spatial");
        StringBuilder result = new StringBuilder(60);
        result.append("mpo[");
        boolean addSeparators = false;
        SafeArrayList list = spatial.getLocalMatParamOverrides();
        for (MatParamOverride override : list) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            String description = this.describe(override);
            result.append(description);
        }
        result.append(']');
        return result.toString();
    }

    public String describeProcessors(ViewPort viewPort) {
        StringBuilder result = new StringBuilder(20);
        boolean addSeparators = false;
        SafeArrayList pList = viewPort.getProcessors();
        for (SceneProcessor processor : pList) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            String description = this.describe(processor);
            result.append(description);
        }
        return result.toString();
    }

    public String describeScale(Spatial spatial) {
        Validate.nonNull(spatial, "spatial");
        Vector3f worldScale = MySpatial.worldScale(spatial, null);
        String result = this.describeScale(worldScale);
        return result;
    }

    public String describeScale(Vector3f vector) {
        Validate.nonNull(vector, "vector");
        StringBuilder result = new StringBuilder(30);
        if (!MyVector3f.isScaleIdentity(vector)) {
            result.append("scale[");
            String vectorText = MyVector3f.describe(vector);
            result.append(vectorText);
            result.append(']');
        }
        return result.toString();
    }

    public String describeShadow(Spatial spatial) {
        StringBuilder result = new StringBuilder(20);
        result.append("shadow=");
        RenderQueue.ShadowMode mode = spatial.getLocalShadowMode();
        result.append(mode);
        if (mode == RenderQueue.ShadowMode.Inherit) {
            result.append('/');
            mode = spatial.getShadowMode();
            result.append(mode);
        }
        return result.toString();
    }

    public String describeTrackTarget(HasLocalTransform target) {
        if (target == null) {
            return "null";
        }
        String targetName = target instanceof Spatial ? ((Spatial)target).getName() : ((Joint)target).getName();
        String className = target.getClass().getSimpleName();
        String qTargetName = MyString.quoteName(targetName);
        String result = String.format(" targeting %s%s:", className, qTargetName);
        return result;
    }

    public String describeUserData(Spatial spatial) {
        StringBuilder result = new StringBuilder(50);
        boolean addSeparators = false;
        Collection keys = spatial.getUserDataKeys();
        for (String key : keys) {
            if (addSeparators) {
                result.append(' ');
            } else {
                addSeparators = true;
            }
            result.append(key);
            result.append('=');
            Object value = spatial.getUserData(key);
            String valueString = value == null || value instanceof String ? MyString.quote((String)value) : value.toString();
            result.append(valueString);
        }
        return result.toString();
    }

    public String describeVertexData(Mesh mesh, int vertexIndex) {
        Vector2f norm;
        StringBuilder builder = new StringBuilder(80);
        int numVertices = mesh.getVertexCount();
        String format = numVertices <= 10 ? "v%1d: " : (numVertices <= 100 ? "v%02d: " : (numVertices <= 1000 ? "v%03d: " : "v%04d: "));
        String desc = String.format(Locale.ROOT, format, vertexIndex);
        builder.append(desc);
        int length = builder.length();
        Vector3f pos = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Position, vertexIndex, null);
        desc = MyVector3f.describe(pos);
        builder.append(desc);
        int alignLength = length + 37;
        if (MyMesh.hasUV(mesh)) {
            length = builder.length();
            if (length < alignLength) {
                builder.append(MyString.repeat(" ", alignLength - length));
            }
            norm = MyMesh.vertexVector2f(mesh, VertexBuffer.Type.TexCoord, vertexIndex, null);
            builder.append(" u=");
            builder.append(norm.x);
            builder.append(" v=");
            builder.append(norm.y);
            alignLength += 26;
        }
        if (mesh.getBuffer(VertexBuffer.Type.TexCoord2) != null) {
            length = builder.length();
            if (length < alignLength) {
                builder.append(MyString.repeat(" ", alignLength - length));
            }
            norm = MyMesh.vertexVector2f(mesh, VertexBuffer.Type.TexCoord2, vertexIndex, null);
            builder.append(" u2=");
            builder.append(norm.x);
            builder.append(" v2=");
            builder.append(norm.y);
            alignLength += 28;
        }
        if (MyMesh.hasNormals(mesh)) {
            length = builder.length();
            if (length < alignLength) {
                builder.append(MyString.repeat(" ", alignLength - length));
            }
            builder.append(" N[");
            norm = MyMesh.vertexVector3f(mesh, VertexBuffer.Type.Normal, vertexIndex, null);
            desc = MyVector3f.describeDirection((Vector3f)norm);
            builder.append(desc);
            builder.append(']');
            alignLength += 32;
        }
        if (mesh.getBuffer(VertexBuffer.Type.Color) != null) {
            length = builder.length();
            if (length < alignLength) {
                builder.append(MyString.repeat(" ", alignLength - length));
            }
            builder.append(' ');
            ColorRGBA color = MyMesh.vertexColor(mesh, vertexIndex, null);
            desc = MyColor.describe(color);
            builder.append(desc);
            alignLength += 24;
        }
        if (mesh.getBuffer(VertexBuffer.Type.Tangent) != null) {
            length = builder.length();
            if (length < alignLength) {
                builder.append(MyString.repeat(" ", alignLength - length));
            }
            builder.append(" T");
            Vector4f tangent = MyMesh.vertexVector4f(mesh, VertexBuffer.Type.Tangent, vertexIndex, null);
            builder.append(tangent);
        }
        return builder.toString();
    }

    public String listSeparator() {
        assert (this.listSeparator != null);
        return this.listSeparator;
    }

    public void setListSeparator(String newSeparator) {
        Validate.nonNull(newSeparator, "new separator");
        this.listSeparator = newSeparator;
    }

    protected String describe(Camera camera) {
        String result = MyCamera.describe(camera);
        return result;
    }

    protected String describe(Control control) {
        Validate.nonNull(control, "control");
        String result = MyControl.describe(control);
        return result;
    }

    protected String describe(Filter filter) {
        String result;
        if (filter instanceof DirectionalLightShadowFilter) {
            result = "DShadow";
        } else if (filter instanceof PointLightShadowFilter) {
            result = "PShadow";
        } else if (filter instanceof SpotLightShadowFilter) {
            result = "SShadow";
        } else if (filter == null) {
            result = "null";
        } else {
            result = filter.getClass().getSimpleName();
            if ((result = result.replace("Filter", "")).isEmpty()) {
                result = "?";
            }
        }
        return result;
    }

    protected String describe(Light light) {
        String result;
        if (light == null) {
            result = "null";
        } else {
            String quotedName = MyString.quoteName(light.getName());
            String typeName = MyLight.describeType(light) + quotedName;
            ColorRGBA color = light.getColor();
            String rgb = MyColor.describe(color);
            if (light instanceof AmbientLight) {
                result = String.format("%s(%s)", typeName, rgb);
            } else if (light instanceof DirectionalLight) {
                Vector3f direction = ((DirectionalLight)light).getDirection();
                String dir = MyVector3f.describeDirection(direction);
                result = String.format("%s(%s; %s)", typeName, rgb, dir);
            } else if (light instanceof LightProbe) {
                LightProbe probe = (LightProbe)light;
                if (probe.isReady()) {
                    LightProbe.AreaType areaType = probe.getAreaType();
                    float radius = probe.getArea().getRadius();
                    String r = MyString.describe(radius);
                    Vector3f location = probe.getPosition();
                    String loc = MyVector3f.describe(location);
                    result = String.format("%s(%s r=%s %s)", typeName, areaType, r, loc);
                } else {
                    result = String.format("%s(unready)", typeName);
                }
            } else if (light instanceof PointLight) {
                Vector3f location = ((PointLight)light).getPosition();
                String loc = MyVector3f.describe(location);
                result = String.format("%s(%s; %s)", typeName, rgb, loc);
            } else if (light instanceof SpotLight) {
                SpotLight spotLight = (SpotLight)light;
                Vector3f location = spotLight.getPosition();
                String loc = MyVector3f.describe(location);
                Vector3f direction = spotLight.getDirection();
                String dir = MyVector3f.describeDirection(direction);
                result = String.format("%s(%s; %s; %s)", typeName, rgb, loc, dir);
            } else {
                result = String.format("%s(%s)", typeName, rgb);
            }
            if (!light.isEnabled()) {
                result = result + "DISABLED";
            }
        }
        return result;
    }

    protected String describe(LightList lightList) {
        StringBuilder result = new StringBuilder(50);
        boolean addSeparators = false;
        for (Light light : lightList) {
            if (addSeparators) {
                result.append(this.listSeparator);
            } else {
                addSeparators = true;
            }
            String description = this.describe(light);
            result.append(description);
        }
        return result.toString();
    }

    protected String describe(MatParamOverride override) {
        StringBuilder result = new StringBuilder(50);
        String name = override.getName();
        result.append(name);
        Object value = override.getValue();
        if (value == null) {
            result.append("=null");
        } else {
            String valueString = value.toString();
            if (valueString.length() <= 8) {
                result.append('=');
                result.append(valueString);
            }
        }
        if (!override.isEnabled()) {
            result.append("!DISABLED");
        }
        return result.toString();
    }

    protected String describe(RenderState state) {
        StringBuilder result = new StringBuilder(30);
        if (!state.isDepthTest()) {
            result.append("NO");
        }
        result.append("dTest,");
        if (!state.isDepthWrite()) {
            result.append("NO");
        }
        result.append("dWrite,");
        if (!state.isWireframe()) {
            result.append("NO");
        }
        result.append("wireframe");
        RenderState.FaceCullMode faceCullMode = state.getFaceCullMode();
        if (faceCullMode != RenderState.FaceCullMode.Back) {
            result.append(",faceCull=");
            result.append(faceCullMode);
        }
        result.append(",blend=");
        RenderState.BlendMode blendMode = state.getBlendMode();
        result.append(blendMode);
        if (blendMode == RenderState.BlendMode.Custom) {
            RenderState.BlendEquation equation = state.getBlendEquation();
            result.append("[eq=").append(equation);
            RenderState.BlendEquationAlpha eqA = state.getBlendEquationAlpha();
            result.append(",eqA=").append(eqA);
            RenderState.BlendFunc dAlpha = state.getCustomDfactorAlpha();
            result.append(",dAlpha=").append(dAlpha);
            RenderState.BlendFunc dRgb = state.getCustomDfactorRGB();
            result.append(",dRGB=").append(dRgb);
            RenderState.BlendFunc sAlpha = state.getCustomSfactorAlpha();
            result.append(",sAlpha=").append(sAlpha);
            RenderState.BlendFunc sRgb = state.getCustomSfactorRGB();
            result.append(",sRGB=").append(sRgb).append(']');
        }
        return result.toString();
    }

    protected String describe(SceneProcessor processor) {
        String result;
        if (processor instanceof DirectionalLightShadowRenderer) {
            result = "DirShadow" + this.describeShadowRenderer(processor);
        } else if (processor instanceof FilterPostProcessor) {
            FilterPostProcessor fpp = (FilterPostProcessor)processor;
            String desc = this.describeFilters(fpp);
            result = String.format("filters[%s]", desc);
        } else if (processor instanceof PointLightShadowRenderer) {
            result = "PointShadow" + this.describeShadowRenderer(processor);
        } else if (processor instanceof ScreenshotAppState) {
            result = "Screenshot";
        } else if (processor instanceof SpotLightShadowRenderer) {
            result = "SpotShadow" + this.describeShadowRenderer(processor);
        } else if (processor == null) {
            result = "null";
        } else {
            result = processor.getClass().getSimpleName();
            if ((result = result.replace("Processor", "")).isEmpty()) {
                result = "?";
            }
        }
        return result;
    }

    protected String describe(TextureKey textureKey) {
        String result = textureKey.toString();
        int anisotropy = textureKey.getAnisotropy();
        if (anisotropy != 0) {
            result = result + String.format(" (Anisotropy%d)", anisotropy);
        }
        assert (result != null);
        assert (!result.isEmpty());
        return result;
    }

    protected String describeHalfExtents(Vector3f he) {
        String desc = MyVector3f.describe(he);
        String result = String.format(" he[%s]", desc);
        return result;
    }

    protected String describeMore(Camera camera) {
        Validate.nonNull(camera, "camera");
        String result = MyCamera.describeMore(camera);
        return result;
    }

    protected char describeType(Spatial spatial) {
        char result = MySpatial.describeType(spatial);
        return result;
    }

    protected boolean isControlEnabled(Control control) {
        Validate.nonNull(control, "control");
        boolean result = !MyControl.canDisable(control) || MyControl.isEnabled(control);
        return result;
    }

    public Describer clone() throws CloneNotSupportedException {
        Describer clone = (Describer)super.clone();
        return clone;
    }

    private String describeShadowRenderer(SceneProcessor processor) {
        StringBuilder result = new StringBuilder(20);
        AbstractShadowRenderer renderer = (AbstractShadowRenderer)processor;
        result.append("[inten=");
        float inten = renderer.getShadowIntensity();
        result.append(MyString.describeFraction(inten));
        result.append(" size=");
        int size = renderer.getShadowMapSize();
        result.append(size);
        result.append(" maps=");
        int maps = renderer.getNumShadowMaps();
        result.append(maps);
        result.append(" edge[");
        EdgeFilteringMode mode = renderer.getEdgeFilteringMode();
        result.append(mode);
        result.append(" thk=");
        int thk = renderer.getEdgesThickness();
        result.append(thk);
        result.append("] cmp=");
        CompareMode cmp = renderer.getShadowCompareMode();
        result.append(cmp);
        result.append(" zExt=");
        float zExt = renderer.getShadowZExtend();
        result.append(MyString.describe(zExt));
        result.append(" zFade=");
        float zFade = renderer.getShadowZFadeLength();
        result.append(MyString.describe(zFade));
        boolean backFaces = renderer.isRenderBackFacesShadows();
        result.append(backFaces ? " backFaces]" : "noBackFaces]");
        return result.toString();
    }
}

