/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.debug;

import com.jme3.asset.AssetManager;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MyAsset;
import jme3utilities.SubtreeControl;
import jme3utilities.Validate;
import jme3utilities.math.MyVector3f;

public class VectorVisualizer
extends SubtreeControl {
    private static final boolean defaultDepthTest = false;
    public static final float widthForSolid = 0.0f;
    private static final Logger logger = Logger.getLogger(VectorVisualizer.class.getName());
    private static final String modelAssetPath = "Models/indicators/arrow/arrow.j3o";
    private static final String subtreeName = "vector node";
    private static final String tagColor = "color";
    private static final String tagDepthTest = "depthTest";
    private static final String tagLineWidth = "lineWidth";
    private static final String tagTipOffset = "tipOffset";
    private AssetManager assetManager;
    private boolean depthTest = false;
    private ColorRGBA color = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private float lineWidth;
    private Vector3f tipOffset = new Vector3f();

    protected VectorVisualizer() {
    }

    public VectorVisualizer(AssetManager manager, float width) {
        Validate.nonNull(manager, "asset manager");
        Validate.nonNegative(width, "line width");
        this.assetManager = manager;
        this.lineWidth = width;
    }

    public ColorRGBA color(ColorRGBA storeResult) {
        if (storeResult == null) {
            return this.color.clone();
        }
        return storeResult.set(this.color);
    }

    public boolean isDepthTest() {
        return this.depthTest;
    }

    public float lineWidth() {
        assert (this.lineWidth >= 0.0f) : this.lineWidth;
        return this.lineWidth;
    }

    public void setColor(ColorRGBA color) {
        Validate.nonNull(color, tagColor);
        this.color.set(color);
    }

    public void setDepthTest(boolean newSetting) {
        this.depthTest = newSetting;
    }

    public void setLineWidth(float width) {
        Validate.nonNegative(width, "width");
        this.lineWidth = width;
    }

    public void setTipOffset(Vector3f offset) {
        Validate.nonNull(offset, "offset");
        this.tipOffset.set(offset);
    }

    public Vector3f tipLocation() {
        Vector3f result = null;
        if (this.isEnabled()) {
            Node subtreeNode = (Node)this.getSubtree();
            result = subtreeNode.localToWorld(this.tipOffset, null);
        }
        return result;
    }

    public Vector3f tipOffset(Vector3f storeResult) {
        if (storeResult == null) {
            return this.tipOffset.clone();
        }
        return storeResult.set(this.tipOffset);
    }

    @Override
    public VectorVisualizer clone() throws CloneNotSupportedException {
        VectorVisualizer clone = (VectorVisualizer)super.clone();
        return clone;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.color = this.color.clone();
        this.tipOffset = this.tipOffset.clone();
    }

    @Override
    protected void controlUpdate(float updateInterval) {
        super.controlUpdate(updateInterval);
        Node subtreeNode = (Node)this.getSubtree();
        int numChildren = subtreeNode.getQuantity();
        if (numChildren == 1) {
            Geometry arrow = (Geometry)subtreeNode.getChild(0);
            Mesh mesh = arrow.getMesh();
            boolean isWireArrow = mesh instanceof Arrow;
            if (this.lineWidth >= 1.0f && isWireArrow) {
                this.updateWireArrow();
            } else if (this.lineWidth < 1.0f && !isWireArrow) {
                this.updateSolidArrow();
            } else {
                subtreeNode.detachAllChildren();
                this.addArrow();
            }
        } else {
            subtreeNode.detachAllChildren();
            this.addArrow();
        }
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        this.assetManager = importer.getAssetManager();
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.color = (ColorRGBA)capsule.readSavable(tagColor, null);
        this.depthTest = capsule.readBoolean(tagDepthTest, false);
        this.lineWidth = capsule.readFloat(tagLineWidth, 0.0f);
        this.tipOffset = (Vector3f)capsule.readSavable(tagTipOffset, null);
    }

    @Override
    public void setEnabled(boolean newState) {
        if (newState && this.getSubtree() == null) {
            Node subtreeNode = new Node(subtreeName);
            subtreeNode.setQueueBucket(RenderQueue.Bucket.Transparent);
            subtreeNode.setShadowMode(RenderQueue.ShadowMode.Off);
            this.setSubtree((Spatial)subtreeNode);
        }
        super.setEnabled(newState);
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable)this.color, tagColor, null);
        capsule.write(this.depthTest, tagDepthTest, false);
        capsule.write(this.lineWidth, tagLineWidth, 0.0f);
        capsule.write((Savable)this.tipOffset, tagTipOffset, null);
    }

    private void addArrow() {
        assert (((Node)this.getSubtree()).getQuantity() == 0);
        if (this.lineWidth >= 1.0f) {
            this.addWireArrow();
        } else {
            this.addSolidArrow();
        }
    }

    private void addSolidArrow() {
        assert (this.assetManager != null);
        assert (this.color != null);
        Node node = (Node)this.assetManager.loadModel(modelAssetPath);
        Node node2 = (Node)node.getChild(0);
        Node node3 = (Node)node2.getChild(0);
        Geometry geometry = (Geometry)node3.getChild(0);
        ((Node)this.getSubtree()).attachChild((Spatial)geometry);
        Material material = MyAsset.createUnshadedMaterial(this.assetManager, this.color);
        geometry.setMaterial(material);
        material.setName("arrowMaterial");
        geometry.setName("arrow");
        this.updateSolidArrow();
    }

    private void addWireArrow() {
        Arrow mesh = new Arrow(this.tipOffset);
        Geometry geometry = new Geometry("arrow", (Mesh)mesh);
        Node subtreeNode = (Node)this.getSubtree();
        subtreeNode.attachChild((Spatial)geometry);
        Material material = MyAsset.createWireframeMaterial(this.assetManager, this.color);
        geometry.setMaterial(material);
        material.setName("arrowMaterial");
        RenderState state = material.getAdditionalRenderState();
        state.setDepthTest(this.depthTest);
        state.setLineWidth(this.lineWidth);
    }

    private void updateColor(Material material) {
        ColorRGBA oldColor = (ColorRGBA)material.getParamValue("Color");
        if (!oldColor.equals((Object)this.color)) {
            material.setColor("Color", this.color.clone());
        }
    }

    private void updateSolidArrow() {
        Node subtreeNode = (Node)this.getSubtree();
        Geometry geometry = (Geometry)subtreeNode.getChild(0);
        float length = this.tipOffset.length();
        geometry.setLocalScale(length);
        if (length > 0.0f) {
            Vector3f xDir = this.tipOffset.clone();
            Vector3f yDir = new Vector3f();
            Vector3f zDir = new Vector3f();
            MyVector3f.generateBasis(xDir, yDir, zDir);
            Quaternion orientation = new Quaternion();
            orientation.fromAxes(xDir, yDir, zDir);
            geometry.setLocalRotation(orientation);
        }
        Material material = geometry.getMaterial();
        this.updateColor(material);
        RenderState state = material.getAdditionalRenderState();
        state.setDepthTest(this.depthTest);
    }

    private void updateWireArrow() {
        Node subtreeNode = (Node)this.getSubtree();
        Geometry geometry = (Geometry)subtreeNode.getChild(0);
        Arrow mesh = (Arrow)geometry.getMesh();
        mesh.setArrowExtent(this.tipOffset);
        Material material = geometry.getMaterial();
        this.updateColor(material);
        RenderState state = material.getAdditionalRenderState();
        state.setDepthTest(this.depthTest);
        state.setLineWidth(this.lineWidth);
    }
}

