/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.Triangle;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class Cone
extends Mesh {
    private static final int numAxes = 3;
    private static final int vpt = 3;
    public static final Logger logger = Logger.getLogger(Cone.class.getName());

    protected Cone() {
    }

    public Cone(int numSides, float radius, float yHeight, boolean generatePyramid) {
        Validate.inRange(numSides, "number of sides", 3, Integer.MAX_VALUE);
        Validate.positive(radius, "radius");
        Validate.positive(yHeight, "height");
        int numBaseTriangles = numSides - 2;
        int numTriangles = numBaseTriangles + numSides;
        int numFloats = numTriangles * 3 * 3;
        FloatBuffer positionBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Position, 3, positionBuffer);
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)numFloats);
        this.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
        float yApex = yHeight / 2.0f;
        float yBase = -yHeight / 2.0f;
        double interiorAngle = Math.PI * 2 / (double)numSides;
        double theta0 = (double)(numSides - 1) * interiorAngle;
        float x0 = radius * (float)Math.sin(theta0);
        float z0 = radius * (float)Math.cos(theta0);
        float tangent = radius / yHeight;
        float cosine = 1.0f / MyMath.hypotenuse(1.0f, tangent);
        float ny = cosine * tangent;
        Triangle triangle = new Triangle();
        Vector3f p1 = new Vector3f();
        Vector3f p2 = new Vector3f();
        Vector3f p3 = new Vector3f();
        for (int sideIndex = 0; sideIndex < numSides; ++sideIndex) {
            double theta1 = (double)sideIndex * interiorAngle;
            float x1 = radius * (float)Math.sin(theta1);
            float z1 = radius * (float)Math.cos(theta1);
            int nextSideIndex = sideIndex + 1;
            double theta2 = (double)nextSideIndex * interiorAngle;
            float x2 = radius * (float)Math.sin(theta2);
            float z2 = radius * (float)Math.cos(theta2);
            p1.set(x1, yBase, z1);
            p2.set(x2, yBase, z2);
            p3.set(0.0f, yApex, 0.0f);
            positionBuffer.put(p1.x).put(p1.y).put(p1.z);
            positionBuffer.put(p2.x).put(p2.y).put(p2.z);
            positionBuffer.put(p3.x).put(p3.y).put(p3.z);
            if (generatePyramid) {
                triangle.set(p1, p2, p3);
                Vector3f normal = triangle.getNormal();
                for (int j = 0; j < 3; ++j) {
                    normalBuffer.put(normal.x).put(normal.y).put(normal.z);
                }
            } else {
                float nx = cosine * x1 / radius;
                float nz = cosine * z1 / radius;
                normalBuffer.put(nx).put(ny).put(nz);
                nx = cosine * x2 / radius;
                nz = cosine * z2 / radius;
                normalBuffer.put(nx).put(ny).put(nz);
                double thetaMid = (theta1 + theta2) / 2.0;
                nx = cosine * (float)Math.sin(thetaMid);
                nz = cosine * (float)Math.cos(thetaMid);
                normalBuffer.put(nx).put(ny).put(nz);
            }
            if (sideIndex >= numBaseTriangles) continue;
            positionBuffer.put(x0).put(yBase).put(z0);
            positionBuffer.put(x2).put(yBase).put(z2);
            positionBuffer.put(x1).put(yBase).put(z1);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
            normalBuffer.put(0.0f).put(-1.0f).put(0.0f);
        }
        positionBuffer.flip();
        assert (positionBuffer.limit() == positionBuffer.capacity());
        normalBuffer.flip();
        assert (normalBuffer.limit() == positionBuffer.capacity());
        this.updateBound();
        this.setStatic();
    }
}

