/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.math.FastMath;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class DiscMesh
extends Mesh {
    private static final int numAxes = 3;
    private static final Logger logger = Logger.getLogger(DiscMesh.class.getName());

    public DiscMesh() {
        this(1.0f, 25);
    }

    public DiscMesh(float radius, int numVertices) {
        Validate.nonNegative(radius, "radius");
        Validate.inRange(numVertices, "number of vertices", 3, Integer.MAX_VALUE);
        this.setMode(Mesh.Mode.TriangleFan);
        float[] normals = new float[3 * numVertices];
        float[] positions = new float[3 * numVertices];
        float[] texCoords = new float[2 * numVertices];
        for (int vi = 0; vi < numVertices; ++vi) {
            normals[3 * vi] = 0.0f;
            normals[3 * vi + 1] = 0.0f;
            normals[3 * vi + 2] = 1.0f;
            float theta = (float)Math.PI * 2 * (float)vi / (float)numVertices;
            float sin = FastMath.sin((float)theta);
            float cos = FastMath.cos((float)theta);
            positions[3 * vi] = radius * cos;
            positions[3 * vi + 1] = radius * sin;
            positions[3 * vi + 2] = 0.0f;
            texCoords[2 * vi] = (1.0f + cos) / 2.0f;
            texCoords[2 * vi + 1] = (1.0f + sin) / 2.0f;
        }
        this.setBuffer(VertexBuffer.Type.Normal, 3, normals);
        this.setBuffer(VertexBuffer.Type.Position, 3, positions);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, texCoords);
        this.updateBound();
        this.setStatic();
    }
}

