/*
 * Decompiled with CFR 0.152.
 */
package jme3utilities.mesh;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class DomeMesh
extends Mesh {
    public static final float defaultTopU = 0.5f;
    public static final float defaultTopV = 0.5f;
    public static final float defaultUvScale = 0.44f;
    private static final int numAxes = 3;
    private static final int vpt = 3;
    private static final Logger logger = Logger.getLogger(DomeMesh.class.getName());
    private boolean complete;
    private boolean inwardFacing;
    private float segmentAngle;
    private float topU;
    private float topV;
    private float uvScale;
    private float verticalAngle;
    private int quadrantSamples;
    private int rimSamples;
    private int triangleCount;
    private int vertexCount;

    protected DomeMesh() {
    }

    public DomeMesh(int rimSamples, int quadrantSamples) {
        this(rimSamples, quadrantSamples, 0.5f, 0.5f, 0.44f, true);
    }

    public DomeMesh(int rimSamples, int quadrantSamples, float topU, float topV, float uvScale, boolean inwardFacing) {
        Validate.inRange(rimSamples, "rim samples", 3, Integer.MAX_VALUE);
        this.rimSamples = rimSamples;
        Validate.inRange(quadrantSamples, "quadrant samples", 2, Integer.MAX_VALUE);
        this.quadrantSamples = quadrantSamples;
        Validate.fraction(topU, "topU");
        this.topU = topU;
        Validate.fraction(topV, "topV");
        this.topV = topV;
        if (!(uvScale > 0.0f) || !(uvScale < 0.5f)) {
            logger.log(Level.SEVERE, "uvScale={0}", Float.valueOf(uvScale));
            throw new IllegalArgumentException("uvScale should be between 0 and 0.5");
        }
        this.uvScale = uvScale;
        this.inwardFacing = inwardFacing;
        this.segmentAngle = (float)Math.PI * 2;
        this.verticalAngle = 1.5707964f;
        this.updateAll();
        this.setStatic();
    }

    public Vector2f directionUV(Vector3f direction) {
        Validate.nonZero(direction, "direction");
        Vector3f norm = direction.normalize();
        float angleFromTop = FastMath.acos((float)norm.y);
        float uvDistance = this.uvScale * angleFromTop / 1.5707964f;
        float x = norm.x;
        float z = norm.z;
        float xzDistance = MyMath.hypotenuse(x, z);
        if (xzDistance == 0.0f) {
            if (norm.y < 0.0f) {
                return null;
            }
            return new Vector2f(this.topU, this.topV);
        }
        float cosLongitude = x / xzDistance;
        float sinLongitude = z / xzDistance;
        float u = this.topU + uvDistance * cosLongitude;
        float v = this.topV - uvDistance * sinLongitude;
        if (u < 0.0f || u > 1.0f || v < 0.0f || v > 1.0f) {
            return null;
        }
        return new Vector2f(u, v);
    }

    public float elevationAngle(float u, float v) {
        Validate.fraction(u, "u");
        Validate.fraction(v, "v");
        float uvDistance = MyMath.hypotenuse(u - this.topU, v - this.topV);
        float angleFromTop = uvDistance / this.uvScale * 1.5707964f;
        assert (angleFromTop < (float)Math.PI) : angleFromTop;
        float elevationAngle = 1.5707964f - angleFromTop;
        assert (elevationAngle <= 1.5707964f) : elevationAngle;
        return elevationAngle;
    }

    @Deprecated
    public float getUVScale() {
        assert (this.uvScale > 0.0f) : this.uvScale;
        assert (this.uvScale < 0.5f) : this.uvScale;
        return this.uvScale;
    }

    public float getUvScale() {
        assert (this.uvScale > 0.0f) : this.uvScale;
        assert (this.uvScale < 0.5f) : this.uvScale;
        return this.uvScale;
    }

    public float getVerticalAngle() {
        assert (this.verticalAngle > 0.0f) : this.verticalAngle;
        assert (this.verticalAngle < (float)Math.PI) : this.verticalAngle;
        return this.verticalAngle;
    }

    public void setSegmentAngle(float newAngle) {
        if (!(newAngle > 0.0f) || !(newAngle <= (float)Math.PI * 2)) {
            logger.log(Level.SEVERE, "angle={0}", Float.valueOf(newAngle));
            throw new IllegalArgumentException("angle should be between 0 and 2*Pi");
        }
        this.segmentAngle = newAngle;
        this.updateAll();
    }

    public void setVerticalAngle(float newAngle) {
        if (!(newAngle > 0.0f) || !(newAngle < (float)Math.PI)) {
            logger.log(Level.SEVERE, "angle={0}", Float.valueOf(newAngle));
            throw new IllegalArgumentException("angle should be between 0 and Pi");
        }
        this.verticalAngle = newAngle;
        this.updateAll();
    }

    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.inwardFacing = capsule.readBoolean("inwardFacing", true);
        this.quadrantSamples = capsule.readInt("quadrantSamples", 2);
        this.rimSamples = capsule.readInt("rimSamples", 3);
        this.segmentAngle = capsule.readFloat("segmentAngle", (float)Math.PI * 2);
        this.topU = capsule.readFloat("topU", 0.5f);
        this.topV = capsule.readFloat("topV", 0.5f);
        this.uvScale = capsule.readFloat("uvScale", 0.44f);
        this.verticalAngle = capsule.readFloat("verticalAngle", 1.5707964f);
        this.updateDerivedProperties();
    }

    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.inwardFacing, "inwardFacing", true);
        capsule.write(this.quadrantSamples, "quadrantSamples", 2);
        capsule.write(this.rimSamples, "rimSamples", 3);
        capsule.write(this.segmentAngle, "segmentAngle", (float)Math.PI * 2);
        capsule.write(this.topU, "topU", 0.5f);
        capsule.write(this.topV, "topV", 0.5f);
        capsule.write(this.uvScale, "uvScale", 0.44f);
        capsule.write(this.verticalAngle, "verticalAngle", 1.5707964f);
    }

    private void updateAll() {
        this.updateDerivedProperties();
        this.updateCoordinates();
        this.updateIndices();
        this.updateNormals();
        this.updateBound();
    }

    private void updateCoordinates() {
        Vector3f[] locationArray = new Vector3f[this.vertexCount];
        Vector2f[] texCoordArray = new Vector2f[this.vertexCount];
        float quadHeight = this.verticalAngle / (float)(this.quadrantSamples - 1);
        float quadWidth = this.complete ? (float)Math.PI * 2 / (float)this.rimSamples : this.segmentAngle / (float)(this.rimSamples - 1);
        for (int parallel = 0; parallel < this.quadrantSamples - 1; ++parallel) {
            float latitude = 1.5707964f - this.verticalAngle + quadHeight * (float)parallel;
            float y = FastMath.sin((float)latitude);
            float xzDistance = FastMath.cos((float)latitude);
            for (int meridian = 0; meridian < this.rimSamples; ++meridian) {
                Vector2f uv;
                Vector3f location;
                float longitude = quadWidth * (float)meridian;
                float sinLongitude = FastMath.sin((float)longitude);
                float cosLongitude = FastMath.cos((float)longitude);
                float x = xzDistance * cosLongitude;
                float z = xzDistance * sinLongitude;
                int vertexIndex = parallel * this.rimSamples + meridian;
                logger.log(Level.FINE, "coords {0}", vertexIndex);
                locationArray[vertexIndex] = location = new Vector3f(x, y, z);
                texCoordArray[vertexIndex] = uv = this.directionUV(location);
            }
        }
        int topIndex = this.vertexCount - 1;
        logger.log(Level.INFO, "coords {0}", topIndex);
        locationArray[topIndex] = new Vector3f(0.0f, 1.0f, 0.0f);
        texCoordArray[topIndex] = new Vector2f(this.topU, this.topV);
        FloatBuffer locBuffer = BufferUtils.createFloatBuffer((Vector3f[])locationArray);
        this.setBuffer(VertexBuffer.Type.Position, 3, locBuffer);
        FloatBuffer tcBuffer = BufferUtils.createFloatBuffer((Vector2f[])texCoordArray);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, tcBuffer);
    }

    private void updateDerivedProperties() {
        if (this.rimSamples < 3) {
            logger.log(Level.SEVERE, "rimSamples={0}", this.rimSamples);
            throw new IllegalStateException("need at least 3 samples on the rim");
        }
        if (this.quadrantSamples < 2) {
            logger.log(Level.SEVERE, "quadrantSamples={0}", this.quadrantSamples);
            throw new IllegalStateException("need at least 2 samples per longitudinal quadrant");
        }
        this.complete = this.segmentAngle > 6.2800436f;
        int quadsPerGore = this.quadrantSamples - 2;
        int trianglesPerGore = 2 * quadsPerGore + 1;
        this.triangleCount = trianglesPerGore * this.rimSamples;
        logger.log(Level.INFO, "{0} triangles", this.triangleCount);
        this.vertexCount = (this.quadrantSamples - 1) * this.rimSamples + 1;
        logger.log(Level.INFO, "{0} vertices", this.vertexCount);
        assert (this.vertexCount <= Short.MAX_VALUE) : this.vertexCount;
    }

    private void updateIndices() {
        int v1Index;
        int v0Index;
        int nextMeridian;
        int meridian;
        int parallel;
        short[] indexArray = new short[3 * this.triangleCount];
        int numGores = this.complete ? this.rimSamples : this.rimSamples - 1;
        int quadsPerGore = this.quadrantSamples - 2;
        for (parallel = 0; parallel < quadsPerGore; ++parallel) {
            int nextParallel = parallel + 1;
            for (meridian = 0; meridian < numGores; ++meridian) {
                nextMeridian = (meridian + 1) % this.rimSamples;
                v0Index = parallel * this.rimSamples + meridian;
                v1Index = parallel * this.rimSamples + nextMeridian;
                int v2Index = nextParallel * this.rimSamples + meridian;
                int v3Index = nextParallel * this.rimSamples + nextMeridian;
                int triIndex = 2 * v0Index;
                int baseIndex = 3 * triIndex;
                logger.log(Level.FINE, "index {0}", triIndex);
                indexArray[3 * triIndex] = (short)v0Index;
                if (this.inwardFacing) {
                    indexArray[baseIndex + 1] = (short)v1Index;
                    indexArray[baseIndex + 2] = (short)v3Index;
                } else {
                    indexArray[baseIndex + 1] = (short)v3Index;
                    indexArray[baseIndex + 2] = (short)v1Index;
                }
                baseIndex = 3 * ++triIndex;
                logger.log(Level.FINE, "index {0}", triIndex);
                indexArray[baseIndex] = (short)v0Index;
                if (this.inwardFacing) {
                    indexArray[baseIndex + 1] = (short)v3Index;
                    indexArray[baseIndex + 2] = (short)v2Index;
                    continue;
                }
                indexArray[baseIndex + 1] = (short)v2Index;
                indexArray[baseIndex + 2] = (short)v3Index;
            }
        }
        parallel = quadsPerGore;
        int topIndex = this.vertexCount - 1;
        for (meridian = 0; meridian < numGores; ++meridian) {
            nextMeridian = (meridian + 1) % this.rimSamples;
            v0Index = parallel * this.rimSamples + meridian;
            v1Index = parallel * this.rimSamples + nextMeridian;
            int triIndex = 2 * quadsPerGore * this.rimSamples + meridian;
            int baseIndex = 3 * triIndex;
            logger.log(Level.FINE, "index {0}", triIndex);
            indexArray[baseIndex] = (short)v0Index;
            if (this.inwardFacing) {
                indexArray[baseIndex + 1] = (short)v1Index;
                indexArray[baseIndex + 2] = (short)topIndex;
                continue;
            }
            indexArray[baseIndex + 1] = (short)topIndex;
            indexArray[baseIndex + 2] = (short)v1Index;
        }
        ShortBuffer indexBuffer = BufferUtils.createShortBuffer((short[])indexArray);
        this.setBuffer(VertexBuffer.Type.Index, 3, indexBuffer);
    }

    private void updateNormals() {
        Vector3f[] normalArray = new Vector3f[this.vertexCount];
        FloatBuffer locationBuffer = this.getFloatBuffer(VertexBuffer.Type.Position);
        locationBuffer.rewind();
        float[] vertex = new float[3];
        for (int vertexIndex = 0; vertexIndex < this.vertexCount; ++vertexIndex) {
            locationBuffer.get(vertex, 0, 3);
            Vector3f normal = new Vector3f(vertex[0], vertex[1], vertex[2]);
            assert (normal.isUnitVector()) : normal;
            if (this.inwardFacing) {
                normal.negateLocal();
            }
            logger.log(Level.FINE, "normal {0}", vertexIndex);
            normalArray[vertexIndex] = normal;
        }
        FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((Vector3f[])normalArray);
        this.setBuffer(VertexBuffer.Type.Normal, 3, normalBuffer);
    }
}

