/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.NpoTracker;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import jme3utilities.Validate;

public abstract class NativePhysicsObject
implements Comparable<NativePhysicsObject> {
    public static final Logger loggerN = Logger.getLogger(NativePhysicsObject.class.getName());
    private long id = 0L;
    private static final Map<Long, NpoTracker> map = new ConcurrentHashMap<Long, NpoTracker>(999);
    static final ReferenceQueue<NativePhysicsObject> weakReferenceQueue = new ReferenceQueue();

    public static final int countTrackers() {
        int result = map.size();
        return result;
    }

    public static final void dumpTrackers() {
        System.out.println("Active trackers:");
        for (NpoTracker tracker : map.values()) {
            System.out.println(" " + tracker);
        }
        System.out.flush();
    }

    public static final void freeUnusedObjects() {
        try {
            while (true) {
                NpoTracker tracker = (NpoTracker)weakReferenceQueue.remove();
                tracker.freeTrackedObject();
            }
        }
        catch (InterruptedException exception) {
            return;
        }
    }

    public final boolean hasAssignedNativeObject() {
        return this.id != 0L;
    }

    public long nativeId() {
        assert (this.hasAssignedNativeObject());
        return this.id;
    }

    static void removeTracker(long nativeId) {
        assert (nativeId != 0L);
        NpoTracker tracker = map.remove(nativeId);
        assert (tracker != null);
    }

    protected final void reassignNativeId(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"nativeId");
        if (nativeId != this.id) {
            this.id = nativeId;
            NpoTracker tracker = new NpoTracker(this);
            NpoTracker previous = map.put(nativeId, tracker);
            assert (previous == null) : this.id;
        }
    }

    protected void setNativeId(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"nativeId");
        assert (!this.hasAssignedNativeObject()) : this.id;
        this.id = nativeId;
        NpoTracker tracker = new NpoTracker(this);
        NpoTracker previous = map.put(nativeId, tracker);
        assert (previous == null) : this.id;
    }

    protected final void setNativeIdNotTracked(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"nativeId");
        assert (!this.hasAssignedNativeObject()) : this.id;
        this.id = nativeId;
    }

    protected final void unassignNativeObject() {
        assert (this.hasAssignedNativeObject());
        this.id = 0L;
    }

    @Override
    public int compareTo(NativePhysicsObject other) {
        long objectId = this.nativeId();
        long otherId = other.nativeId();
        int result = Long.compare(objectId, otherId);
        return result;
    }

    public boolean equals(Object otherObject) {
        NativePhysicsObject otherNpo;
        long otherId;
        boolean result = otherObject == this ? true : (otherObject != null && otherObject.getClass() == this.getClass() ? this.id == (otherId = (otherNpo = (NativePhysicsObject)otherObject).nativeId()) : false);
        return result;
    }

    public int hashCode() {
        int hash = (int)(this.id >> 4);
        return hash;
    }

    public String toString() {
        String result = this.getClass().getSimpleName();
        result = result + "#" + Long.toHexString(this.id);
        return result;
    }
}

