/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.FreeingMethods;
import com.jme3.bullet.NativePhysicsObject;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

class NpoTracker
extends WeakReference<NativePhysicsObject> {
    public static final Logger logger = Logger.getLogger(NpoTracker.class.getName());
    private final Class<? extends NativePhysicsObject> referentClass;
    private final long id;

    NpoTracker(NativePhysicsObject referent) {
        super(referent, NativePhysicsObject.weakReferenceQueue);
        this.referentClass = referent.getClass();
        this.id = referent.nativeId();
        assert (this.id != 0L);
    }

    void freeTrackedObject() {
        int invocationCount = 0;
        NativePhysicsObject.removeTracker(this.id);
        Method[] methods = FreeingMethods.listMethods(this.referentClass);
        Object[] boxedId = new Object[]{this.id};
        for (Method method : methods) {
            try {
                method.invoke(null, boxedId);
                ++invocationCount;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
        assert (invocationCount > 0) : invocationCount;
    }

    public String toString() {
        String result = this.referentClass.getSimpleName();
        result = result + "_" + Long.toHexString(this.id);
        return result;
    }
}

