/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.app.AppTask;
import com.jme3.bullet.CollisionSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.SolverInfo;
import com.jme3.bullet.SolverType;
import com.jme3.bullet.collision.ContactListener;
import com.jme3.bullet.collision.PersistentManifolds;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsCharacter;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.objects.PhysicsVehicle;
import com.jme3.bullet.util.NativeLibrary;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.util.SafeArrayList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PhysicsSpace
extends CollisionSpace
implements ContactListener {
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_Z = 2;
    public static final Logger logger = Logger.getLogger(PhysicsSpace.class.getName());
    private final Deque<PhysicsCollisionEvent> contactProcessedEvents = new ArrayDeque<PhysicsCollisionEvent>(20);
    private final Deque<PhysicsCollisionEvent> contactStartedEvents = new ArrayDeque<PhysicsCollisionEvent>(20);
    private float accuracy = 0.016666668f;
    private float maxTimeStep = 0.1f;
    private int maxSubSteps = 4;
    private final Collection<ContactListener> contactListeners = new SafeArrayList(ContactListener.class);
    private final Collection<PhysicsCollisionListener> contactProcessedListeners = new SafeArrayList(PhysicsCollisionListener.class);
    private final Collection<PhysicsCollisionListener> contactStartedListeners = new SafeArrayList(PhysicsCollisionListener.class);
    private final Collection<PhysicsTickListener> tickListeners = new SafeArrayList(PhysicsTickListener.class);
    private final Map<Long, PhysicsCharacter> characterMap = new ConcurrentHashMap<Long, PhysicsCharacter>(64);
    private final Map<Long, PhysicsJoint> jointMap = new ConcurrentHashMap<Long, PhysicsJoint>(64);
    private final Map<Long, PhysicsRigidBody> rigidMap = new ConcurrentHashMap<Long, PhysicsRigidBody>(64);
    private final Map<Long, PhysicsVehicle> vehicleMap = new ConcurrentHashMap<Long, PhysicsVehicle>(64);
    private final Queue<AppTask<?>> pQueue = new ConcurrentLinkedQueue();
    private SolverInfo solverInfo;
    private SolverType solverType = SolverType.SI;
    protected static final ThreadLocal<Queue<AppTask<?>>> pQueueTL = new ThreadLocal<Queue<AppTask<?>>>(){

        @Override
        protected ConcurrentLinkedQueue<AppTask<?>> initialValue() {
            return new ConcurrentLinkedQueue();
        }
    };
    private final Vector3f gravity = new Vector3f(0.0f, -9.81f, 0.0f);

    public PhysicsSpace(BroadphaseType broadphaseType) {
        this(new Vector3f(-10000.0f, -10000.0f, -10000.0f), new Vector3f(10000.0f, 10000.0f, 10000.0f), broadphaseType);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax) {
        this(worldMin, worldMax, BroadphaseType.AXIS_SWEEP_3);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax, BroadphaseType broadphaseType) {
        super(worldMin, worldMax, broadphaseType, NativeLibrary.countThreads());
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax, BroadphaseType broadphaseType, int numSolvers) {
        super(worldMin, worldMax, broadphaseType, numSolvers);
    }

    public PhysicsSpace(Vector3f worldMin, Vector3f worldMax, BroadphaseType broadphaseType, SolverType solverType) {
        super(worldMin, worldMax, broadphaseType);
        Validate.nonNull((Object)((Object)solverType), (String)"solver type");
        if (this.solverType != solverType) {
            this.solverType = solverType;
            this.updateSolver();
        }
    }

    public void activateAll(boolean forceFlag) {
        for (PhysicsRigidBody rigidBody : this.rigidMap.values()) {
            rigidBody.activate(forceFlag);
        }
    }

    public void addAll(Spatial spatial) {
        this.add(spatial);
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial child : children) {
                this.addAll(child);
            }
        }
    }

    public void addCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!this.contactStartedListeners.contains(listener));
        this.contactStartedListeners.add(listener);
    }

    public void addContactListener(ContactListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!this.contactListeners.contains(listener));
        this.contactListeners.add(listener);
    }

    public void addJoint(PhysicsJoint joint) {
        PhysicsBody b;
        Validate.nonNull((Object)joint, (String)"joint");
        if (this.contains(joint)) {
            logger.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{joint, this});
            return;
        }
        assert (joint.getPhysicsSpace() == null);
        PhysicsBody a = joint.getBodyA();
        if (a != null && !this.contains(a)) {
            logger.log(Level.WARNING, "{0} at the A end of {1} has not yet been added to {2}.", new Object[]{a, joint, this});
        }
        if ((b = joint.getBodyB()) != null && !this.contains(b)) {
            logger.log(Level.WARNING, "{0} at the B end of {1} has not yet been added to {2}.", new Object[]{b, joint, this});
        }
        assert (a != b) : a;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding {0} to {1}.", new Object[]{joint, this});
        }
        long jointId = joint.nativeId();
        this.jointMap.put(jointId, joint);
        joint.setPhysicsSpace(this);
        if (joint instanceof Constraint) {
            long spaceId = this.nativeId();
            boolean disableCollisions = false;
            PhysicsSpace.addConstraintC(spaceId, jointId, disableCollisions);
        }
    }

    public void addOngoingCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!this.contactProcessedListeners.contains(listener));
        this.contactProcessedListeners.add(listener);
    }

    public void addTickListener(PhysicsTickListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        assert (!this.tickListeners.contains(listener));
        this.tickListeners.add(listener);
    }

    public boolean contains(PhysicsJoint joint) {
        long jointId = joint.nativeId();
        boolean result = this.jointMap.containsKey(jointId);
        return result;
    }

    public int countCollisionListeners() {
        int result = this.contactProcessedListeners.size() + this.contactStartedListeners.size();
        return result;
    }

    public int countJoints() {
        long spaceId = this.nativeId();
        int count = PhysicsSpace.getNumConstraints(spaceId);
        assert (count == this.jointMap.size()) : count;
        return count;
    }

    public int countManifolds() {
        long spaceId = this.nativeId();
        int result = PhysicsSpace.countManifolds(spaceId);
        return result;
    }

    public int countRigidBodies() {
        int count = this.rigidMap.size();
        return count;
    }

    public int countTickListeners() {
        int count = this.tickListeners.size();
        return count;
    }

    public void distributeEvents() {
        PhysicsCollisionEvent event;
        while (!this.contactStartedEvents.isEmpty()) {
            event = this.contactStartedEvents.pop();
            for (PhysicsCollisionListener listener : this.contactStartedListeners) {
                listener.collision(event);
            }
        }
        while (!this.contactProcessedEvents.isEmpty()) {
            event = this.contactProcessedEvents.pop();
            for (PhysicsCollisionListener listener : this.contactProcessedListeners) {
                listener.collision(event);
            }
        }
    }

    public <V> Future<V> enqueue(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        this.pQueue.add(task);
        return task;
    }

    public static <V> Future<V> enqueueOnThisThread(Callable<V> callable) {
        AppTask task = new AppTask(callable);
        pQueueTL.get().add(task);
        return task;
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public Collection<PhysicsCharacter> getCharacterList() {
        Collection<PhysicsCharacter> result = this.characterMap.values();
        return Collections.unmodifiableCollection(result);
    }

    public Vector3f getGravity(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        assert (this.checkGravity(result));
        result.set(this.gravity);
        return result;
    }

    public Collection<PhysicsJoint> getJointList() {
        Collection<PhysicsJoint> result = this.jointMap.values();
        return Collections.unmodifiableCollection(result);
    }

    public static PhysicsSpace getPhysicsSpace() {
        return (PhysicsSpace)PhysicsSpace.getCollisionSpace();
    }

    public Collection<PhysicsRigidBody> getRigidBodyList() {
        Collection<PhysicsRigidBody> result = this.rigidMap.values();
        return Collections.unmodifiableCollection(result);
    }

    public SolverInfo getSolverInfo() {
        return this.solverInfo;
    }

    public int getSolverNumIterations() {
        return this.solverInfo.numIterations();
    }

    public SolverType getSolverType() {
        return this.solverType;
    }

    public Collection<PhysicsVehicle> getVehicleList() {
        Collection<PhysicsVehicle> result = this.vehicleMap.values();
        return Collections.unmodifiableCollection(result);
    }

    public boolean isUsingScr() {
        long spaceId = this.nativeId();
        boolean result = PhysicsSpace.isSpeculativeContactRestitution(spaceId);
        return result;
    }

    public long[] listManifoldIds() {
        long spaceId = this.nativeId();
        int numManifolds = PhysicsSpace.countManifolds(spaceId);
        long[] result = new long[numManifolds];
        for (int index = 0; index < numManifolds; ++index) {
            long manifoldId;
            result[index] = manifoldId = PhysicsSpace.getManifoldByIndex(spaceId, index);
        }
        return result;
    }

    public int maxSubSteps() {
        assert (this.maxSubSteps >= 0) : this.maxSubSteps;
        return this.maxSubSteps;
    }

    public float maxTimeStep() {
        assert (this.maxTimeStep > 0.0f) : this.maxTimeStep;
        return this.maxTimeStep;
    }

    public void removeAll(Spatial spatial) {
        this.remove(spatial);
        if (spatial instanceof Node) {
            List children = ((Node)spatial).getChildren();
            for (Spatial child : children) {
                this.removeAll(child);
            }
        }
    }

    public void removeCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.contactStartedListeners.remove(listener);
        assert (success);
    }

    public void removeContactListener(ContactListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.contactListeners.remove(listener);
        assert (success);
    }

    public void removeJoint(PhysicsJoint joint) {
        Validate.nonNull((Object)joint, (String)"joint");
        long jointId = joint.nativeId();
        if (!this.jointMap.containsKey(jointId)) {
            logger.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{joint, this});
            return;
        }
        assert (joint.getPhysicsSpace() == this);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Removing {0} from {1}.", new Object[]{joint, this});
        }
        this.jointMap.remove(jointId);
        joint.setPhysicsSpace(null);
        if (joint instanceof Constraint) {
            long spaceId = this.nativeId();
            PhysicsSpace.removeConstraint(spaceId, jointId);
        }
    }

    public void removeOngoingCollisionListener(PhysicsCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.contactProcessedListeners.remove(listener);
        assert (success);
    }

    public void removeTickListener(PhysicsTickListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        boolean success = this.tickListeners.remove(listener);
        assert (success);
    }

    public void setAccuracy(float accuracy) {
        Validate.positive((float)accuracy, (String)"accuracy");
        this.accuracy = accuracy;
    }

    public void setGravity(Vector3f gravity) {
        this.gravity.set(gravity);
        long spaceId = this.nativeId();
        PhysicsSpace.setGravity(spaceId, gravity);
    }

    public void setMaxSubSteps(int steps) {
        Validate.nonNegative((int)steps, (String)"steps");
        this.maxSubSteps = steps;
    }

    public void setMaxTimeStep(float maxTimeStep) {
        Validate.positive((float)maxTimeStep, (String)"max time step");
        this.maxTimeStep = maxTimeStep;
    }

    public void setSolverNumIterations(int numIterations) {
        Validate.positive((int)numIterations, (String)"number of iterations");
        this.solverInfo.setNumIterations(numIterations);
    }

    public void update(float timeInterval) {
        float interval;
        assert (Validate.nonNegative((float)timeInterval, (String)"time interval"));
        if (this.maxSubSteps == 0) {
            interval = Math.min(timeInterval, this.maxTimeStep);
        } else {
            interval = timeInterval;
            assert (this.maxSubSteps > 0) : this.maxSubSteps;
        }
        this.update(interval, this.maxSubSteps);
    }

    public void update(float timeInterval, int maxSteps) {
        boolean haveImmediate;
        assert (Validate.nonNegative((float)timeInterval, (String)"time interval"));
        assert (Validate.nonNegative((int)maxSteps, (String)"max steps"));
        boolean doEnded = haveImmediate = !this.contactListeners.isEmpty();
        boolean doProcessed = haveImmediate || !this.contactProcessedListeners.isEmpty();
        boolean doStarted = haveImmediate || !this.contactStartedListeners.isEmpty();
        this.update(timeInterval, maxSteps, doEnded, doProcessed, doStarted);
    }

    public void update(float timeInterval, int maxSteps, boolean doEnded, boolean doProcessed, boolean doStarted) {
        assert (Validate.nonNegative((float)timeInterval, (String)"time interval"));
        assert (Validate.nonNegative((int)maxSteps, (String)"max steps"));
        long spaceId = this.nativeId();
        assert (this.accuracy > 0.0f) : this.accuracy;
        PhysicsSpace.stepSimulation(spaceId, timeInterval, maxSteps, this.accuracy, doEnded, doProcessed, doStarted);
    }

    public void useScr(boolean setting) {
        long spaceId = this.nativeId();
        PhysicsSpace.setSpeculativeContactRestitution(spaceId, setting);
    }

    protected Map<Long, PhysicsJoint> getJointMap() {
        return this.jointMap;
    }

    protected static native int getWorldType(long var0);

    protected void initSolverInfo() {
        long spaceId = this.nativeId();
        long solverInfoId = PhysicsSpace.getSolverInfo(spaceId);
        this.solverInfo = new SolverInfo(solverInfoId);
    }

    protected void updateSolver() {
        long spaceId = this.nativeId();
        int ordinal = this.solverType.ordinal();
        PhysicsSpace.setSolverType(spaceId, ordinal);
    }

    @Override
    public void add(Object object) {
        Validate.nonNull((Object)object, (String)"object");
        if (object instanceof PhysicsControl) {
            ((PhysicsControl)object).setPhysicsSpace(this);
        } else if (object instanceof Spatial) {
            Spatial node = (Spatial)object;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.add(node.getControl(i));
            }
        } else if (object instanceof PhysicsJoint) {
            this.addJoint((PhysicsJoint)object);
        } else {
            super.add(object);
        }
    }

    @Override
    public void addCollisionObject(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        if (pco instanceof PhysicsRigidBody) {
            this.addRigidBody((PhysicsRigidBody)pco);
        } else if (pco instanceof PhysicsCharacter) {
            this.addCharacter((PhysicsCharacter)pco);
        } else {
            super.addCollisionObject(pco);
        }
    }

    @Override
    public boolean contains(PhysicsCollisionObject pco) {
        long pcoId = pco.nativeId();
        boolean result = pco instanceof PhysicsRigidBody ? this.rigidMap.containsKey(pcoId) : (pco instanceof PhysicsCharacter ? this.characterMap.containsKey(pcoId) : super.contains(pco));
        return result;
    }

    @Override
    protected void create() {
        int broadphase = this.getBroadphaseType().ordinal();
        Vector3f max = this.getWorldMax(null);
        Vector3f min = this.getWorldMin(null);
        int numSolvers = this.countSolvers();
        long nativeId = this.createPhysicsSpace(min, max, broadphase, numSolvers);
        assert (nativeId != 0L);
        assert (PhysicsSpace.getWorldType(nativeId) == 2) : PhysicsSpace.getWorldType(nativeId);
        this.initThread(nativeId);
        this.initSolverInfo();
        logger.log(Level.FINE, "Created {0}.", this);
    }

    @Override
    public void destroy() {
        super.destroy();
        for (PhysicsCharacter character : this.characterMap.values()) {
            this.removeCharacter(character);
        }
        for (PhysicsJoint joint : this.jointMap.values()) {
            this.removeJoint(joint);
        }
        for (PhysicsRigidBody rigidBody : this.rigidMap.values()) {
            this.removeRigidBody(rigidBody);
        }
    }

    @Override
    public Collection<PhysicsCollisionObject> getPcoList() {
        Collection<PhysicsCollisionObject> result = super.getPcoList();
        result.addAll(this.rigidMap.values());
        result.addAll(this.characterMap.values());
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty() && this.characterMap.isEmpty() && this.rigidMap.isEmpty() && this.jointMap.isEmpty();
        return result;
    }

    @Override
    public void remove(Object object) {
        if (object instanceof PhysicsControl) {
            ((PhysicsControl)object).setPhysicsSpace(null);
        } else if (object instanceof Spatial) {
            Spatial node = (Spatial)object;
            for (int i = 0; i < node.getNumControls(); ++i) {
                if (!(node.getControl(i) instanceof PhysicsControl)) continue;
                this.remove(node.getControl(i));
            }
        } else if (object instanceof PhysicsJoint) {
            this.removeJoint((PhysicsJoint)object);
        } else {
            super.remove(object);
        }
    }

    @Override
    public void removeCollisionObject(PhysicsCollisionObject pco) {
        Validate.nonNull((Object)pco, (String)"collision object");
        if (pco instanceof PhysicsRigidBody) {
            this.removeRigidBody((PhysicsRigidBody)pco);
        } else if (pco instanceof PhysicsCharacter) {
            this.removeCharacter((PhysicsCharacter)pco);
        } else {
            super.removeCollisionObject(pco);
        }
    }

    @Override
    public void onContactEnded(long manifoldId) {
        for (ContactListener listener : this.contactListeners) {
            listener.onContactEnded(manifoldId);
        }
    }

    @Override
    public void onContactProcessed(PhysicsCollisionObject pcoA, PhysicsCollisionObject pcoB, long pointId) {
        for (ContactListener listener : this.contactListeners) {
            listener.onContactProcessed(pcoA, pcoB, pointId);
        }
        PhysicsCollisionEvent event = new PhysicsCollisionEvent(pcoA, pcoB, pointId);
        this.contactProcessedEvents.add(event);
    }

    @Override
    public void onContactStarted(long manifoldId) {
        for (ContactListener listener : this.contactListeners) {
            listener.onContactStarted(manifoldId);
        }
        int numPoints = PersistentManifolds.countPoints(manifoldId);
        if (numPoints == 0) {
            return;
        }
        long bodyAId = PersistentManifolds.getBodyAId(manifoldId);
        PhysicsCollisionObject pcoA = PhysicsCollisionObject.findInstance(bodyAId);
        long bodyBId = PersistentManifolds.getBodyBId(manifoldId);
        PhysicsCollisionObject pcoB = PhysicsCollisionObject.findInstance(bodyBId);
        for (int i = 0; i < numPoints; ++i) {
            long pointId = PersistentManifolds.getPointId(manifoldId, i);
            PhysicsCollisionEvent event = new PhysicsCollisionEvent(pcoA, pcoB, pointId);
            this.contactStartedEvents.add(event);
        }
    }

    private void addCharacter(PhysicsCharacter character) {
        if (this.contains(character)) {
            logger.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{character, this});
            return;
        }
        assert (!character.isInWorld());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding {0} to {1}.", new Object[]{character, this});
        }
        long characterId = character.nativeId();
        this.characterMap.put(characterId, character);
        long spaceId = this.nativeId();
        PhysicsSpace.addCharacterObject(spaceId, characterId);
        long actionId = character.getControllerId();
        PhysicsSpace.addAction(spaceId, actionId);
    }

    private void addRigidBody(PhysicsRigidBody rigidBody) {
        boolean useStaticGroup;
        if (this.contains(rigidBody)) {
            logger.log(Level.WARNING, "{0} is already added to {1}.", new Object[]{rigidBody, this});
            return;
        }
        assert (!rigidBody.isInWorld());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Adding {0} to {1}.", new Object[]{rigidBody, this});
        }
        long rigidBodyId = rigidBody.nativeId();
        this.rigidMap.put(rigidBodyId, rigidBody);
        boolean kinematic = false;
        if (rigidBody.isKinematic()) {
            kinematic = true;
            rigidBody.setKinematic(false);
        }
        int proxyGroup = (useStaticGroup = rigidBody.isStatic()) ? 2 : 1;
        int proxyMask = useStaticGroup ? -3 : -1;
        long spaceId = this.nativeId();
        PhysicsSpace.addRigidBody(spaceId, rigidBodyId, proxyGroup, proxyMask);
        if (kinematic) {
            rigidBody.setKinematic(true);
        }
        if (rigidBody instanceof PhysicsVehicle) {
            PhysicsVehicle vehicle = (PhysicsVehicle)rigidBody;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding action for {0} to {1}.", new Object[]{vehicle, this});
            }
            vehicle.createVehicle(this);
            long actionId = vehicle.getVehicleId();
            this.vehicleMap.put(actionId, vehicle);
            PhysicsSpace.addAction(spaceId, actionId);
        }
    }

    private boolean checkGravity(Vector3f storeVector) {
        assert (storeVector != null);
        long spaceId = this.nativeId();
        PhysicsSpace.getGravity(spaceId, storeVector);
        boolean result = this.gravity.equals((Object)storeVector);
        return result;
    }

    private void postTick_native(float timeStep) {
        for (PhysicsTickListener listener : this.tickListeners) {
            listener.physicsTick(this, timeStep);
        }
    }

    private void preTick_native(float timeStep) {
        AppTask<?> task;
        while ((task = this.pQueue.poll()) != null) {
            if (task.isCancelled()) continue;
            try {
                task.invoke();
            }
            catch (RuntimeException exception) {
                logger.log(Level.SEVERE, null, exception);
            }
        }
        for (PhysicsTickListener listener : this.tickListeners) {
            listener.prePhysicsTick(this, timeStep);
        }
    }

    private void removeCharacter(PhysicsCharacter character) {
        long characterId = character.nativeId();
        if (!this.characterMap.containsKey(characterId)) {
            logger.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{character, this});
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Removing {0} from {1}.", new Object[]{character, this});
        }
        this.characterMap.remove(characterId);
        long spaceId = this.nativeId();
        long actionId = character.getControllerId();
        PhysicsSpace.removeAction(spaceId, actionId);
        PhysicsSpace.removeCharacterObject(spaceId, characterId);
    }

    private void removeRigidBody(PhysicsRigidBody rigidBody) {
        long rigidBodyId = rigidBody.nativeId();
        if (!this.rigidMap.containsKey(rigidBodyId)) {
            logger.log(Level.WARNING, "{0} does not exist in {1}.", new Object[]{rigidBody, this});
            return;
        }
        long spaceId = this.nativeId();
        if (rigidBody instanceof PhysicsVehicle) {
            PhysicsVehicle vehicle = (PhysicsVehicle)rigidBody;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing action for {0} from {1}.", new Object[]{vehicle, this});
            }
            long actionId = vehicle.getVehicleId();
            this.vehicleMap.remove(actionId);
            PhysicsSpace.removeAction(spaceId, actionId);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Removing {0} from {1}.", new Object[]{rigidBody, this});
        }
        this.rigidMap.remove(rigidBodyId);
        PhysicsSpace.removeRigidBody(spaceId, rigidBodyId);
    }

    private static native void addAction(long var0, long var2);

    private static native void addCharacterObject(long var0, long var2);

    private static native void addConstraintC(long var0, long var2, boolean var4);

    private static native void addRigidBody(long var0, long var2, int var4, int var5);

    private static native int countManifolds(long var0);

    private native long createPhysicsSpace(Vector3f var1, Vector3f var2, int var3, int var4);

    private static native void getGravity(long var0, Vector3f var2);

    private static native long getManifoldByIndex(long var0, int var2);

    private static native int getNumConstraints(long var0);

    private static native long getSolverInfo(long var0);

    private static native boolean isSpeculativeContactRestitution(long var0);

    private static native void removeAction(long var0, long var2);

    private static native void removeCharacterObject(long var0, long var2);

    private static native void removeConstraint(long var0, long var2);

    private static native void removeRigidBody(long var0, long var2);

    private static native void setGravity(long var0, Vector3f var2);

    private static native void setSolverType(long var0, int var2);

    private static native void setSpeculativeContactRestitution(long var0, boolean var2);

    private static native void stepSimulation(long var0, float var2, int var3, float var4, boolean var5, boolean var6, boolean var7);

    public static enum BroadphaseType {
        SIMPLE,
        AXIS_SWEEP_3,
        AXIS_SWEEP_3_32,
        DBVT;

    }
}

