/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet;

import com.jme3.bullet.NativePhysicsObject;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class SolverInfo
extends NativePhysicsObject {
    public static final Logger logger = Logger.getLogger(SolverInfo.class.getName());

    SolverInfo(long nativeId) {
        Validate.nonZero((long)nativeId, (String)"native ID");
        super.setNativeIdNotTracked(nativeId);
    }

    public float contactErp() {
        long infoId = this.nativeId();
        float result = SolverInfo.getContactErp(infoId);
        return result;
    }

    public void copyAll(SolverInfo source) {
        long thisId = this.nativeId();
        long sourceId = source.nativeId();
        SolverInfo.copyAllParameters(thisId, sourceId);
    }

    public float globalCfm() {
        long infoId = this.nativeId();
        float result = SolverInfo.getGlobalCfm(infoId);
        return result;
    }

    public boolean isSplitImpulseEnabled() {
        long infoId = this.nativeId();
        boolean result = SolverInfo.isSplitImpulseEnabled(infoId);
        return result;
    }

    public float jointErp() {
        long infoId = this.nativeId();
        float result = SolverInfo.getJointErp(infoId);
        return result;
    }

    public int minBatch() {
        long infoId = this.nativeId();
        int result = SolverInfo.getMinBatch(infoId);
        return result;
    }

    public int mode() {
        long infoId = this.nativeId();
        int result = SolverInfo.getMode(infoId);
        return result;
    }

    public int numIterations() {
        long infoId = this.nativeId();
        int result = SolverInfo.getNumIterations(infoId);
        return result;
    }

    public void setContactErp(float erp) {
        long infoId = this.nativeId();
        SolverInfo.setContactErp(infoId, erp);
    }

    public void setGlobalCfm(float cfm) {
        Validate.nonNegative((float)cfm, (String)"mixing parameter");
        long infoId = this.nativeId();
        SolverInfo.setGlobalCfm(infoId, cfm);
    }

    public void setJointErp(float erp) {
        long infoId = this.nativeId();
        SolverInfo.setJointErp(infoId, erp);
    }

    public void setMinBatch(int numConstraints) {
        Validate.positive((int)numConstraints, (String)"number of constraints");
        long infoId = this.nativeId();
        SolverInfo.setMinBatch(infoId, numConstraints);
    }

    public void setMode(int flags) {
        long infoId = this.nativeId();
        SolverInfo.setMode(infoId, flags);
    }

    public void setNumIterations(int numIterations) {
        Validate.positive((int)numIterations, (String)"number of iterations");
        long infoId = this.nativeId();
        SolverInfo.setNumIterations(infoId, numIterations);
    }

    public void setSplitImpulseEnabled(boolean setting) {
        long infoId = this.nativeId();
        SolverInfo.setSplitImpulseEnabled(infoId, setting);
    }

    public void setSplitImpulseErp(float erp) {
        long infoId = this.nativeId();
        SolverInfo.setSplitImpulseErp(infoId, erp);
    }

    public void setSplitImpulseThreshold(float penetration) {
        long infoId = this.nativeId();
        SolverInfo.setSplitImpulseThreshold(infoId, penetration);
    }

    public float splitImpulseErp() {
        long infoId = this.nativeId();
        float result = SolverInfo.getSplitImpulseErp(infoId);
        return result;
    }

    public float splitImpulseThreshold() {
        long infoId = this.nativeId();
        float result = SolverInfo.getSplitImpulseThreshold(infoId);
        return result;
    }

    private static native void copyAllParameters(long var0, long var2);

    private static native float getContactErp(long var0);

    private static native float getGlobalCfm(long var0);

    private static native float getJointErp(long var0);

    private static native int getMinBatch(long var0);

    private static native int getMode(long var0);

    private static native int getNumIterations(long var0);

    private static native float getSplitImpulseErp(long var0);

    private static native float getSplitImpulseThreshold(long var0);

    private static native boolean isSplitImpulseEnabled(long var0);

    private static native void setContactErp(long var0, float var2);

    private static native void setGlobalCfm(long var0, float var2);

    private static native void setJointErp(long var0, float var2);

    private static native void setMinBatch(long var0, int var2);

    private static native void setMode(long var0, int var2);

    private static native void setNumIterations(long var0, int var2);

    private static native void setSplitImpulseEnabled(long var0, boolean var2);

    private static native void setSplitImpulseErp(long var0, float var2);

    private static native void setSplitImpulseThreshold(long var0, float var2);
}

