/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.bullet.util.DebugShapeFactory;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.MySkeleton;
import jme3utilities.Validate;
import jme3utilities.math.MyMath;

public class BoneLink
extends PhysicsLink {
    public static final Logger logger2 = Logger.getLogger(BoneLink.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private static final String tagManagedArmatureJoints = "managedArmatureJoints";
    private static final String tagManagedBones = "managedBones";
    private static final String tagPrevBoneTransforms = "prevBoneTransforms";
    private static final String tagStartBoneTransforms = "startBoneTransforms";
    private static final String tagSubmode = "submode";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Bone[] managedBones = null;
    private Joint[] managedArmatureJoints = null;
    private KinematicSubmode submode = KinematicSubmode.Animated;
    private final Matrix3f tmpMatrix = new Matrix3f();
    private Transform[] prevBoneTransforms = null;
    private Transform[] startBoneTransforms = null;

    protected BoneLink() {
    }

    BoneLink(DacLinks control, Bone bone, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        super(control, bone, collisionShape, linkConfig, localOffset);
    }

    BoneLink(DacLinks control, Joint joint, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        super(control, joint, collisionShape, linkConfig, localOffset);
    }

    void addJoint(PhysicsLink parentLink) {
        int numManaged;
        Vector3f pivotMesh;
        assert (parentLink != null);
        assert (this.getJoint() == null);
        this.setParent(parentLink);
        Transform parentToWorld = parentLink.physicsTransform(null);
        parentToWorld.setScale(1.0f);
        Transform worldToParent = parentToWorld.invert();
        Transform childToWorld = this.physicsTransform(null);
        childToWorld.setScale(1.0f);
        Transform childToParent = childToWorld.clone();
        childToParent.combineWithParent(worldToParent);
        Spatial transformer = this.getControl().getTransformer();
        Bone bone = this.getBone();
        if (bone != null) {
            pivotMesh = bone.getModelSpacePosition();
        } else {
            Joint armatureJoint = this.getArmatureJoint();
            pivotMesh = armatureJoint.getModelTransform().getTranslation();
        }
        Vector3f pivotWorld = transformer.localToWorld(pivotMesh, null);
        PhysicsRigidBody parentBody = parentLink.getRigidBody();
        PhysicsRigidBody childBody = this.getRigidBody();
        Vector3f pivotParent = parentToWorld.transformInverseVector(pivotWorld, null);
        Vector3f pivotChild = childToWorld.transformInverseVector(pivotWorld, null);
        childToParent.getRotation().toRotationMatrix(this.tmpMatrix);
        Matrix3f rotParent = this.tmpMatrix;
        Matrix3f rotChild = matrixIdentity;
        String name = this.boneName();
        RotationOrder rotationOrder = this.getControl().config(name).rotationOrder();
        Constraint constraint = rotationOrder == null ? new SixDofJoint(parentBody, childBody, pivotParent, pivotChild, rotParent, rotChild, true) : new New6Dof(parentBody, childBody, pivotParent, pivotChild, rotParent, rotChild, rotationOrder);
        super.setJoint(constraint);
        RangeOfMotion rangeOfMotion = this.getControl().getJointLimits(name);
        rangeOfMotion.setup(constraint, false, false, false);
        assert (this.managedBones == null);
        assert (this.managedArmatureJoints == null);
        if (bone != null) {
            this.managedBones = this.getControl().listManagedBones(name);
            numManaged = this.managedBones.length;
        } else {
            this.managedArmatureJoints = this.getControl().listManagedArmatureJoints(name);
            numManaged = this.managedArmatureJoints.length;
        }
        this.startBoneTransforms = new Transform[numManaged];
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            this.startBoneTransforms[managedIndex] = new Transform();
        }
    }

    public void blendToKinematicMode(KinematicSubmode submode, float blendInterval) {
        Validate.nonNull((Object)((Object)submode), (String)tagSubmode);
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        super.blendToKinematicMode(blendInterval);
        this.submode = submode;
        int numManaged = this.countManaged();
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform transform = this.prevBoneTransforms == null ? this.copyManagedTransform(managedIndex, null) : this.prevBoneTransforms[managedIndex];
            this.startBoneTransforms[managedIndex].set(transform);
        }
        if (submode == KinematicSubmode.Animated) {
            this.setUserControl(false);
        } else {
            this.setUserControl(true);
        }
    }

    public int boneIndex(int managedIndex) {
        int result;
        int numManaged = this.countManaged();
        Validate.inRange((int)managedIndex, (String)"managed index", (int)0, (int)(numManaged - 1));
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            Skeleton skeleton = this.getControl().getSkeleton();
            result = skeleton.getBoneIndex(managed);
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            result = managed.getId();
        }
        assert (result >= 0) : result;
        return result;
    }

    public int countManaged() {
        int result = this.managedBones != null ? this.managedBones.length : this.managedArmatureJoints.length;
        assert (result >= 1) : result;
        return result;
    }

    public Vector3f[] footprint() {
        CollisionShape shape = this.getRigidBody().getCollisionShape();
        assert (shape.isConvex());
        Transform localToWorld = this.physicsTransform(null);
        localToWorld.setScale(1.0f);
        Vector3f[] result = DebugShapeFactory.footprint(shape, localToWorld, 0);
        return result;
    }

    void postRebuild(BoneLink oldLink) {
        int numManaged = this.countManaged();
        assert (oldLink.countManaged() == numManaged);
        super.postRebuild(oldLink);
        this.submode = oldLink.isKinematic() ? oldLink.submode : KinematicSubmode.Frozen;
        if (this.prevBoneTransforms == null) {
            this.prevBoneTransforms = new Transform[numManaged];
            for (int managedI = 0; managedI < numManaged; ++managedI) {
                this.prevBoneTransforms[managedI] = new Transform();
            }
        }
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform transform = oldLink.prevBoneTransforms[managedIndex];
            this.prevBoneTransforms[managedIndex].set(transform);
            transform = oldLink.startBoneTransforms[managedIndex];
            this.startBoneTransforms[managedIndex].set(transform);
        }
    }

    public void setDynamic(Vector3f uniformAcceleration, boolean lockX, boolean lockY, boolean lockZ) {
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        String desiredAction = "put " + this.name() + " into dynamic mode";
        this.getControl().verifyReadyForDynamicMode(desiredAction);
        super.setDynamic(uniformAcceleration);
        String name = this.boneName();
        RangeOfMotion preset = this.getControl().getJointLimits(name);
        preset.setup(this.getJoint(), lockX, lockY, lockZ);
        this.setUserControl(true);
    }

    public void setDynamic(Vector3f uniformAcceleration, Quaternion userRotation) {
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        String desiredAction = "put " + this.name() + " into dynamic mode";
        this.getControl().verifyReadyForDynamicMode(desiredAction);
        super.setDynamic(uniformAcceleration);
        PhysicsJoint joint = this.getJoint();
        RotationOrder rotOrder = joint instanceof SixDofJoint ? RotationOrder.XYZ : ((New6Dof)joint).getRotationOrder();
        userRotation.toRotationMatrix(this.tmpMatrix);
        Vector3f eulerAngles = rotOrder.matrixToEuler(this.tmpMatrix, null);
        RangeOfMotion rom = new RangeOfMotion(eulerAngles);
        rom.setup(joint, false, false, false);
        this.setUserControl(true);
    }

    public void setLocalTransform(int mbIndex, Transform localTransform) {
        int numManaged = this.countManaged();
        Validate.inRange((int)mbIndex, (String)"index", (int)1, (int)(numManaged - 1));
        if (this.prevBoneTransforms != null) {
            this.prevBoneTransforms[mbIndex].set(localTransform);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.managedBones = (Bone[])cloner.clone((Object)this.managedBones);
        this.managedArmatureJoints = (Joint[])cloner.clone((Object)this.managedArmatureJoints);
        this.prevBoneTransforms = (Transform[])cloner.clone((Object)this.prevBoneTransforms);
        this.startBoneTransforms = (Transform[])cloner.clone((Object)this.startBoneTransforms);
    }

    @Override
    protected void dynamicUpdate() {
        assert (!this.getRigidBody().isKinematic());
        int numManaged = this.countManaged();
        for (int managedIndex = 1; managedIndex < numManaged; ++managedIndex) {
            Transform t = this.prevBoneTransforms[managedIndex];
            this.setManagedTransform(managedIndex, t);
        }
        Transform transform = this.localBoneTransform(null);
        if (this.managedBones != null) {
            MySkeleton.setLocalTransform((Bone)this.getBone(), (Transform)transform);
            for (Bone bone : this.managedBones) {
                bone.updateModelTransforms();
            }
        } else {
            this.getArmatureJoint().setLocalTransform(transform);
            for (Bone bone : this.managedArmatureJoints) {
                bone.updateModelTransforms();
            }
        }
    }

    @Override
    public void freeze(boolean forceKinematic) {
        if (forceKinematic || this.isKinematic()) {
            this.blendToKinematicMode(KinematicSubmode.Frozen, 0.0f);
        } else {
            this.setDynamic(translateIdentity, true, true, true);
        }
    }

    @Override
    public BoneLink jmeClone() {
        try {
            BoneLink clone = (BoneLink)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.getRigidBody().isKinematic());
        Transform transform = new Transform();
        int numManaged = this.countManaged();
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            switch (this.submode) {
                case Amputated: {
                    int boneIndex = this.boneIndex(managedIndex);
                    this.getControl().copyBindTransform(boneIndex, transform);
                    transform.setScale(0.001f);
                    break;
                }
                case Animated: {
                    this.copyManagedTransform(managedIndex, transform);
                    break;
                }
                case Bound: {
                    int boneIndex = this.boneIndex(managedIndex);
                    this.getControl().copyBindTransform(boneIndex, transform);
                    break;
                }
                case Frozen: {
                    transform.set(this.prevBoneTransforms[managedIndex]);
                    break;
                }
                default: {
                    throw new IllegalStateException(this.submode.toString());
                }
            }
            if (this.kinematicWeight() < 1.0f) {
                Quaternion endQuat;
                Transform start = this.startBoneTransforms[managedIndex];
                Quaternion startQuat = start.getRotation();
                if (startQuat.dot(endQuat = transform.getRotation()) < 0.0f) {
                    endQuat.multLocal(-1.0f);
                }
                MyMath.slerp((float)this.kinematicWeight(), (Transform)this.startBoneTransforms[managedIndex], (Transform)transform, (Transform)transform);
            }
            this.setManagedTransform(managedIndex, transform);
        }
        super.kinematicUpdate(tpf);
    }

    @Override
    public String name() {
        String result = "Bone:" + this.boneName();
        return result;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        int managedI;
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        Savable[] tmp = capsule.readSavableArray(tagManagedArmatureJoints, null);
        if (tmp == null) {
            this.managedArmatureJoints = null;
        } else {
            this.managedArmatureJoints = new Joint[tmp.length];
            for (managedI = 0; managedI < tmp.length; ++managedI) {
                this.managedArmatureJoints[managedI] = (Joint)tmp[managedI];
            }
        }
        tmp = capsule.readSavableArray(tagManagedBones, null);
        if (tmp == null) {
            this.managedBones = null;
        } else {
            this.managedBones = new Bone[tmp.length];
            for (managedI = 0; managedI < tmp.length; ++managedI) {
                this.managedBones[managedI] = (Bone)tmp[managedI];
            }
        }
        this.submode = (KinematicSubmode)capsule.readEnum(tagSubmode, KinematicSubmode.class, (Enum)KinematicSubmode.Animated);
        this.prevBoneTransforms = RagUtils.readTransformArray(capsule, tagPrevBoneTransforms);
        this.startBoneTransforms = RagUtils.readTransformArray(capsule, tagStartBoneTransforms);
    }

    @Override
    public void setDynamic(Vector3f uniformAcceleration) {
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        super.setDynamic(uniformAcceleration);
        this.setUserControl(true);
    }

    @Override
    public void setRagdollMode() {
        this.getControl().verifyReadyForDynamicMode("put link into ragdoll mode");
        Vector3f gravity = this.getControl().gravity(null);
        this.setDynamic(gravity, false, false, false);
        super.setRagdollMode();
    }

    @Override
    void update(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        int numManaged = this.countManaged();
        if (this.prevBoneTransforms == null) {
            this.prevBoneTransforms = new Transform[numManaged];
            for (int managedI = 0; managedI < numManaged; ++managedI) {
                Transform boneTransform;
                this.prevBoneTransforms[managedI] = boneTransform = this.copyManagedTransform(managedI, null);
            }
        }
        super.update(tpf);
        for (int managedIndex = 0; managedIndex < numManaged; ++managedIndex) {
            Transform lastTransform = this.prevBoneTransforms[managedIndex];
            this.copyManagedTransform(managedIndex, lastTransform);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write((Savable[])this.managedArmatureJoints, tagManagedArmatureJoints, null);
        capsule.write((Savable[])this.managedBones, tagManagedBones, null);
        capsule.write((Enum)this.submode, tagSubmode, (Enum)KinematicSubmode.Animated);
        capsule.write((Savable[])this.prevBoneTransforms, tagPrevBoneTransforms, (Savable[])new Transform[0]);
        capsule.write((Savable[])this.startBoneTransforms, tagStartBoneTransforms, (Savable[])new Transform[0]);
    }

    private Transform copyManagedTransform(int managedIndex, Transform storeResult) {
        Transform result;
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            MySkeleton.copyLocalTransform((Bone)managed, (Transform)result);
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            Transform local = managed.getLocalTransform();
            result.set(local);
        }
        return result;
    }

    private Transform localBoneTransform(Transform storeResult) {
        Bone parent;
        Transform result = storeResult == null ? new Transform() : storeResult;
        Vector3f location = result.getTranslation();
        Quaternion orientation = result.getRotation();
        Vector3f scale = result.getScale();
        this.getRigidBody().getTransform(result);
        Transform worldToMesh = this.getControl().meshTransform(null).invert();
        result.combineWithParent(worldToMesh);
        if (this.managedBones != null) {
            parent = this.getBone().getParent();
            RagUtils.meshToLocal(parent, result);
        } else {
            parent = this.getArmatureJoint().getParent();
            RagUtils.meshToLocal((Joint)parent, result);
        }
        Vector3f parentOffset = this.localOffset(null);
        parentOffset.multLocal(scale);
        orientation.mult(parentOffset, parentOffset);
        location.subtractLocal(parentOffset);
        return result;
    }

    private void setManagedTransform(int managedIndex, Transform transform) {
        if (this.managedBones != null) {
            Bone managed = this.managedBones[managedIndex];
            MySkeleton.setLocalTransform((Bone)managed, (Transform)transform);
            managed.updateModelTransforms();
        } else {
            Joint managed = this.managedArmatureJoints[managedIndex];
            managed.setLocalTransform(transform);
            managed.updateModelTransforms();
        }
    }

    private void setUserControl(boolean wantUserControl) {
        if (this.managedBones != null) {
            for (Bone managed : this.managedBones) {
                managed.setUserControl(wantUserControl);
            }
        }
    }
}

