/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.PhysicsTickListener;
import com.jme3.bullet.animation.AttachmentLink;
import com.jme3.bullet.animation.BoneLink;
import com.jme3.bullet.animation.CenterHeuristic;
import com.jme3.bullet.animation.DacConfiguration;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.PreComposer;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RangeOfMotion;
import com.jme3.bullet.animation.TorsoLink;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.Heart;
import jme3utilities.MyControl;
import jme3utilities.MyMesh;
import jme3utilities.MySkeleton;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.VectorSet;

public class DacLinks
extends DacConfiguration
implements PhysicsTickListener {
    public static final Logger logger3 = Logger.getLogger(DacLinks.class.getName());
    private static final Quaternion rotateIdentity = new Quaternion();
    private static final String tagArmature = "armature";
    private static final String tagAttachmentLinks = "attachmentLinks";
    private static final String tagBoneLinkList = "boneLinkList";
    private static final String tagSkeleton = "skeleton";
    private static final String tagTorsoLink = "torsoLink";
    private static final String tagTransformer = "transformer";
    private static final Transform transformIdentity = new Transform();
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private Armature armature = null;
    private boolean isReady = false;
    private List<BoneLink> boneLinkList = null;
    private Map<String, AttachmentLink> attachmentLinks = new HashMap<String, AttachmentLink>(8);
    private Map<String, BoneLink> boneLinks = new HashMap<String, BoneLink>(32);
    private PreComposer preComposer = null;
    private Skeleton skeleton = null;
    private Spatial transformer = null;
    private Transform[] bindTransforms = null;
    private TorsoLink torsoLink = null;

    protected DacLinks() {
    }

    Transform copyBindTransform(int jointIndex, Transform storeResult) {
        Transform alias = this.bindTransforms[jointIndex];
        if (storeResult == null) {
            return alias.clone();
        }
        return storeResult.set(alias);
    }

    public Joint findArmatureJoint(String jointName) {
        this.verifyAddedToSpatial("access an armature joint");
        Joint result = this.armature.getJoint(jointName);
        return result;
    }

    public AttachmentLink findAttachmentLink(String boneName) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        AttachmentLink link = this.attachmentLinks.get(boneName);
        return link;
    }

    public Bone findBone(String boneName) {
        this.verifyAddedToSpatial("access a bone");
        Bone result = this.skeleton.getBone(boneName);
        return result;
    }

    public BoneLink findBoneLink(String boneName) {
        Validate.nonEmpty((String)boneName, (String)"bone name");
        BoneLink boneLink = this.boneLinks.get(boneName);
        return boneLink;
    }

    public PhysicsLink findLink(String linkName) {
        PhysicsLink link;
        Validate.nonEmpty((String)linkName, (String)"link name");
        if (linkName.startsWith("Bone:")) {
            String boneName = MyString.remainder((String)linkName, (String)"Bone:");
            link = this.findBoneLink(boneName);
        } else if (linkName.equals("Torso:")) {
            link = this.torsoLink;
        } else {
            String boneName = MyString.remainder((String)linkName, (String)"Attachment:");
            link = this.findAttachmentLink(boneName);
        }
        return link;
    }

    public Armature getArmature() {
        return this.armature;
    }

    public Skeleton getSkeleton() {
        return this.skeleton;
    }

    public TorsoLink getTorsoLink() {
        return this.torsoLink;
    }

    Spatial getTransformer() {
        return this.transformer;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public <T extends PhysicsLink> List<T> listLinks(Class<T> linkType) {
        int numLinks = this.countLinks();
        ArrayList<PhysicsLink> result = new ArrayList<PhysicsLink>(numLinks);
        if (this.torsoLink != null && linkType.isAssignableFrom(this.torsoLink.getClass())) {
            result.add(this.torsoLink);
        }
        for (BoneLink boneLink : this.boneLinkList) {
            if (!linkType.isAssignableFrom(boneLink.getClass())) continue;
            result.add(boneLink);
        }
        for (AttachmentLink attachmentLink : this.attachmentLinks.values()) {
            if (!linkType.isAssignableFrom(attachmentLink.getClass())) continue;
            result.add(attachmentLink);
        }
        return result;
    }

    Joint[] listManagedArmatureJoints(String managerName) {
        ArrayList<Joint> list = new ArrayList<Joint>(8);
        if ("".equals(managerName)) {
            Joint[] roots;
            for (Joint rootJoint : roots = this.armature.getRoots()) {
                list.add(rootJoint);
                this.addUnlinkedDescendants(rootJoint, list);
            }
        } else {
            BoneLink manager = this.findBoneLink(managerName);
            if (manager == null) {
                String message = "No link named " + MyString.quote((CharSequence)managerName);
                throw new IllegalArgumentException(message);
            }
            Joint managerJoint = manager.getArmatureJoint();
            list.add(managerJoint);
            this.addUnlinkedDescendants(managerJoint, list);
        }
        int numManagedJoints = list.size();
        Joint[] array = new Joint[numManagedJoints];
        list.toArray(array);
        return array;
    }

    Bone[] listManagedBones(String managerName) {
        ArrayList<Bone> list = new ArrayList<Bone>(8);
        if ("".equals(managerName)) {
            Bone[] roots;
            for (Bone rootBone : roots = this.skeleton.getRoots()) {
                list.add(rootBone);
                this.addUnlinkedDescendants(rootBone, list);
            }
        } else {
            BoneLink manager = this.findBoneLink(managerName);
            if (manager == null) {
                String msg = "No link named " + MyString.quote((CharSequence)managerName);
                throw new IllegalArgumentException(msg);
            }
            Bone managerBone = manager.getBone();
            list.add(managerBone);
            this.addUnlinkedDescendants(managerBone, list);
        }
        int numManaged = list.size();
        Bone[] array = new Bone[numManaged];
        list.toArray(array);
        return array;
    }

    public PhysicsRigidBody[] listRigidBodies() {
        this.verifyAddedToSpatial("enumerate rigid bodies");
        int numLinks = this.countLinks();
        PhysicsRigidBody[] result = new PhysicsRigidBody[numLinks];
        int linkIndex = 0;
        if (this.torsoLink != null) {
            result[0] = this.torsoLink.getRigidBody();
            ++linkIndex;
        }
        for (BoneLink boneLink : this.boneLinkList) {
            result[linkIndex] = boneLink.getRigidBody();
            ++linkIndex;
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            result[linkIndex] = link.getRigidBody();
            ++linkIndex;
        }
        assert (linkIndex == numLinks);
        return result;
    }

    Transform meshTransform(Transform storeResult) {
        Transform result = MySpatial.worldTransform((Spatial)this.transformer, (Transform)storeResult);
        return result;
    }

    Transform physicsTransform(Bone bone, Vector3f localOffset, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.setTranslation(localOffset);
        result.setRotation(rotateIdentity);
        result.setScale(1.0f);
        Transform localToMesh = MySkeleton.copyMeshTransform((Bone)bone, null);
        result.combineWithParent(localToMesh);
        Transform meshToWorld = this.meshTransform(null);
        result.combineWithParent(meshToWorld);
        return result;
    }

    Transform physicsTransform(Joint joint, Vector3f localOffset, Transform storeResult) {
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.setTranslation(localOffset);
        result.setRotation(rotateIdentity);
        result.setScale(1.0f);
        Transform localToMesh = joint.getModelTransform();
        result.combineWithParent(localToMesh);
        Transform meshToWorld = this.meshTransform(null);
        result.combineWithParent(meshToWorld);
        return result;
    }

    public void rebuild() {
        PhysicsLink oldLink;
        PhysicsLink newLink;
        String name;
        this.verifyAddedToSpatial("rebuild the ragdoll");
        HashMap<String, AttachmentLink> saveAttach = new HashMap<String, AttachmentLink>(this.attachmentLinks);
        HashMap<String, BoneLink> saveBones = new HashMap<String, BoneLink>(this.boneLinks);
        TorsoLink saveTorso = this.torsoLink;
        Spatial controlledSpatial = this.getSpatial();
        this.removeSpatialData(controlledSpatial);
        this.createSpatialData(controlledSpatial);
        for (Map.Entry<String, AttachmentLink> entry : this.attachmentLinks.entrySet()) {
            name = entry.getKey();
            newLink = entry.getValue();
            oldLink = (AttachmentLink)saveAttach.get(name);
            ((AttachmentLink)newLink).postRebuild((AttachmentLink)oldLink);
        }
        for (Map.Entry<String, PhysicsLink> entry : this.boneLinks.entrySet()) {
            name = entry.getKey();
            newLink = (BoneLink)entry.getValue();
            oldLink = (BoneLink)saveBones.get(name);
            ((BoneLink)newLink).postRebuild((BoneLink)oldLink);
        }
        if (this.torsoLink != null) {
            this.torsoLink.postRebuild(saveTorso);
        }
    }

    public void setMass(PhysicsLink link, float mass) {
        Validate.nonNull((Object)link, (String)"link");
        Validate.positive((float)mass, (String)"mass");
        if (link instanceof BoneLink) {
            String boneName = link.boneName();
            this.setMass(boneName, mass);
        } else if (link instanceof TorsoLink) {
            this.setMass("", mass);
        } else {
            assert (link instanceof AttachmentLink);
            String boneName = link.boneName();
            this.setAttachmentMass(boneName, mass);
        }
    }

    public void verifyReadyForDynamicMode(String desiredAction) {
        assert (desiredAction != null);
        this.verifyAddedToSpatial(desiredAction);
        if (!this.added) {
            String message = "Cannot " + desiredAction + " unless the control is added to a PhysicsSpace.";
            throw new IllegalStateException(message);
        }
        if (!this.isReady) {
            String message = "Cannot " + desiredAction + " until the physics has been stepped.";
            throw new IllegalStateException(message);
        }
    }

    protected List<BoneLink> getBoneLinks() {
        assert (this.boneLinkList != null);
        return this.boneLinkList;
    }

    protected Collection<AttachmentLink> listAttachmentLinks() {
        Collection<AttachmentLink> result = this.attachmentLinks.values();
        return result;
    }

    protected void verifyAddedToSpatial(String desiredAction) {
        assert (desiredAction != null);
        Spatial controlledSpatial = this.getSpatial();
        if (controlledSpatial == null) {
            String message = "Cannot " + desiredAction + " unless the Control is added to a Spatial.";
            throw new IllegalStateException(message);
        }
    }

    @Override
    protected void addPhysics() {
        PhysicsJoint joint;
        PhysicsRigidBody rigidBody;
        PhysicsSpace space = this.getPhysicsSpace();
        Vector3f gravity = this.gravity(null);
        if (this.torsoLink != null) {
            rigidBody = this.torsoLink.getRigidBody();
            space.addCollisionObject(rigidBody);
            rigidBody.setGravity(gravity);
        }
        for (BoneLink boneLink : this.boneLinkList) {
            rigidBody = boneLink.getRigidBody();
            space.addCollisionObject(rigidBody);
            rigidBody.setGravity(gravity);
            joint = boneLink.getJoint();
            space.addJoint(joint);
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            rigidBody = link.getRigidBody();
            space.addCollisionObject(rigidBody);
            rigidBody.setGravity(gravity);
            joint = link.getJoint();
            space.addJoint(joint);
        }
    }

    @Override
    public float attachmentMass(String boneName) {
        float mass;
        Validate.nonNull((Object)boneName, (String)"bone name");
        if (this.getSpatial() == null) {
            mass = super.attachmentMass(boneName);
        } else if (this.attachmentLinks.containsKey(boneName)) {
            AttachmentLink link = this.attachmentLinks.get(boneName);
            PhysicsRigidBody rigidBody = link.getRigidBody();
            mass = rigidBody.getMass();
        } else {
            String msg = "No attachment for " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        return mass;
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        PhysicsLink copyLink;
        PhysicsLink link;
        String boneName;
        super.cloneFields(cloner, original);
        DacLinks originalDac = (DacLinks)original;
        this.boneLinkList = (List)cloner.clone(this.boneLinkList);
        this.attachmentLinks = new HashMap<String, AttachmentLink>(8);
        for (Map.Entry<String, AttachmentLink> entry : originalDac.attachmentLinks.entrySet()) {
            boneName = entry.getKey();
            link = entry.getValue();
            copyLink = (AttachmentLink)cloner.clone((Object)link);
            this.attachmentLinks.put(boneName, (AttachmentLink)copyLink);
        }
        this.boneLinks = new HashMap<String, BoneLink>(32);
        for (Map.Entry<String, PhysicsLink> entry : originalDac.boneLinks.entrySet()) {
            boneName = entry.getKey();
            link = (BoneLink)entry.getValue();
            copyLink = (BoneLink)cloner.clone((Object)link);
            this.boneLinks.put(boneName, (BoneLink)copyLink);
        }
        this.armature = (Armature)cloner.clone((Object)this.armature);
        this.skeleton = (Skeleton)cloner.clone((Object)this.skeleton);
        this.transformer = (Spatial)cloner.clone((Object)this.transformer);
        this.torsoLink = (TorsoLink)cloner.clone((Object)this.torsoLink);
    }

    @Override
    protected void createSpatialData(Spatial spatial) {
        String[] attachBoneNames;
        String[] linkedBoneNames;
        Transform[] savedTransforms;
        String[] tempManagerMap;
        RagUtils.validate(spatial);
        int numDacs = MySpatial.countControls((Spatial)spatial, DacLinks.class);
        if (numDacs > 1) {
            logger3.log(Level.WARNING, "Added a DynamicAnimControl to a model that already contains {0}.", numDacs - 1);
        }
        SkinningControl skinningControl = (SkinningControl)spatial.getControl(SkinningControl.class);
        SkeletonControl skeletonControl = null;
        if (skinningControl == null) {
            Bone bone;
            skeletonControl = (SkeletonControl)spatial.getControl(SkeletonControl.class);
            if (skeletonControl == null) {
                throw new IllegalArgumentException("The controlled spatial must have a SkinningControl or a SkeletonControl. Make sure the Control is there and not on some other Spatial.");
            }
            this.sortControls((Control)skeletonControl);
            skeletonControl.setHardwareSkinningPreferred(false);
            this.skeleton = skeletonControl.getSkeleton();
            this.validateSkeleton();
            tempManagerMap = this.managerMap(this.skeleton);
            int numBones = this.skeleton.getBoneCount();
            MySkeleton.setUserControl((Skeleton)this.skeleton, (boolean)true);
            savedTransforms = new Transform[numBones];
            Vector3f userScale = new Vector3f();
            for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
                bone = this.skeleton.getBone(boneIndex);
                savedTransforms[boneIndex] = MySkeleton.copyLocalTransform((Bone)bone, null);
                userScale.set(bone.getLocalScale());
                userScale.divideLocal(bone.getBindScale());
                bone.setUserTransforms(translateIdentity, rotateIdentity, userScale);
            }
            MySkeleton.setUserControl((Skeleton)this.skeleton, (boolean)false);
            this.skeleton.updateWorldVectors();
            this.bindTransforms = new Transform[numBones];
            for (int jointIndex = 0; jointIndex < numBones; ++jointIndex) {
                bone = this.skeleton.getBone(jointIndex);
                this.bindTransforms[jointIndex] = MySkeleton.copyBindTransform((Bone)bone, null);
            }
        } else {
            Joint armatureJoint;
            int jointI;
            this.sortControls((Control)skinningControl);
            skinningControl.setHardwareSkinningPreferred(false);
            this.armature = skinningControl.getArmature();
            this.validateArmature();
            tempManagerMap = this.managerMap(this.armature);
            int numArmatureJoints = this.armature.getJointCount();
            savedTransforms = new Transform[numArmatureJoints];
            for (jointI = 0; jointI < numArmatureJoints; ++jointI) {
                armatureJoint = this.armature.getJoint(jointI);
                savedTransforms[jointI] = armatureJoint.getLocalTransform().clone();
                armatureJoint.applyBindPose();
            }
            this.armature.update();
            this.bindTransforms = new Transform[numArmatureJoints];
            for (jointI = 0; jointI < numArmatureJoints; ++jointI) {
                armatureJoint = this.armature.getJoint(jointI);
                this.bindTransforms[jointI] = armatureJoint.getLocalTransform().clone();
            }
            AnimComposer composer = (AnimComposer)spatial.getControl(AnimComposer.class);
            if (composer == null) {
                logger3.log(Level.WARNING, "Didn't find an AnimComposer.");
            } else {
                int composerIndex = MyControl.findIndex((Control)composer, (Spatial)spatial);
                this.preComposer = new PreComposer(this);
                RagUtils.insertAt(spatial, composerIndex, (Control)this.preComposer);
            }
        }
        List<Mesh> targetList = RagUtils.listDacMeshes(spatial, null);
        Mesh[] targets = new Mesh[targetList.size()];
        targetList.toArray(targets);
        this.transformer = MySpatial.findAnimatedGeometry((Spatial)spatial);
        if (this.transformer == null) {
            this.transformer = spatial;
        }
        Map<String, VectorSet> coordsMap = RagUtils.coordsMap(targets, tempManagerMap);
        VectorSet vertexLocations = coordsMap.get("");
        this.createTorsoLink(vertexLocations, targets);
        for (String boneName : linkedBoneNames = this.listLinkedBoneNames()) {
            vertexLocations = coordsMap.get(boneName);
            this.createBoneLink(boneName, vertexLocations);
        }
        int numLinkedBones = this.countLinkedBones();
        assert (this.boneLinks.size() == numLinkedBones);
        this.boneLinkList = new ArrayList<BoneLink>(numLinkedBones);
        this.addJoints(this.torsoLink);
        assert (this.boneLinkList.size() == numLinkedBones) : this.boneLinkList.size();
        for (String boneName : attachBoneNames = this.listAttachmentBoneNames()) {
            if (skinningControl == null) {
                this.createAttachmentLink(boneName, skeletonControl, tempManagerMap);
                continue;
            }
            this.createAttachmentLink(boneName, skinningControl, tempManagerMap);
        }
        if (skinningControl == null) {
            int numBones = this.skeleton.getBoneCount();
            for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
                Bone bone = this.skeleton.getBone(boneIndex);
                MySkeleton.setLocalTransform((Bone)bone, (Transform)savedTransforms[boneIndex]);
            }
            this.skeleton.updateWorldVectors();
        } else {
            int numArmatureJoints = this.armature.getJointCount();
            for (int jointI = 0; jointI < numArmatureJoints; ++jointI) {
                Joint armatureJoint = this.armature.getJoint(jointI);
                armatureJoint.setLocalTransform(savedTransforms[jointI]);
            }
            this.armature.update();
        }
        int maxHops = this.ignoredHops();
        this.ignoreCollisions(maxHops);
        if (this.added) {
            this.addPhysics();
        }
        logger3.log(Level.FINE, "Created ragdoll.");
    }

    @Override
    public float mass(String boneName) {
        float mass;
        Validate.nonNull((Object)boneName, (String)"bone name");
        if (this.getSpatial() == null) {
            mass = super.mass(boneName);
        } else if ("".equals(boneName)) {
            PhysicsRigidBody rigidBody = this.torsoLink.getRigidBody();
            mass = rigidBody.getMass();
        } else if (this.boneLinks.containsKey(boneName)) {
            BoneLink link = this.boneLinks.get(boneName);
            PhysicsRigidBody rigidBody = link.getRigidBody();
            mass = rigidBody.getMass();
        } else {
            String msg = "No bone/torso named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        return mass;
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        Savable[] savableArray;
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.boneLinkList = capsule.readSavableArrayList(tagBoneLinkList, null);
        if (this.boneLinkList != null) {
            for (BoneLink link : this.boneLinkList) {
                String name = link.boneName();
                this.boneLinks.put(name, link);
            }
        }
        for (Savable savable : savableArray = capsule.readSavableArray(tagAttachmentLinks, (Savable[])new AttachmentLink[0])) {
            AttachmentLink link = (AttachmentLink)savable;
            String name = link.boneName();
            this.attachmentLinks.put(name, link);
        }
        this.armature = (Armature)capsule.readSavable(tagArmature, null);
        this.skeleton = (Skeleton)capsule.readSavable(tagSkeleton, null);
        this.transformer = (Spatial)capsule.readSavable(tagTransformer, null);
        this.torsoLink = (TorsoLink)capsule.readSavable(tagTorsoLink, null);
    }

    @Override
    protected void removePhysics() {
        PhysicsJoint joint;
        PhysicsRigidBody rigidBody;
        assert (this.added);
        PhysicsSpace space = this.getPhysicsSpace();
        if (this.torsoLink != null) {
            rigidBody = this.torsoLink.getRigidBody();
            space.removeCollisionObject(rigidBody);
        }
        for (BoneLink boneLink : this.boneLinks.values()) {
            rigidBody = boneLink.getRigidBody();
            space.removeCollisionObject(rigidBody);
            joint = boneLink.getJoint();
            space.removeJoint(joint);
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            if (link.isReleased()) continue;
            rigidBody = link.getRigidBody();
            space.removeCollisionObject(rigidBody);
            joint = link.getJoint();
            space.removeJoint(joint);
        }
        this.isReady = false;
    }

    @Override
    protected void removeSpatialData(Spatial spatial) {
        if (this.added) {
            this.removePhysics();
        }
        for (AttachmentLink attachmentLink : this.attachmentLinks.values()) {
            Node node;
            Joint armatureJoint = attachmentLink.getArmatureJoint();
            if (armatureJoint == null) {
                Bone bone = attachmentLink.getBone();
                node = MySkeleton.getAttachments((Bone)bone);
                MySkeleton.cancelAttachments((Bone)bone);
            } else {
                node = MySkeleton.getAttachments((Joint)armatureJoint);
                MySkeleton.cancelAttachments((Joint)armatureJoint);
            }
            node.removeFromParent();
        }
        this.attachmentLinks.clear();
        this.armature = null;
        if (this.skeleton != null) {
            MySkeleton.setUserControl((Skeleton)this.skeleton, (boolean)false);
            this.skeleton = null;
        }
        this.boneLinks.clear();
        this.boneLinkList = null;
        this.torsoLink = null;
        this.transformer = null;
    }

    @Override
    public void setAttachmentConfig(String boneName, LinkConfig config) {
        Validate.nonNull((Object)config, (String)"configuration");
        super.setAttachmentConfig(boneName, config);
        AttachmentLink link = this.attachmentLinks.get(boneName);
        if (link != null) {
            Spatial spatial = this.getSpatial();
            if (this.skeleton != null) {
                SkeletonControl skeletonControl = (SkeletonControl)spatial.getControl(SkeletonControl.class);
                String[] managerMap = this.managerMap(this.skeleton);
                this.createAttachmentLink(boneName, skeletonControl, managerMap);
            } else {
                SkinningControl skinningControl = (SkinningControl)spatial.getControl(SkinningControl.class);
                String[] managerMap = this.managerMap(this.armature);
                this.createAttachmentLink(boneName, skinningControl, managerMap);
            }
        }
    }

    @Override
    public void setAttachmentMass(String boneName, float mass) {
        Validate.positive((float)mass, (String)"mass");
        super.setAttachmentMass(boneName, mass);
        AttachmentLink link = this.attachmentLinks.get(boneName);
        if (link != null) {
            link.getRigidBody().setMass(mass);
        }
    }

    @Override
    public void setDamping(float dampingRatio) {
        Validate.nonNegative((float)dampingRatio, (String)"damping ratio");
        super.setDamping(dampingRatio);
        if (this.getSpatial() != null) {
            PhysicsRigidBody[] bodies;
            for (PhysicsRigidBody rigidBody : bodies = this.listRigidBodies()) {
                rigidBody.setDamping(dampingRatio, dampingRatio);
            }
        }
    }

    @Override
    public void setGravity(Vector3f gravity) {
        Validate.finite((Vector3f)gravity, (String)"gravity");
        super.setGravity(gravity);
        if (this.getSpatial() != null) {
            PhysicsRigidBody[] bodies;
            for (PhysicsRigidBody rigidBody : bodies = this.listRigidBodies()) {
                if (!rigidBody.isDynamic() || !rigidBody.isInWorld()) continue;
                rigidBody.setGravity(gravity);
            }
        }
    }

    @Override
    public void setJointLimits(String boneName, RangeOfMotion rom) {
        if (!this.hasBoneLink(boneName)) {
            String msg = "No linked bone named " + MyString.quote((CharSequence)boneName);
            throw new IllegalArgumentException(msg);
        }
        Validate.nonNull((Object)rom, (String)"range of motion");
        super.setJointLimits(boneName, rom);
        if (this.getSpatial() != null) {
            BoneLink boneLink = this.findBoneLink(boneName);
            PhysicsJoint joint = boneLink.getJoint();
            rom.setup(joint, false, false, false);
        }
    }

    @Override
    public void setMainBoneName(String boneName) {
        Spatial controlledSpatial = this.getSpatial();
        if (controlledSpatial != null) {
            throw new IllegalStateException("Cannot change the main bone once the Control is added to a Spatial.");
        }
        super.setMainBoneName(boneName);
    }

    @Override
    public void setMass(String boneName, float mass) {
        Validate.positive((float)mass, (String)"mass");
        super.setMass(boneName, mass);
        if (this.getSpatial() != null) {
            PhysicsRigidBody rigidBody;
            if ("".equals(boneName)) {
                rigidBody = this.torsoLink.getRigidBody();
            } else {
                BoneLink link = this.findBoneLink(boneName);
                rigidBody = link.getRigidBody();
            }
            rigidBody.setMass(mass);
        }
    }

    @Override
    protected void setPhysicsLocation(Vector3f vec) {
        this.torsoLink.getRigidBody().setPhysicsLocation(vec);
    }

    @Override
    protected void setPhysicsRotation(Quaternion quat) {
        this.torsoLink.getRigidBody().setPhysicsRotation(quat);
    }

    public void update(float tpf) {
        this.verifyAddedToSpatial("update the control");
        if (!this.isEnabled()) {
            return;
        }
        if (this.preComposer != null) {
            this.preComposer.saveArmature();
        }
        if (this.torsoLink != null) {
            this.torsoLink.update(tpf);
        }
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.update(tpf);
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            link.update(tpf);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        int count;
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        if (this.boneLinkList != null) {
            count = this.countLinkedBones();
            Savable[] savableArray = new Savable[count];
            this.boneLinkList.toArray(savableArray);
            capsule.write(savableArray, tagBoneLinkList, null);
        }
        count = this.countAttachments();
        Savable[] links = new AttachmentLink[count];
        this.attachmentLinks.values().toArray(links);
        capsule.write(links, tagAttachmentLinks, (Savable[])new AttachmentLink[0]);
        capsule.write((Savable)this.armature, tagArmature, null);
        capsule.write((Savable)this.skeleton, tagSkeleton, null);
        capsule.write((Savable)this.transformer, tagTransformer, null);
        capsule.write((Savable)this.torsoLink, tagTorsoLink, null);
    }

    @Override
    public void physicsTick(PhysicsSpace space, float timeStep) {
        assert (space == this.getPhysicsSpace());
        Validate.nonNegative((float)timeStep, (String)"time step");
        this.torsoLink.postTick();
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.postTick();
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            link.postTick();
        }
        this.isReady = true;
    }

    @Override
    public void prePhysicsTick(PhysicsSpace space, float timeStep) {
        assert (space == this.getPhysicsSpace());
        Validate.nonNegative((float)timeStep, (String)"time step");
        this.torsoLink.preTick(timeStep);
        for (BoneLink boneLink : this.boneLinkList) {
            boneLink.preTick(timeStep);
        }
        for (AttachmentLink link : this.attachmentLinks.values()) {
            link.preTick(timeStep);
        }
    }

    private void addJoints(PhysicsLink parentLink) {
        List<String> childNames = this.childNames(parentLink);
        for (String childName : childNames) {
            BoneLink childLink = this.findBoneLink(childName);
            childLink.addJoint(parentLink);
            this.boneLinkList.add(childLink);
            this.addJoints(childLink);
        }
    }

    private List<String> childNames(PhysicsLink link) {
        assert (link != null);
        String linkName = link == this.torsoLink ? "" : link.boneName();
        ArrayList<String> result = new ArrayList<String>(8);
        for (String childName : this.listLinkedBoneNames()) {
            Bone parent;
            if (this.armature == null) {
                Bone bone = this.findBone(childName);
                parent = bone.getParent();
                if (parent == null || !this.findManager(parent).equals(linkName)) continue;
                result.add(childName);
                continue;
            }
            Joint armatureJoint = this.findArmatureJoint(childName);
            parent = armatureJoint.getParent();
            if (parent == null || !this.findManager((Joint)parent).equals(linkName)) continue;
            result.add(childName);
        }
        return result;
    }

    private void createAttachmentLink(String boneName, SkeletonControl skeletonControl, String[] managerMap) {
        assert (boneName != null);
        assert (skeletonControl != null);
        assert (managerMap != null);
        Spatial attachModel = this.getAttachmentModel(boneName);
        attachModel = (Spatial)Heart.deepCopy((Object)attachModel);
        VectorSet vertexLocations = MyMesh.listVertexLocations((Spatial)attachModel, null);
        Node node = skeletonControl.getAttachmentsNode(boneName);
        node.attachChild(attachModel);
        Bone bone = this.skeleton.getBone(boneName);
        int boneIndex = this.skeleton.getBoneIndex(bone);
        String managerName = managerMap[boneIndex];
        PhysicsLink manager = managerName.equals("") ? this.torsoLink : (PhysicsLink)this.boneLinks.get(managerName);
        LinkConfig linkConfig = this.attachmentConfig(boneName);
        CenterHeuristic centerHeuristic = linkConfig.centerHeuristic();
        assert (centerHeuristic != CenterHeuristic.Joint);
        Vector3f center = centerHeuristic.center(vertexLocations, null);
        CollisionShape shape = linkConfig.createShape(transformIdentity, center, vertexLocations);
        AttachmentLink link = new AttachmentLink(this, bone, manager, attachModel, shape, linkConfig, center);
        this.attachmentLinks.put(boneName, link);
    }

    private void createAttachmentLink(String jointName, SkinningControl skinningControl, String[] managerMap) {
        assert (jointName != null);
        assert (skinningControl != null);
        assert (managerMap != null);
        Spatial attachModel = this.getAttachmentModel(jointName);
        attachModel = (Spatial)Heart.deepCopy((Object)attachModel);
        VectorSet vertexLocations = MyMesh.listVertexLocations((Spatial)attachModel, null);
        Node node = skinningControl.getAttachmentsNode(jointName);
        node.attachChild(attachModel);
        Joint joint = this.armature.getJoint(jointName);
        int jointIndex = this.armature.getJointIndex(joint);
        String managerName = managerMap[jointIndex];
        PhysicsLink manager = managerName.equals("") ? this.torsoLink : (PhysicsLink)this.boneLinks.get(managerName);
        LinkConfig linkConfig = this.attachmentConfig(jointName);
        CenterHeuristic centerHeuristic = linkConfig.centerHeuristic();
        assert (centerHeuristic != CenterHeuristic.Joint);
        Vector3f center = centerHeuristic.center(vertexLocations, null);
        CollisionShape shape = linkConfig.createShape(transformIdentity, center, vertexLocations);
        AttachmentLink link = new AttachmentLink(this, joint, manager, attachModel, shape, linkConfig, center);
        this.attachmentLinks.put(jointName, link);
    }

    private void createBoneLink(String boneName, VectorSet vertexLocations) {
        Vector3f center;
        Transform boneToMesh;
        if (vertexLocations == null || vertexLocations.numVectors() == 0) {
            String msg = String.format("No mesh vertices for linked bone %s.", MyString.quote((CharSequence)boneName));
            throw new IllegalArgumentException(msg);
        }
        Bone bone = null;
        Joint armatureJoint = null;
        if (this.skeleton != null) {
            bone = this.findBone(boneName);
            boneToMesh = MySkeleton.copyMeshTransform((Bone)bone, null);
        } else {
            armatureJoint = this.findArmatureJoint(boneName);
            boneToMesh = armatureJoint.getModelTransform();
        }
        Transform meshToBone = boneToMesh.invert();
        LinkConfig linkConfig = this.config(boneName);
        CenterHeuristic centerHeuristic = linkConfig.centerHeuristic();
        if (centerHeuristic == CenterHeuristic.Joint) {
            center = translateIdentity;
        } else {
            center = centerHeuristic.center(vertexLocations, null);
            center.subtractLocal(boneToMesh.getTranslation());
        }
        CollisionShape shape = linkConfig.createShape(meshToBone, center, vertexLocations);
        meshToBone.getTranslation().zero();
        Vector3f offset = meshToBone.transformVector(center, null);
        BoneLink link = this.skeleton != null ? new BoneLink(this, bone, shape, linkConfig, offset) : new BoneLink(this, armatureJoint, shape, linkConfig, offset);
        this.boneLinks.put(boneName, link);
    }

    private void createTorsoLink(VectorSet vertexLocations, Mesh[] meshes) {
        Transform meshToModel;
        Transform boneToMesh;
        if (vertexLocations == null || vertexLocations.numVectors() == 0) {
            throw new IllegalArgumentException("No mesh vertices for the torso. Make sure the root bone is not linked.");
        }
        Bone bone = null;
        Joint armatureJoint = null;
        String mainBoneName = this.mainBoneName();
        if (this.skeleton != null) {
            if (mainBoneName == null) {
                bone = RagUtils.findMainBone(this.skeleton, meshes);
                assert (bone.getParent() == null);
                mainBoneName = bone.getName();
                super.setMainBoneName(mainBoneName);
            } else {
                bone = this.skeleton.getBone(mainBoneName);
                if (bone == null) {
                    String q = MyString.quote((CharSequence)mainBoneName);
                    throw new IllegalStateException("Bone not found: " + q);
                }
            }
            boneToMesh = MySkeleton.copyMeshTransform((Bone)bone, null);
        } else {
            if (mainBoneName == null) {
                armatureJoint = RagUtils.findMainJoint(this.armature, meshes);
                assert (armatureJoint.getParent() == null);
                mainBoneName = armatureJoint.getName();
                super.setMainBoneName(mainBoneName);
            } else {
                armatureJoint = this.armature.getJoint(mainBoneName);
                if (armatureJoint == null) {
                    String q = MyString.quote((CharSequence)mainBoneName);
                    throw new IllegalStateException("Joint not found: " + q);
                }
            }
            boneToMesh = armatureJoint.getModelTransform();
        }
        Transform meshToBone = boneToMesh.invert();
        LinkConfig linkConfig = this.config("");
        CenterHeuristic centerHeuristic = linkConfig.centerHeuristic();
        assert (centerHeuristic != CenterHeuristic.Joint);
        Vector3f center = centerHeuristic.center(vertexLocations, null);
        center.subtractLocal(boneToMesh.getTranslation());
        CollisionShape shape = linkConfig.createShape(meshToBone, center, vertexLocations);
        meshToBone.getTranslation().zero();
        Vector3f offset = meshToBone.transformVector(center, null);
        Spatial cgm = this.getSpatial();
        if (cgm instanceof Node) {
            Transform modelToMesh = RagUtils.relativeTransform(this.transformer, (Node)cgm, null);
            meshToModel = modelToMesh.invert();
        } else {
            meshToModel = transformIdentity;
        }
        this.torsoLink = this.skeleton != null ? new TorsoLink(this, bone, shape, linkConfig, meshToModel, offset) : new TorsoLink(this, armatureJoint, shape, linkConfig, meshToModel, offset);
    }

    private void ignoreCollisions(int maxHops) {
        PhysicsRigidBody[] bodies;
        for (PhysicsRigidBody body : bodies = this.listRigidBodies()) {
            body.clearIgnoreList();
        }
        HashMap<PhysicsBody, Integer> visited = new HashMap<PhysicsBody, Integer>(bodies.length);
        for (PhysicsRigidBody body : bodies) {
            visited.clear();
            visited.put(body, maxHops);
            RagUtils.ignoreCollisions(body, body, maxHops, visited);
        }
    }

    private void sortControls(Control otherSgc) {
        assert (otherSgc != null);
        Spatial spatial = this.getSpatial();
        int dacIndex = MySpatial.findIndex((Spatial)spatial, (Control)this);
        assert (dacIndex != -1);
        int otherIndex = MySpatial.findIndex((Spatial)spatial, (Control)otherSgc);
        assert (otherIndex != -1);
        assert (dacIndex != otherIndex);
        if (dacIndex > otherIndex) {
            spatial.removeControl(otherSgc);
            spatial.addControl(otherSgc);
            dacIndex = MySpatial.findIndex((Spatial)spatial, (Control)this);
            assert (dacIndex != -1);
            otherIndex = MySpatial.findIndex((Spatial)spatial, (Control)otherSgc);
            assert (otherIndex != -1);
            assert (dacIndex < otherIndex);
        }
    }

    private void validateArmature() {
        Joint joint;
        RagUtils.validate(this.armature);
        for (String jointName : this.listLinkedBoneNames()) {
            joint = this.findArmatureJoint(jointName);
            if (joint == null) {
                String message = String.format("Linked bone %s not found in armature.", MyString.quote((CharSequence)jointName));
                throw new IllegalArgumentException(message);
            }
            if (joint.getParent() != null) continue;
            logger3.log(Level.WARNING, "Linked bone {0} is a root joint.", MyString.quote((CharSequence)jointName));
        }
        for (String jointName : this.listAttachmentBoneNames()) {
            joint = this.findArmatureJoint(jointName);
            if (joint != null) continue;
            String message = String.format("Attachment joint %s not found in armature.", MyString.quote((CharSequence)jointName));
            throw new IllegalArgumentException(message);
        }
    }

    private void validateSkeleton() {
        Bone bone;
        RagUtils.validate(this.skeleton);
        for (String boneName : this.listLinkedBoneNames()) {
            bone = this.findBone(boneName);
            if (bone == null) {
                String msg = String.format("Linked bone %s not found in skeleton.", MyString.quote((CharSequence)boneName));
                throw new IllegalArgumentException(msg);
            }
            if (bone.getParent() != null) continue;
            logger3.log(Level.WARNING, "Linked bone {0} is a root bone.", MyString.quote((CharSequence)boneName));
        }
        for (String boneName : this.listAttachmentBoneNames()) {
            bone = this.findBone(boneName);
            if (bone != null) continue;
            String msg = String.format("Attachment bone %s not found in skeleton.", MyString.quote((CharSequence)boneName));
            throw new IllegalArgumentException(msg);
        }
    }
}

