/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.RotationOrder;
import com.jme3.bullet.animation.AttachmentLink;
import com.jme3.bullet.animation.BoneLink;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.IKJoint;
import com.jme3.bullet.animation.KinematicSubmode;
import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.bullet.animation.RagUtils;
import com.jme3.bullet.animation.RagdollCollisionListener;
import com.jme3.bullet.animation.TorsoLink;
import com.jme3.bullet.collision.PhysicsCollisionEvent;
import com.jme3.bullet.collision.PhysicsCollisionListener;
import com.jme3.bullet.collision.PhysicsCollisionObject;
import com.jme3.bullet.joints.Constraint;
import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.Point2PointJoint;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationMotor;
import com.jme3.bullet.joints.motors.TranslationMotor;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.SafeArrayList;
import com.jme3.util.clone.Cloner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.MySkeleton;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;

public class DynamicAnimControl
extends DacLinks
implements PhysicsCollisionListener {
    public static final Logger logger35 = Logger.getLogger(DynamicAnimControl.class.getName());
    private static final Matrix3f matrixIdentity = new Matrix3f();
    private static final String tagCenterLocation = "centerLocation";
    private static final String tagCenterVelocity = "centerVelocity";
    private static final String tagIkJoints = "ikJoints";
    private static final String tagRagdollMass = "ragdollMass";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private ArrayList<IKJoint> ikJoints = new ArrayList(20);
    private float ragdollMass = 0.0f;
    private List<RagdollCollisionListener> collisionListeners = new SafeArrayList(RagdollCollisionListener.class);
    private Vector3f centerLocation = new Vector3f();
    private Vector3f centerVelocity = new Vector3f();

    public void addCollisionListener(RagdollCollisionListener listener) {
        Validate.nonNull((Object)listener, (String)"listener");
        this.collisionListeners.add(listener);
    }

    public void amputateSubtree(BoneLink rootLink, float blendInterval) {
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        this.verifyAddedToSpatial("change modes");
        this.blendDescendants(rootLink, KinematicSubmode.Amputated, blendInterval);
        rootLink.blendToKinematicMode(KinematicSubmode.Amputated, blendInterval);
    }

    public void animateSubtree(PhysicsLink rootLink, float blendInterval) {
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        this.verifyAddedToSpatial("change modes");
        this.blendSubtree(rootLink, KinematicSubmode.Animated, blendInterval);
    }

    public void bindSubtree(PhysicsLink rootLink, float blendInterval) {
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        this.verifyAddedToSpatial("change modes");
        this.blendSubtree(rootLink, KinematicSubmode.Bound, blendInterval);
    }

    public void blendToKinematicMode(float blendInterval, Transform endModelTransform) {
        Validate.nonNegative((float)blendInterval, (String)"blend interval");
        this.verifyAddedToSpatial("change modes");
        this.getTorsoLink().blendToKinematicMode(KinematicSubmode.Animated, blendInterval, endModelTransform);
        for (BoneLink boneLink : this.getBoneLinks()) {
            boneLink.blendToKinematicMode(KinematicSubmode.Animated, blendInterval);
        }
        for (AttachmentLink link : this.listAttachmentLinks()) {
            if (link.isReleased()) continue;
            link.blendToKinematicMode(blendInterval, null);
        }
    }

    public float centerOfMass(Vector3f storeLocation, Vector3f storeVelocity) {
        this.verifyReadyForDynamicMode("calculate the center of mass");
        this.recalculateCenter();
        if (storeLocation != null) {
            storeLocation.set(this.centerLocation);
        }
        if (storeVelocity != null) {
            storeVelocity.set(this.centerVelocity);
        }
        return this.ragdollMass;
    }

    public void dropAttachments() {
        for (AttachmentLink link : this.listAttachmentLinks()) {
            if (link.isReleased()) continue;
            Vector3f gravity = this.gravity(null);
            link.setDynamic(gravity);
            link.release();
        }
    }

    public PhysicsLink findManagerForVertex(String vertexSpecifier, Vector3f storeWorldLocation, Vector3f storeLocalLocation) {
        PhysicsLink manager;
        int vertexIndex;
        String geometryName;
        Spatial gSpatial;
        Spatial subtree;
        Validate.nonEmpty((String)vertexSpecifier, (String)"vertex specifier");
        Vector3f worldLocation = storeWorldLocation == null ? new Vector3f() : storeWorldLocation;
        String[] fields = vertexSpecifier.split("/");
        int numFields = fields.length;
        if (numFields < 2 || numFields > 3) {
            String message = "malformed vertex specifier " + MyString.quote((CharSequence)vertexSpecifier);
            throw new IllegalArgumentException(message);
        }
        Armature armature = this.getArmature();
        Skeleton skeleton = this.getSkeleton();
        if (numFields == 3) {
            String attachName = fields[2];
            if (armature == null) {
                Bone attachBone = skeleton.getBone(attachName);
                if (attachBone == null) {
                    String message = String.format("non-existent bone %s in vertex specifier", MyString.quote((CharSequence)attachName));
                    throw new IllegalArgumentException(message);
                }
                subtree = MySkeleton.getAttachments((Bone)attachBone);
                if (subtree == null) {
                    String message = String.format("no attachment to bone %s", MyString.quote((CharSequence)attachName));
                    throw new IllegalArgumentException(message);
                }
            } else {
                Joint attachArmatureJoint = armature.getJoint(attachName);
                if (attachArmatureJoint == null) {
                    String message = String.format("non-existent bone %s in vertex specifier", MyString.quote((CharSequence)attachName));
                    throw new IllegalArgumentException(message);
                }
                subtree = MySkeleton.getAttachments((Joint)attachArmatureJoint);
                if (subtree == null) {
                    String message = String.format("no attachment to bone %s", MyString.quote((CharSequence)attachName));
                    throw new IllegalArgumentException(message);
                }
            }
        } else {
            subtree = this.getSpatial();
            assert (subtree != null);
        }
        if ((gSpatial = MySpatial.findNamed((Spatial)subtree, (String)(geometryName = fields[1]))) == null) {
            String message = String.format("non-existent geometry %s in vertex specifier", MyString.quote((CharSequence)fields[1]));
            throw new IllegalArgumentException(message);
        }
        Geometry geometry = (Geometry)gSpatial;
        Mesh mesh = geometry.getMesh();
        try {
            vertexIndex = Integer.parseInt(fields[0]);
        }
        catch (NumberFormatException exception) {
            vertexIndex = -1;
        }
        int numVertices = mesh.getVertexCount();
        if (vertexIndex < 0 || vertexIndex >= numVertices) {
            String message = String.format("non-existent vertex %s in vertex specifier (legal range: 0 to %d)", MyString.quote((CharSequence)fields[0]), numVertices - 1);
            throw new IllegalArgumentException(message);
        }
        Vector3f pos = MyMesh.vertexVector3f((Mesh)mesh, (VertexBuffer.Type)VertexBuffer.Type.Position, (int)vertexIndex, null);
        if (numFields == 3) {
            assert (!MyMesh.isAnimated((Mesh)mesh));
            manager = this.findAttachmentLink(fields[2]);
            geometry.localToWorld(pos, worldLocation);
        } else {
            assert (MyMesh.isAnimated((Mesh)mesh));
            String[] managerMap = armature == null ? this.managerMap(skeleton) : this.managerMap(armature);
            String managerName = RagUtils.findManager(mesh, vertexIndex, new int[4], new float[4], managerMap);
            manager = managerName.equals("") ? this.getTorsoLink() : this.findBoneLink(managerName);
            assert (manager != null);
            Transform meshToWorld = this.meshTransform(null);
            meshToWorld.transformVector(pos, worldLocation);
        }
        if (storeLocalLocation != null) {
            Transform localToWorld = ((PhysicsLink)manager).physicsTransform(null);
            localToWorld.setScale(1.0f);
            localToWorld.transformInverseVector(worldLocation, storeLocalLocation);
        }
        return manager;
    }

    public IKJoint fixToWorld(PhysicsLink link, boolean disableForRagdoll) {
        this.verifyReadyForDynamicMode("add an IK joint");
        Transform localToWorld = link.physicsTransform(null);
        Quaternion rotToWorld = localToWorld.getRotation();
        Matrix3f worldToLocal = rotToWorld.toRotationMatrix().invertLocal();
        PhysicsRigidBody linkBody = link.getRigidBody();
        New6Dof new6dof = new New6Dof(linkBody, translateIdentity, translateIdentity, worldToLocal, matrixIdentity, RotationOrder.XYZ);
        TranslationMotor motor = new6dof.getTranslationMotor();
        Vector3f location = localToWorld.getTranslation();
        motor.set(MotorParam.LowerLimit, location);
        motor.set(MotorParam.UpperLimit, location);
        for (int axisIndex = 0; axisIndex < 3; ++axisIndex) {
            RotationMotor rotMotor = new6dof.getRotationMotor(axisIndex);
            rotMotor.setSpringEnabled(true);
            int rotDofIndex = axisIndex + 3;
            new6dof.set(MotorParam.UpperLimit, rotDofIndex, 0.0f);
            new6dof.set(MotorParam.LowerLimit, rotDofIndex, 0.0f);
        }
        IKJoint result = new IKJoint(new6dof, disableForRagdoll);
        this.ikJoints.add(result);
        this.getPhysicsSpace().addJoint(new6dof);
        assert (new6dof.getBodyB() == linkBody);
        return result;
    }

    public void freezeSubtree(PhysicsLink rootLink, boolean forceKinematic) {
        PhysicsLink[] children;
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        this.verifyAddedToSpatial("change modes");
        rootLink.freeze(forceKinematic);
        for (PhysicsLink child : children = rootLink.listChildren()) {
            this.freezeSubtree(child, forceKinematic);
        }
    }

    public double kineticEnergy() {
        double result = 0.0;
        List<PhysicsLink> links = this.listLinks(PhysicsLink.class);
        for (PhysicsLink link : links) {
            if (link.isReleased()) continue;
            PhysicsRigidBody rigidBody = link.getRigidBody();
            if (rigidBody.isDynamic()) {
                double energy = rigidBody.kineticEnergy();
                result += energy;
                continue;
            }
            result = Double.NaN;
            break;
        }
        return result;
    }

    public double mechanicalEnergy() {
        double result = 0.0;
        List<PhysicsLink> links = this.listLinks(PhysicsLink.class);
        for (PhysicsLink link : links) {
            if (link.isReleased()) continue;
            PhysicsRigidBody rigidBody = link.getRigidBody();
            if (rigidBody.isDynamic()) {
                double energy = rigidBody.mechanicalEnergy();
                result += energy;
                continue;
            }
            result = Double.NaN;
            break;
        }
        return result;
    }

    public IKJoint[] listIKJoints() {
        int numJoints = this.ikJoints.size();
        IKJoint[] result = new IKJoint[numJoints];
        this.ikJoints.toArray(result);
        return result;
    }

    public IKJoint moveToBody(PhysicsLink link, Vector3f pivotInLinkBody, PhysicsRigidBody goalBody, Vector3f pivotInGoalBody) {
        Validate.nonNull((Object)pivotInLinkBody, (String)"pivot in link body");
        Validate.nonNull((Object)goalBody, (String)"goal body");
        Validate.nonNull((Object)pivotInGoalBody, (String)"pivot in goal body");
        PhysicsRigidBody linkBody = link.getRigidBody();
        Point2PointJoint newJoint = new Point2PointJoint(linkBody, goalBody, pivotInLinkBody, pivotInGoalBody);
        IKJoint ikJoint = new IKJoint(newJoint, true);
        this.ikJoints.add(ikJoint);
        this.getPhysicsSpace().addJoint(newJoint);
        assert (newJoint.getBodyA() == linkBody);
        return ikJoint;
    }

    public IKJoint moveToWorld(PhysicsLink link, Vector3f pivotInLinkBody, Vector3f goalInWorld) {
        Validate.finite((Vector3f)pivotInLinkBody, (String)"pivot in link body");
        Validate.finite((Vector3f)goalInWorld, (String)"goal location");
        PhysicsRigidBody linkBody = link.getRigidBody();
        Point2PointJoint newJoint = new Point2PointJoint(linkBody, pivotInLinkBody, goalInWorld);
        IKJoint ikJoint = new IKJoint(newJoint, true);
        this.ikJoints.add(ikJoint);
        this.getPhysicsSpace().addJoint(newJoint);
        assert (newJoint.getBodyA() == linkBody);
        return ikJoint;
    }

    public IKJoint pinToSelf(PhysicsLink linkA, PhysicsLink linkB, Vector3f pivotInA, Vector3f pivotInB) {
        this.verifyReadyForDynamicMode("add an IK joint");
        PhysicsRigidBody bodyA = linkA.getRigidBody();
        PhysicsRigidBody bodyB = linkB.getRigidBody();
        Point2PointJoint newJoint = new Point2PointJoint(bodyA, bodyB, pivotInA, pivotInB);
        IKJoint ikJoint = new IKJoint(newJoint, true);
        this.ikJoints.add(ikJoint);
        this.getPhysicsSpace().addJoint(newJoint);
        assert (newJoint.getBodyA() == bodyA);
        assert (newJoint.getBodyB() == bodyB);
        return ikJoint;
    }

    public IKJoint pinToWorld(PhysicsLink link, boolean disableForRagdoll) {
        this.verifyReadyForDynamicMode("add an IK joint");
        PhysicsRigidBody linkBody = link.getRigidBody();
        New6Dof new6dof = new New6Dof(linkBody, translateIdentity, translateIdentity, matrixIdentity, matrixIdentity, RotationOrder.XYZ);
        TranslationMotor motor = new6dof.getTranslationMotor();
        Vector3f location = linkBody.getPhysicsLocation(null);
        motor.set(MotorParam.LowerLimit, location);
        motor.set(MotorParam.UpperLimit, location);
        IKJoint result = new IKJoint(new6dof, disableForRagdoll);
        this.ikJoints.add(result);
        this.getPhysicsSpace().addJoint(new6dof);
        assert (new6dof.getBodyB() == linkBody);
        return result;
    }

    public IKJoint pinToWorld(PhysicsLink link, Vector3f pivotInWorld) {
        Validate.nonNull((Object)pivotInWorld, (String)"pivot location");
        this.verifyReadyForDynamicMode("add an IK joint");
        PhysicsRigidBody linkBody = link.getRigidBody();
        Transform localToWorld = link.physicsTransform(null);
        localToWorld.setScale(1.0f);
        Vector3f pivotInBody = localToWorld.transformInverseVector(pivotInWorld, null);
        Point2PointJoint newJoint = new Point2PointJoint(linkBody, pivotInBody);
        IKJoint ikJoint = new IKJoint(newJoint, true);
        this.ikJoints.add(ikJoint);
        this.getPhysicsSpace().addJoint(newJoint);
        assert (newJoint.getBodyA() == linkBody);
        return ikJoint;
    }

    public void setContactResponseSubtree(PhysicsLink rootLink, boolean desiredResponse) {
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        this.verifyAddedToSpatial("change modes");
        if (!rootLink.isReleased()) {
            PhysicsLink[] children;
            PhysicsRigidBody rigidBody = rootLink.getRigidBody();
            rigidBody.setContactResponse(desiredResponse);
            for (PhysicsLink child : children = rootLink.listChildren()) {
                this.setContactResponseSubtree(child, desiredResponse);
            }
        }
    }

    public void setDynamicChain(PhysicsLink startLink, int chainLength, Vector3f uniformAcceleration, boolean lockAll) {
        if (chainLength == 0) {
            return;
        }
        Validate.positive((int)chainLength, (String)"chain length");
        Validate.nonNull((Object)startLink, (String)"start link");
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        this.verifyReadyForDynamicMode("put links into dynamic mode");
        if (startLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)startLink;
            boneLink.setDynamic(uniformAcceleration, lockAll, lockAll, lockAll);
        } else if (startLink instanceof AttachmentLink) {
            AttachmentLink attachmentLink = (AttachmentLink)startLink;
            attachmentLink.setDynamic(uniformAcceleration);
        }
        PhysicsLink parent = startLink.getParent();
        if (parent != null && chainLength > 1) {
            this.setDynamicChain(parent, chainLength - 1, uniformAcceleration, lockAll);
        }
    }

    public void setDynamicSubtree(PhysicsLink rootLink, Vector3f uniformAcceleration, boolean lockAll) {
        PhysicsLink[] children;
        Validate.nonNull((Object)rootLink, (String)"root link");
        Validate.require((rootLink.getControl() == this ? 1 : 0) != 0, (String)"link belongs to this control");
        Validate.nonNull((Object)uniformAcceleration, (String)"uniform acceleration");
        this.verifyAddedToSpatial("change modes");
        if (rootLink == this.getTorsoLink()) {
            this.getTorsoLink().setDynamic(uniformAcceleration);
        } else if (rootLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)rootLink;
            boneLink.setDynamic(uniformAcceleration, lockAll, lockAll, lockAll);
        } else {
            AttachmentLink attachmentLink = (AttachmentLink)rootLink;
            if (!attachmentLink.isReleased()) {
                attachmentLink.setDynamic(uniformAcceleration);
            }
        }
        for (PhysicsLink child : children = rootLink.listChildren()) {
            this.setDynamicSubtree(child, uniformAcceleration, lockAll);
        }
    }

    public void setKinematicMode() {
        this.verifyAddedToSpatial("set kinematic mode");
        Transform localTransform = this.getSpatial().getLocalTransform();
        this.blendToKinematicMode(0.0f, localTransform);
    }

    public void setRagdollMode() {
        this.verifyReadyForDynamicMode("set ragdoll mode");
        TorsoLink torsoLink = this.getTorsoLink();
        torsoLink.setRagdollMode();
        for (BoneLink boneLink : this.getBoneLinks()) {
            boneLink.setRagdollMode();
        }
        for (AttachmentLink link : this.listAttachmentLinks()) {
            link.setRagdollMode();
        }
        for (IKJoint joint : this.ikJoints) {
            joint.setRagdollMode();
        }
    }

    @Override
    protected void addPhysics() {
        super.addPhysics();
        PhysicsSpace space = this.getPhysicsSpace();
        space.addCollisionListener(this);
        space.addTickListener(this);
        for (IKJoint ikJoint : this.ikJoints) {
            Constraint joint = ikJoint.getPhysicsJoint();
            space.addJoint(joint);
        }
    }

    @Override
    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.ikJoints = (ArrayList)cloner.clone(this.ikJoints);
        this.collisionListeners = (List)cloner.clone(this.collisionListeners);
        this.centerLocation = (Vector3f)cloner.clone((Object)this.centerLocation);
        this.centerVelocity = (Vector3f)cloner.clone((Object)this.centerVelocity);
    }

    @Override
    public void read(JmeImporter importer) throws IOException {
        super.read(importer);
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.ikJoints = capsule.readSavableArrayList(tagIkJoints, new ArrayList(1));
        this.ragdollMass = capsule.readFloat(tagRagdollMass, 1.0f);
        this.centerLocation = (Vector3f)capsule.readSavable(tagCenterLocation, (Savable)new Vector3f());
        this.centerVelocity = (Vector3f)capsule.readSavable(tagCenterVelocity, (Savable)new Vector3f());
    }

    @Override
    protected void removePhysics() {
        super.removePhysics();
        PhysicsSpace space = this.getPhysicsSpace();
        space.removeCollisionListener(this);
        space.removeTickListener(this);
        for (IKJoint ikJoint : this.ikJoints) {
            Constraint joint = ikJoint.getPhysicsJoint();
            space.removeJoint(joint);
        }
    }

    @Override
    public void write(JmeExporter exporter) throws IOException {
        super.write(exporter);
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.writeSavableArrayList(this.ikJoints, tagIkJoints, null);
        capsule.write(this.ragdollMass, tagRagdollMass, 1.0f);
        capsule.write((Savable)this.centerLocation, tagCenterLocation, null);
        capsule.write((Savable)this.centerVelocity, tagCenterVelocity, null);
    }

    @Override
    public void collision(PhysicsCollisionEvent event) {
        DacLinks control;
        if (event.getNodeA() == null && event.getNodeB() == null) {
            return;
        }
        boolean isThisControlInvolved = false;
        PhysicsLink physicsLink = null;
        PhysicsCollisionObject otherPco = null;
        PhysicsCollisionObject pcoA = event.getObjectA();
        PhysicsCollisionObject pcoB = event.getObjectB();
        Object userA = pcoA.getUserObject();
        Object userB = pcoB.getUserObject();
        if (userA instanceof PhysicsLink) {
            physicsLink = (PhysicsLink)userA;
            control = physicsLink.getControl();
            if (control == this) {
                isThisControlInvolved = true;
            }
            otherPco = pcoB;
        }
        if (userB instanceof PhysicsLink) {
            physicsLink = (PhysicsLink)userB;
            control = physicsLink.getControl();
            if (control == this) {
                isThisControlInvolved = true;
            }
            otherPco = pcoA;
        }
        if (!isThisControlInvolved) {
            return;
        }
        float impulseThreshold = this.eventDispatchImpulseThreshold();
        if (event.getAppliedImpulse() < impulseThreshold) {
            return;
        }
        for (RagdollCollisionListener listener : this.collisionListeners) {
            listener.collide(physicsLink, otherPco, event);
        }
    }

    private void blendDescendants(PhysicsLink rootLink, KinematicSubmode submode, float blendInterval) {
        PhysicsLink[] children;
        assert (rootLink != null);
        assert (submode != null);
        assert (blendInterval >= 0.0f) : blendInterval;
        for (PhysicsLink child : children = rootLink.listChildren()) {
            if (child instanceof BoneLink) {
                BoneLink boneLink = (BoneLink)child;
                boneLink.blendToKinematicMode(submode, blendInterval);
            } else {
                AttachmentLink attachmentLink = (AttachmentLink)child;
                if (!attachmentLink.isReleased()) {
                    attachmentLink.blendToKinematicMode(blendInterval, null);
                }
            }
            this.blendDescendants(child, submode, blendInterval);
        }
    }

    private void blendSubtree(PhysicsLink rootLink, KinematicSubmode submode, float blendInterval) {
        assert (rootLink != null);
        assert (submode != null);
        assert (blendInterval >= 0.0f) : blendInterval;
        this.blendDescendants(rootLink, submode, blendInterval);
        if (rootLink == this.getTorsoLink()) {
            this.getTorsoLink().blendToKinematicMode(submode, blendInterval, null);
        } else if (rootLink instanceof BoneLink) {
            BoneLink boneLink = (BoneLink)rootLink;
            boneLink.blendToKinematicMode(submode, blendInterval);
        } else {
            AttachmentLink attachmentLink = (AttachmentLink)rootLink;
            if (!attachmentLink.isReleased()) {
                attachmentLink.blendToKinematicMode(blendInterval, null);
            }
        }
    }

    private void recalculateCenter() {
        double massSum = 0.0;
        Vector3f locationSum = new Vector3f();
        Vector3f velocitySum = new Vector3f();
        Vector3f tmpVector = new Vector3f();
        List<PhysicsLink> links = this.listLinks(PhysicsLink.class);
        for (PhysicsLink link : links) {
            if (link.isReleased()) continue;
            PhysicsRigidBody rigidBody = link.getRigidBody();
            float mass = rigidBody.getMass();
            massSum += (double)mass;
            rigidBody.getPhysicsLocation(tmpVector);
            tmpVector.multLocal(mass);
            locationSum.addLocal(tmpVector);
            link.velocity(tmpVector);
            tmpVector.multLocal(mass);
            velocitySum.addLocal(tmpVector);
        }
        float invMass = (float)(1.0 / massSum);
        locationSum.mult(invMass, this.centerLocation);
        velocitySum.mult(invMass, this.centerVelocity);
        this.ragdollMass = (float)massSum;
    }
}

