/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.animation.PhysicsLink;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;

public abstract class IKController
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(IKController.class.getName());
    private static final String tagControlledLink = "controlledLink";
    private static final String tagIsEnabled = "isEnabled";
    private boolean isEnabled;
    private PhysicsLink controlledLink;

    protected IKController() {
    }

    protected IKController(PhysicsLink controlledLink) {
        assert (controlledLink != null);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating controller for bone {0}.", MyString.quote((CharSequence)controlledLink.boneName()));
        }
        this.controlledLink = controlledLink;
        this.isEnabled = true;
    }

    public PhysicsLink getLink() {
        return this.controlledLink;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public abstract void preTick(float var1);

    public void setEnabled(boolean desiredSetting) {
        this.isEnabled = desiredSetting;
    }

    public void setRagdollMode() {
        this.isEnabled = false;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.controlledLink = (PhysicsLink)cloner.clone((Object)this.controlledLink);
    }

    public IKController jmeClone() {
        try {
            IKController clone = (IKController)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.isEnabled = capsule.readBoolean(tagIsEnabled, true);
        this.controlledLink = (PhysicsLink)capsule.readSavable(tagControlledLink, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.isEnabled, tagIsEnabled, true);
        capsule.write((Savable)this.controlledLink, tagControlledLink, null);
    }
}

