/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.joints.Constraint;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class IKJoint
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(IKJoint.class.getName());
    private static final String tagConstraint = "joint";
    private static final String tagDisableForRagdoll = "disableForRagdoll";
    private boolean disableForRagdoll;
    private Constraint constraint;

    protected IKJoint() {
    }

    public IKJoint(Constraint constraint, boolean disableForRagdoll) {
        Validate.nonNull((Object)constraint, (String)"constraint");
        this.constraint = constraint;
        this.disableForRagdoll = disableForRagdoll;
    }

    public Constraint getPhysicsJoint() {
        return this.constraint;
    }

    public boolean isDisableForRagdoll() {
        return this.disableForRagdoll;
    }

    public void setDisableForRagdoll(boolean disableForRagdoll) {
        this.disableForRagdoll = disableForRagdoll;
    }

    void setRagdollMode() {
        if (this.disableForRagdoll) {
            this.constraint.setEnabled(false);
        }
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.constraint = (Constraint)cloner.clone((Object)this.constraint);
    }

    public IKJoint jmeClone() {
        try {
            IKJoint clone = (IKJoint)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.disableForRagdoll = capsule.readBoolean(tagDisableForRagdoll, true);
        this.constraint = (Constraint)capsule.readSavable(tagConstraint, null);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.disableForRagdoll, tagDisableForRagdoll, true);
        capsule.write((Savable)this.constraint, tagConstraint, null);
    }
}

