/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Joint;
import com.jme3.animation.Bone;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.bullet.animation.IKController;
import com.jme3.bullet.animation.LinkConfig;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.util.clone.Cloner;
import com.jme3.util.clone.JmeCloneable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.minie.MyShape;

public abstract class PhysicsLink
implements JmeCloneable,
Savable {
    public static final Logger logger = Logger.getLogger(PhysicsLink.class.getName());
    private static final String tagArmatureJoint = "armatureJoint";
    private static final String tagBlendInterval = "blendInterval";
    private static final String tagBone = "bone";
    private static final String tagChildren = "children";
    private static final String tagControl = "control";
    private static final String tagIkControllers = "ikControllers";
    private static final String tagJoint = "joint";
    private static final String tagKinematicWeight = "kinematicWeight";
    private static final String tagKpTransform = "kpTransform";
    private static final String tagKpVelocity = "kpVelocity";
    private static final String tagLocalOffset = "offset";
    private static final String tagParent = "parent";
    private static final String tagRigidBody = "rigidBody";
    private ArrayList<IKController> ikControllers = new ArrayList(8);
    private ArrayList<PhysicsLink> children = new ArrayList(8);
    private Bone bone;
    private DacLinks control;
    private float blendInterval = 1.0f;
    private float density;
    private float kinematicWeight = 1.0f;
    private Joint armatureJoint;
    private PhysicsJoint joint = null;
    private PhysicsLink parent = null;
    private PhysicsRigidBody rigidBody;
    private Transform kpTransform = new Transform();
    private Vector3f kpVelocity = new Vector3f();
    private Vector3f localOffset;
    private Vector3f tmpScale = new Vector3f();

    protected PhysicsLink() {
    }

    PhysicsLink(DacLinks control, Bone bone, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        assert (control != null);
        assert (bone != null);
        assert (collisionShape != null);
        assert (linkConfig != null);
        assert (localOffset != null);
        this.control = control;
        this.bone = bone;
        this.rigidBody = this.createRigidBody(linkConfig, collisionShape);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating link for bone {0} with mass={1}", new Object[]{MyString.quote((CharSequence)bone.getName()), Float.valueOf(this.rigidBody.getMass())});
        }
        this.localOffset = localOffset.clone();
        this.updateKPTransform();
    }

    PhysicsLink(DacLinks control, Joint armatureJoint, CollisionShape collisionShape, LinkConfig linkConfig, Vector3f localOffset) {
        assert (control != null);
        assert (armatureJoint != null);
        assert (collisionShape != null);
        assert (linkConfig != null);
        assert (localOffset != null);
        this.control = control;
        this.armatureJoint = armatureJoint;
        this.rigidBody = this.createRigidBody(linkConfig, collisionShape);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating link for joint {0} with mass={1}", new Object[]{MyString.quote((CharSequence)armatureJoint.getName()), Float.valueOf(this.rigidBody.getMass())});
        }
        this.localOffset = localOffset.clone();
        this.updateKPTransform();
    }

    public void addIKController(IKController controller) {
        Validate.nonNull((Object)controller, (String)"controller");
        assert (controller.getLink() == this);
        assert (!this.ikControllers.contains(controller));
        this.ikControllers.add(controller);
    }

    public String boneName() {
        String name = this.bone != null ? this.bone.getName() : this.armatureJoint.getName();
        assert (name != null);
        return name;
    }

    public int countChildren() {
        int numChildren = this.children.size();
        return numChildren;
    }

    public float density() {
        assert (this.density > 0.0f) : this.density;
        return this.density;
    }

    public void disableAllIKControllers() {
        for (IKController controller : this.ikControllers) {
            controller.setEnabled(false);
        }
    }

    public abstract void freeze(boolean var1);

    public final Joint getArmatureJoint() {
        return this.armatureJoint;
    }

    public final Bone getBone() {
        return this.bone;
    }

    public DacLinks getControl() {
        assert (this.control != null);
        return this.control;
    }

    public PhysicsJoint getJoint() {
        return this.joint;
    }

    public PhysicsLink getParent() {
        return this.parent;
    }

    public final PhysicsRigidBody getRigidBody() {
        assert (this.rigidBody != null);
        return this.rigidBody;
    }

    public boolean isKinematic() {
        return this.kinematicWeight > 0.0f;
    }

    public boolean isReleased() {
        return false;
    }

    public float kinematicWeight() {
        assert (this.kinematicWeight >= 0.0f) : this.kinematicWeight;
        assert (this.kinematicWeight <= 1.0f) : this.kinematicWeight;
        return this.kinematicWeight;
    }

    public PhysicsLink[] listChildren() {
        int numChildren = this.children.size();
        PhysicsLink[] result = new PhysicsLink[numChildren];
        this.children.toArray(result);
        return result;
    }

    public IKController[] listIKControllers() {
        int numControllers = this.ikControllers.size();
        IKController[] result = new IKController[numControllers];
        this.ikControllers.toArray(result);
        return result;
    }

    public abstract String name();

    public Transform physicsTransform(Transform storeResult) {
        Transform result;
        Transform transform = result = storeResult == null ? new Transform() : storeResult;
        if (this.isKinematic()) {
            result.set(this.kpTransform);
        } else {
            this.rigidBody.getTransform(result);
        }
        return result;
    }

    void postRebuild(PhysicsLink oldLink) {
        assert (oldLink != null);
        assert (oldLink.getBone() == this.bone);
        if (oldLink.isKinematic()) {
            this.blendInterval = oldLink.blendInterval;
            this.kinematicWeight = oldLink.kinematicWeight();
        } else {
            this.blendInterval = 0.0f;
            this.kinematicWeight = 1.0f;
        }
    }

    void postTick() {
    }

    void preTick(float timeStep) {
        if (this.isKinematic()) {
            this.updateRigidBodyTransform();
        } else {
            for (IKController controller : this.ikControllers) {
                controller.preTick(timeStep);
            }
        }
    }

    public boolean removeIKController(IKController controller) {
        Validate.nonNull((Object)controller, (String)"controller");
        boolean success = this.ikControllers.remove(controller);
        return success;
    }

    public void setDynamic(Vector3f uniformAcceleration) {
        Validate.finite((Vector3f)uniformAcceleration, (String)"uniform acceleration");
        String desiredAction = "put " + this.name() + " into dynamic mode";
        this.control.verifyReadyForDynamicMode(desiredAction);
        this.setKinematicWeight(0.0f);
        this.rigidBody.setGravity(uniformAcceleration);
        this.rigidBody.setEnableSleep(false);
    }

    public void setRagdollMode() {
        IKController[] controllers;
        for (IKController controller : controllers = this.listIKControllers()) {
            controller.setRagdollMode();
        }
    }

    void update(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        if (this.kinematicWeight > 0.0f) {
            this.kinematicUpdate(tpf);
        } else {
            this.dynamicUpdate();
        }
    }

    Vector3f velocity(Vector3f storeResult) {
        Vector3f result;
        Vector3f vector3f = result = storeResult == null ? new Vector3f() : storeResult;
        if (this.isKinematic()) {
            result.set(this.kpVelocity);
        } else {
            assert (!this.rigidBody.isKinematic());
            this.rigidBody.getLinearVelocity(result);
        }
        return result;
    }

    protected void blendToKinematicMode(float blendInterval) {
        assert (blendInterval >= 0.0f) : blendInterval;
        this.blendInterval = blendInterval;
        this.setKinematicWeight(Float.MIN_VALUE);
    }

    protected abstract void dynamicUpdate();

    protected void kinematicUpdate(float tpf) {
        assert (tpf >= 0.0f) : tpf;
        assert (this.rigidBody.isKinematic());
        if (this.blendInterval == 0.0f) {
            this.setKinematicWeight(1.0f);
        } else {
            this.setKinematicWeight(this.kinematicWeight + tpf / this.blendInterval);
        }
        Vector3f previousLocation = this.kpTransform.getTranslation(null);
        this.updateKPTransform();
        if (tpf > 0.0f) {
            this.kpTransform.getTranslation().subtract(previousLocation, this.kpVelocity);
            this.kpVelocity.divideLocal(tpf);
        }
    }

    protected Vector3f localOffset(Vector3f storeResult) {
        Vector3f result = storeResult == null ? new Vector3f() : storeResult;
        result.set(this.localOffset);
        return result;
    }

    protected final void setJoint(PhysicsJoint joint) {
        this.joint = joint;
    }

    protected final void setParent(PhysicsLink parent) {
        assert (parent != null);
        assert (this.parent == null);
        this.parent = parent;
        parent.children.add(this);
    }

    protected void setRigidBody(PhysicsRigidBody body) {
        assert (body != null);
        assert (this.rigidBody != null);
        this.rigidBody = body;
    }

    public void cloneFields(Cloner cloner, Object original) {
        this.armatureJoint = (Joint)cloner.clone((Object)this.armatureJoint);
        this.bone = (Bone)cloner.clone((Object)this.bone);
        this.control = (DacLinks)cloner.clone((Object)this.control);
        this.ikControllers = (ArrayList)cloner.clone(this.ikControllers);
        this.children = (ArrayList)cloner.clone(this.children);
        this.joint = (PhysicsJoint)cloner.clone((Object)this.joint);
        this.parent = (PhysicsLink)cloner.clone((Object)this.parent);
        this.rigidBody = (PhysicsRigidBody)cloner.clone((Object)this.rigidBody);
        this.kpTransform = (Transform)cloner.clone((Object)this.kpTransform);
        this.kpVelocity = (Vector3f)cloner.clone((Object)this.kpVelocity);
        this.localOffset = (Vector3f)cloner.clone((Object)this.localOffset);
        this.tmpScale = (Vector3f)cloner.clone((Object)this.tmpScale);
    }

    public PhysicsLink jmeClone() {
        try {
            PhysicsLink clone = (PhysicsLink)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.ikControllers = capsule.readSavableArrayList(tagIkControllers, new ArrayList(1));
        this.children = capsule.readSavableArrayList(tagChildren, new ArrayList(1));
        this.armatureJoint = (Joint)capsule.readSavable(tagArmatureJoint, null);
        this.bone = (Bone)capsule.readSavable(tagBone, null);
        this.control = (DacLinks)capsule.readSavable(tagControl, null);
        this.blendInterval = capsule.readFloat(tagBlendInterval, 1.0f);
        this.kinematicWeight = capsule.readFloat(tagKinematicWeight, 1.0f);
        this.joint = (PhysicsJoint)capsule.readSavable(tagJoint, null);
        this.parent = (PhysicsLink)capsule.readSavable(tagParent, null);
        this.rigidBody = (PhysicsRigidBody)capsule.readSavable(tagRigidBody, null);
        this.kpTransform = (Transform)capsule.readSavable(tagKpTransform, (Savable)new Transform());
        this.kpVelocity = (Vector3f)capsule.readSavable(tagKpVelocity, (Savable)new Vector3f());
        this.localOffset = (Vector3f)capsule.readSavable(tagLocalOffset, (Savable)new Vector3f());
        this.rigidBody.setUserObject(this);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.writeSavableArrayList(this.ikControllers, tagIkControllers, null);
        capsule.writeSavableArrayList(this.children, tagChildren, null);
        capsule.write((Savable)this.armatureJoint, tagArmatureJoint, null);
        capsule.write((Savable)this.bone, tagBone, null);
        capsule.write((Savable)this.control, tagControl, null);
        capsule.write(this.blendInterval, tagBlendInterval, 1.0f);
        capsule.write(this.kinematicWeight, tagKinematicWeight, 1.0f);
        capsule.write((Savable)this.joint, tagJoint, null);
        capsule.write((Savable)this.parent, tagParent, null);
        capsule.write((Savable)this.rigidBody, tagRigidBody, null);
        capsule.write((Savable)this.kpTransform, tagKpTransform, null);
        capsule.write((Savable)this.kpVelocity, tagKpVelocity, null);
        capsule.write((Savable)this.localOffset, tagLocalOffset, null);
    }

    private PhysicsRigidBody createRigidBody(LinkConfig linkConfig, CollisionShape collisionShape) {
        assert (collisionShape != null);
        float volume = MyShape.volume(collisionShape);
        float mass = linkConfig.mass(volume);
        this.density = mass / volume;
        PhysicsRigidBody body = new PhysicsRigidBody(collisionShape, mass);
        float viscousDamping = this.control.damping();
        body.setDamping(viscousDamping, viscousDamping);
        body.setKinematic(true);
        body.setUserObject(this);
        return body;
    }

    private void setKinematicWeight(float weight) {
        boolean isKinematic;
        assert (weight >= 0.0f) : weight;
        boolean wasKinematic = this.kinematicWeight > 0.0f;
        this.kinematicWeight = weight > 1.0f ? 1.0f : weight;
        boolean bl = isKinematic = this.kinematicWeight > 0.0f;
        if (wasKinematic && !isKinematic) {
            this.rigidBody.setKinematic(false);
            this.updateRigidBodyTransform();
            this.rigidBody.setLinearVelocity(this.kpVelocity);
        } else if (isKinematic && !wasKinematic) {
            this.rigidBody.getTransform(this.kpTransform);
            this.rigidBody.getLinearVelocity(this.kpVelocity);
            this.rigidBody.setKinematic(true);
        }
    }

    private void updateKPTransform() {
        if (this.bone != null) {
            this.control.physicsTransform(this.bone, this.localOffset, this.kpTransform);
        } else {
            this.control.physicsTransform(this.armatureJoint, this.localOffset, this.kpTransform);
        }
    }

    private void updateRigidBodyTransform() {
        this.rigidBody.setPhysicsLocation(this.kpTransform.getTranslation());
        this.rigidBody.setPhysicsRotation(this.kpTransform.getRotation());
        Vector3f kpScale = this.kpTransform.getScale();
        this.rigidBody.getScale(this.tmpScale);
        if (!this.control.areWithinTolerance(kpScale, this.tmpScale)) {
            this.rigidBody.setPhysicsScale(kpScale);
        }
    }
}

