/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.bullet.animation.DacLinks;
import com.jme3.math.Transform;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.control.AbstractControl;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class PreComposer
extends AbstractControl {
    public static final Logger logger = Logger.getLogger(PreComposer.class.getName());
    private boolean haveSaved = false;
    private final DacLinks dac;
    private Transform[] savedTransforms;

    PreComposer(DacLinks dac) {
        Validate.nonNull((Object)dac, (String)"dac");
        this.dac = dac;
    }

    void saveArmature() {
        int jointIndex;
        Armature armature = this.dac.getArmature();
        int numJoints = armature.getJointCount();
        if (this.savedTransforms == null) {
            this.savedTransforms = new Transform[numJoints];
            for (jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
                this.savedTransforms[jointIndex] = new Transform();
            }
        } else assert (this.savedTransforms.length == numJoints) : numJoints;
        for (jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            Transform t = joint.getLocalTransform();
            this.savedTransforms[jointIndex].set(t);
        }
        this.haveSaved = true;
    }

    protected void controlUpdate(float tpf) {
        if (!this.haveSaved) {
            return;
        }
        Armature armature = this.dac.getArmature();
        int numJoints = armature.getJointCount();
        assert (this.savedTransforms.length == numJoints) : numJoints;
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            Transform t = this.savedTransforms[jointIndex];
            joint.setLocalTransform(t);
        }
        this.haveSaved = false;
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

