/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.objects.PhysicsBody;
import com.jme3.export.InputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Eigen3f;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.control.Control;
import com.jme3.util.SafeArrayList;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import jme3utilities.MyMesh;
import jme3utilities.MySkeleton;
import jme3utilities.MySpatial;
import jme3utilities.MyString;
import jme3utilities.Validate;
import jme3utilities.math.MyBuffer;
import jme3utilities.math.MyVector3f;
import jme3utilities.math.RectangularSolid;
import jme3utilities.math.VectorSet;
import jme3utilities.math.VectorSetUsingBuffer;

public final class RagUtils {
    private static final Logger logger = Logger.getLogger(RagUtils.class.getName());

    private RagUtils() {
    }

    public static Map<String, VectorSet> coordsMap(Mesh[] meshes, String[] managerMap) {
        Validate.nonNull((Object)managerMap, (String)"manager map");
        float[] wArray = new float[4];
        int[] iArray = new int[4];
        Vector3f bindPosition = new Vector3f();
        HashMap<String, VectorSet> coordsMap = new HashMap<String, VectorSet>(32);
        for (Mesh mesh : meshes) {
            int numVertices = mesh.getVertexCount();
            for (int vertexI = 0; vertexI < numVertices; ++vertexI) {
                String managerName = RagUtils.findManager(mesh, vertexI, iArray, wArray, managerMap);
                VectorSet set = (VectorSet)coordsMap.get(managerName);
                if (set == null) {
                    set = new VectorSetUsingBuffer(1, false);
                    coordsMap.put(managerName, set);
                }
                MyMesh.vertexVector3f((Mesh)mesh, (VertexBuffer.Type)VertexBuffer.Type.BindPosePosition, (int)vertexI, (Vector3f)bindPosition);
                set.add(bindPosition);
            }
        }
        return coordsMap;
    }

    public static Bone findMainBone(Skeleton skeleton, Mesh[] targetMeshes) {
        Bone result;
        Validate.nonNull((Object)targetMeshes, (String)"target meshes");
        Bone[] rootBones = skeleton.getRoots();
        if (rootBones.length == 1) {
            result = rootBones[0];
        } else {
            result = null;
            float[] totalWeights = RagUtils.totalWeights(targetMeshes, skeleton);
            float greatestTotalWeight = Float.NEGATIVE_INFINITY;
            for (Bone rootBone : rootBones) {
                int boneIndex = skeleton.getBoneIndex(rootBone);
                float weight = totalWeights[boneIndex];
                if (!(weight > greatestTotalWeight)) continue;
                result = rootBone;
                greatestTotalWeight = weight;
            }
        }
        return result;
    }

    static Joint findMainJoint(Armature armature, Mesh[] targetMeshes) {
        Joint result;
        Validate.nonNull((Object)targetMeshes, (String)"target meshes");
        Joint[] roots = armature.getRoots();
        if (roots.length == 1) {
            result = roots[0];
        } else {
            result = null;
            float[] totalWeights = RagUtils.totalWeights(targetMeshes, armature);
            float greatestTotalWeight = Float.NEGATIVE_INFINITY;
            for (Joint root : roots) {
                int jointIndex = root.getId();
                float weight = totalWeights[jointIndex];
                if (!(weight > greatestTotalWeight)) continue;
                result = root;
                greatestTotalWeight = weight;
            }
        }
        return result;
    }

    public static String findManager(Mesh mesh, int vertexIndex, int[] iArray, float[] wArray, String[] managerMap) {
        Validate.nonNull((Object)mesh, (String)"mesh");
        Validate.nonNegative((int)vertexIndex, (String)"vertex index");
        Validate.nonNull((Object)iArray, (String)"index array");
        Validate.nonNull((Object)wArray, (String)"weight array");
        Validate.nonNull((Object)managerMap, (String)"manager map");
        MyMesh.vertexBoneIndices((Mesh)mesh, (int)vertexIndex, (int[])iArray);
        MyMesh.vertexBoneWeights((Mesh)mesh, (int)vertexIndex, (float[])wArray);
        Map<String, Float> weightMap = RagUtils.weightMap(iArray, wArray, managerMap);
        float bestTotalWeight = Float.NEGATIVE_INFINITY;
        String bestName = null;
        for (Map.Entry<String, Float> entry : weightMap.entrySet()) {
            float totalWeight = entry.getValue().floatValue();
            if (!(totalWeight >= bestTotalWeight)) continue;
            bestTotalWeight = totalWeight;
            bestName = entry.getKey();
        }
        return bestName;
    }

    public static AbstractControl findSControl(Spatial subtree) {
        AbstractControl result = null;
        if (subtree != null) {
            List skinners = MySpatial.listControls((Spatial)subtree, SkinningControl.class, null);
            List skellers = MySpatial.listControls((Spatial)subtree, SkeletonControl.class, null);
            if (skellers.isEmpty() && skinners.size() == 1) {
                result = (AbstractControl)skinners.get(0);
            } else if (skinners.isEmpty() && skellers.size() == 1) {
                result = (AbstractControl)skellers.get(0);
            }
        }
        return result;
    }

    static void ignoreCollisions(PhysicsBody start, PhysicsBody current, int hopsRemaining, Map<PhysicsBody, Integer> visited) {
        PhysicsJoint[] joints;
        if (hopsRemaining <= 0) {
            return;
        }
        int newRemainingHops = hopsRemaining - 1;
        for (PhysicsJoint joint : joints = current.listJoints()) {
            int mostRemainingHops;
            PhysicsBody neighbor = joint.findOtherBody(current);
            if (neighbor == null || neighbor == start) continue;
            boolean visit = true;
            if (visited.containsKey(neighbor) && newRemainingHops <= (mostRemainingHops = visited.get(neighbor).intValue())) {
                visit = false;
            }
            if (!visit) continue;
            start.addToIgnoreList(neighbor);
            visited.put(neighbor, newRemainingHops);
            RagUtils.ignoreCollisions(start, neighbor, newRemainingHops, visited);
        }
    }

    static void insertAt(Spatial spatial, int index, Control control) {
        SafeArrayList controlsList;
        Field controlsField;
        int numSgcs = spatial.getNumControls();
        Validate.inRange((int)index, (String)"index", (int)0, (int)numSgcs);
        Validate.nonNull((Object)control, (String)"control");
        try {
            controlsField = Spatial.class.getDeclaredField("controls");
        }
        catch (NoSuchFieldException exception) {
            throw new RuntimeException(exception);
        }
        controlsField.setAccessible(true);
        try {
            controlsList = (SafeArrayList)controlsField.get(spatial);
        }
        catch (IllegalAccessException exception) {
            throw new RuntimeException(exception);
        }
        spatial.addControl(control);
        if (index != numSgcs) {
            boolean success = controlsList.remove((Object)control);
            assert (success);
            controlsList.add(index, (Object)control);
        }
    }

    public static List<Mesh> listDacMeshes(Spatial subtree, List<Mesh> storeResult) {
        Boolean ignore;
        ArrayList<Mesh> result;
        ArrayList<Mesh> arrayList = result = storeResult == null ? new ArrayList<Mesh>(10) : storeResult;
        if (subtree != null && (ignore = (Boolean)subtree.getUserData("JmePhysicsIgnore")) != null && ignore.booleanValue()) {
            return result;
        }
        if (subtree instanceof Geometry) {
            Geometry geometry = (Geometry)subtree;
            Mesh mesh = geometry.getMesh();
            if (MyMesh.isAnimated((Mesh)mesh) && !result.contains(mesh)) {
                result.add(mesh);
            }
        } else if (subtree instanceof Node) {
            Node node = (Node)subtree;
            List children = node.getChildren();
            for (Spatial child : children) {
                RagUtils.listDacMeshes(child, result);
            }
        }
        return result;
    }

    public static Set<PhysicsJoint> listInternalJoints(PhysicsBody ... bodies) {
        TreeSet<PhysicsJoint> result = new TreeSet<PhysicsJoint>();
        for (PhysicsBody body : bodies) {
            PhysicsJoint[] joints;
            block1: for (PhysicsJoint joint : joints = body.listJoints()) {
                PhysicsBody otherBody = joint.findOtherBody(body);
                for (PhysicsBody b : bodies) {
                    if (b != otherBody) continue;
                    result.add(joint);
                    continue block1;
                }
            }
        }
        return result;
    }

    static RectangularSolid makeRectangularSolid(VectorSet vectorSet, Vector3f scaleFactors) {
        int numVectors = vectorSet.numVectors();
        assert (numVectors > 1) : numVectors;
        Matrix3f covariance = vectorSet.covariance(null);
        Eigen3f eigen = new Eigen3f(covariance);
        Vector3f[] basis = eigen.getEigenVectors();
        Quaternion localToWorld = new Quaternion();
        localToWorld.fromAxes(basis);
        Quaternion worldToLocal = localToWorld.inverse();
        Vector3f maxima = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f minima = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f tempVector = new Vector3f();
        FloatBuffer buffer = vectorSet.toBuffer();
        buffer.rewind();
        while (buffer.hasRemaining()) {
            tempVector.x = buffer.get();
            tempVector.y = buffer.get();
            tempVector.z = buffer.get();
            worldToLocal.mult(tempVector, tempVector);
            MyVector3f.accumulateMaxima((Vector3f)maxima, (Vector3f)tempVector);
            MyVector3f.accumulateMinima((Vector3f)minima, (Vector3f)tempVector);
        }
        Vector3f center = MyVector3f.midpoint((Vector3f)minima, (Vector3f)maxima, null);
        maxima.subtractLocal(center);
        maxima.multLocal(scaleFactors);
        maxima.addLocal(center);
        minima.subtractLocal(center);
        minima.multLocal(scaleFactors);
        minima.addLocal(center);
        RectangularSolid result = new RectangularSolid(minima, maxima, localToWorld);
        return result;
    }

    public static void meshToLocal(Bone parentBone, Transform transform) {
        Quaternion msr = parentBone.getModelSpaceRotation();
        Validate.require((msr.norm() > 0.0f ? 1 : 0) != 0, (String)"non-zero parent rotation");
        Vector3f location = transform.getTranslation();
        Quaternion orientation = transform.getRotation();
        Vector3f scale = transform.getScale();
        Vector3f pmTranslate = parentBone.getModelSpacePosition();
        Quaternion pmRotInv = msr.inverse();
        Vector3f pmScale = parentBone.getModelSpaceScale();
        location.subtractLocal(pmTranslate);
        location.divideLocal(pmScale);
        pmRotInv.mult(location, location);
        scale.divideLocal(pmScale);
        pmRotInv.mult(orientation, orientation);
    }

    static void meshToLocal(Joint parent, Transform transform) {
        Transform pm = parent.getModelTransform();
        Validate.require((pm.getRotation().norm() > 0.0f ? 1 : 0) != 0, (String)"non-zero parent rotation");
        Vector3f location = transform.getTranslation();
        Quaternion orientation = transform.getRotation();
        Vector3f scale = transform.getScale();
        Vector3f pmTranslate = pm.getTranslation();
        Quaternion pmRotInv = pm.getRotation().inverse();
        Vector3f pmScale = pm.getScale();
        location.subtractLocal(pmTranslate);
        location.divideLocal(pmScale);
        pmRotInv.mult(location, location);
        scale.divideLocal(pmScale);
        pmRotInv.mult(orientation, orientation);
    }

    public static Transform[] readTransformArray(InputCapsule capsule, String fieldName) throws IOException {
        Transform[] result;
        Validate.nonNull((Object)capsule, (String)"capsule");
        Validate.nonNull((Object)fieldName, (String)"field name");
        Savable[] tmp = capsule.readSavableArray(fieldName, null);
        if (tmp == null) {
            result = null;
        } else {
            result = new Transform[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = (Transform)tmp[i];
            }
        }
        return result;
    }

    public static Transform relativeTransform(Spatial startSpatial, Node ancestorNode, Transform storeResult) {
        Validate.nonNull((Object)startSpatial, (String)"spatial");
        Validate.nonNull((Object)ancestorNode, (String)"ancestor");
        assert (startSpatial.hasAncestor(ancestorNode));
        Transform result = storeResult == null ? new Transform() : storeResult;
        result.loadIdentity();
        for (Spatial loopSpatial = startSpatial; loopSpatial != ancestorNode; loopSpatial = loopSpatial.getParent()) {
            Transform localTransform = loopSpatial.getLocalTransform();
            result.combineWithParent(localTransform);
        }
        return result;
    }

    public static void validate(Armature armature) {
        int numJoints = armature.getJointCount();
        if (numJoints < 0) {
            throw new IllegalArgumentException("Joint count is negative!");
        }
        TreeSet<String> nameSet = new TreeSet<String>();
        for (int jointIndex = 0; jointIndex < numJoints; ++jointIndex) {
            Joint joint = armature.getJoint(jointIndex);
            if (joint == null) {
                String msg = String.format("Joint %d in armature is null!", jointIndex);
                throw new IllegalArgumentException(msg);
            }
            String jointName = joint.getName();
            if (jointName == null) {
                String message = String.format("Joint %d in armature has null name!", jointIndex);
                throw new IllegalArgumentException(message);
            }
            if (jointName.equals("")) {
                String message = String.format("Joint %d in armature has a reserved name!", jointIndex);
                throw new IllegalArgumentException(message);
            }
            if (nameSet.contains(jointName)) {
                String message = "Duplicate joint name in skeleton: " + jointName;
                throw new IllegalArgumentException(message);
            }
            nameSet.add(jointName);
        }
    }

    public static void validate(Skeleton skeleton) {
        int numBones = skeleton.getBoneCount();
        if (numBones < 0) {
            throw new IllegalArgumentException("Bone count is negative!");
        }
        TreeSet<String> nameSet = new TreeSet<String>();
        for (int boneIndex = 0; boneIndex < numBones; ++boneIndex) {
            Bone bone = skeleton.getBone(boneIndex);
            if (bone == null) {
                String msg = String.format("Bone %d in skeleton is null!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            String boneName = bone.getName();
            if (boneName == null) {
                String msg = String.format("Bone %d in skeleton has null name!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            if (boneName.equals("")) {
                String msg = String.format("Bone %d in skeleton has a reserved name!", boneIndex);
                throw new IllegalArgumentException(msg);
            }
            if (nameSet.contains(boneName)) {
                String msg = "Duplicate bone name in skeleton: " + MyString.quote((CharSequence)boneName);
                throw new IllegalArgumentException(msg);
            }
            nameSet.add(boneName);
        }
    }

    public static void validate(Spatial model) {
        Validate.nonNull((Object)model, (String)"model");
        List geometries = MySpatial.listGeometries((Spatial)model);
        if (geometries.isEmpty()) {
            throw new IllegalArgumentException("No meshes in the model.");
        }
        for (Geometry geometry : geometries) {
            if (!geometry.isIgnoreTransform()) continue;
            throw new IllegalArgumentException("A model geometry ignores transforms.");
        }
    }

    private static void addWeights(Mesh mesh, float[] totalWeights) {
        assert (totalWeights != null);
        int maxWeightsPerVert = mesh.getMaxNumWeights();
        if (maxWeightsPerVert <= 0) {
            maxWeightsPerVert = 1;
        }
        assert (maxWeightsPerVert > 0) : maxWeightsPerVert;
        assert (maxWeightsPerVert <= 4) : maxWeightsPerVert;
        VertexBuffer biBuf = mesh.getBuffer(VertexBuffer.Type.BoneIndex);
        Buffer boneIndexBuffer = biBuf.getDataReadOnly();
        boneIndexBuffer.rewind();
        int numBoneIndices = boneIndexBuffer.remaining();
        assert (numBoneIndices % 4 == 0) : numBoneIndices;
        int numVertices = boneIndexBuffer.remaining() / 4;
        FloatBuffer weightBuffer = mesh.getFloatBuffer(VertexBuffer.Type.BoneWeight);
        weightBuffer.rewind();
        int numWeights = weightBuffer.remaining();
        assert (numWeights == numVertices * 4) : numWeights;
        for (int vIndex = 0; vIndex < numVertices; ++vIndex) {
            for (int wIndex = 0; wIndex < 4; ++wIndex) {
                float weight = weightBuffer.get();
                int boneIndex = MyBuffer.readIndex((Buffer)boneIndexBuffer);
                if (wIndex >= maxWeightsPerVert) continue;
                int n = boneIndex;
                totalWeights[n] = totalWeights[n] + FastMath.abs((float)weight);
            }
        }
    }

    private static float[] totalWeights(Mesh[] meshes, Armature armature) {
        Validate.nonNull((Object)meshes, (String)"meshes");
        int numBones = armature.getJointCount();
        float[] result = new float[numBones];
        for (Mesh mesh : meshes) {
            RagUtils.addWeights(mesh, result);
        }
        List joints = MySkeleton.preOrderJoints((Armature)armature);
        Collections.reverse(joints);
        for (Joint childJoint : joints) {
            int parentIndex;
            int childIndex = childJoint.getId();
            Joint parent = childJoint.getParent();
            if (parent == null) continue;
            int n = parentIndex = parent.getId();
            result[n] = result[n] + result[childIndex];
        }
        return result;
    }

    private static float[] totalWeights(Mesh[] meshes, Skeleton skeleton) {
        Validate.nonNull((Object)meshes, (String)"meshes");
        int numBones = skeleton.getBoneCount();
        float[] result = new float[numBones];
        for (Mesh mesh : meshes) {
            RagUtils.addWeights(mesh, result);
        }
        List bones = MySkeleton.preOrderBones((Skeleton)skeleton);
        Collections.reverse(bones);
        for (Bone childBone : bones) {
            int parentIndex;
            int childIndex = skeleton.getBoneIndex(childBone);
            Bone parent = childBone.getParent();
            if (parent == null) continue;
            int n = parentIndex = skeleton.getBoneIndex(parent);
            result[n] = result[n] + result[childIndex];
        }
        return result;
    }

    private static Map<String, Float> weightMap(int[] biArray, float[] bwArray, String[] managerMap) {
        assert (biArray.length == 4);
        assert (bwArray.length == 4);
        HashMap<String, Float> weightMap = new HashMap<String, Float>(4);
        for (int j = 0; j < 4; ++j) {
            int boneIndex = biArray[j];
            if (boneIndex == -1) continue;
            String managerName = managerMap[boneIndex];
            if (weightMap.containsKey(managerName)) {
                float oldWeight = ((Float)weightMap.get(managerName)).floatValue();
                float newWeight = oldWeight + bwArray[j];
                weightMap.put(managerName, Float.valueOf(newWeight));
                continue;
            }
            weightMap.put(managerName, Float.valueOf(bwArray[j]));
        }
        return weightMap;
    }
}

