/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.animation;

import com.jme3.bullet.joints.New6Dof;
import com.jme3.bullet.joints.PhysicsJoint;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.bullet.joints.motors.MotorParam;
import com.jme3.bullet.joints.motors.RotationMotor;
import com.jme3.bullet.joints.motors.RotationalLimitMotor;
import com.jme3.bullet.joints.motors.TranslationMotor;
import com.jme3.bullet.joints.motors.TranslationalLimitMotor;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Logger;
import jme3utilities.Validate;

public class RangeOfMotion
implements Savable {
    public static final Logger logger = Logger.getLogger(RangeOfMotion.class.getName());
    private static final String tagMaxX = "maxX";
    private static final String tagMaxY = "maxY";
    private static final String tagMaxZ = "maxZ";
    private static final String tagMinX = "minX";
    private static final String tagMinY = "minY";
    private static final String tagMinZ = "minZ";
    private static final Vector3f translateIdentity = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f maxMotorForces = new Vector3f(1.0E8f, 1.0E8f, 1.0E8f);
    private float maxX = 0.0f;
    private float minX = 0.0f;
    private float maxY = 0.0f;
    private float minY = 0.0f;
    private float maxZ = 0.0f;
    private float minZ = 0.0f;

    public RangeOfMotion() {
    }

    public RangeOfMotion(Vector3f angles) {
        Validate.nonNull((Object)angles, (String)"angles");
        Validate.inRange((float)angles.x, (String)"X rotation", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        Validate.inRange((float)angles.y, (String)"Y rotation", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        Validate.inRange((float)angles.z, (String)"Z rotation", (float)((float)(-Math.PI)), (float)((float)Math.PI));
        this.maxX = angles.x;
        this.minX = angles.x;
        this.maxY = angles.y;
        this.minY = angles.y;
        this.maxZ = angles.z;
        this.minZ = angles.z;
    }

    public RangeOfMotion(float maxX, float minX, float maxY, float minY, float maxZ, float minZ) {
        Validate.inRange((float)maxX, (String)"max X rotation", (float)minX, (float)((float)Math.PI));
        Validate.inRange((float)minX, (String)"min X rotation", (float)((float)(-Math.PI)), (float)maxX);
        Validate.inRange((float)maxY, (String)"max Y rotation", (float)minY, (float)((float)Math.PI));
        Validate.inRange((float)minY, (String)"min Y rotation", (float)((float)(-Math.PI)), (float)maxY);
        Validate.inRange((float)maxZ, (String)"max Z rotation", (float)minZ, (float)((float)Math.PI));
        Validate.inRange((float)minZ, (String)"min Z rotation", (float)((float)(-Math.PI)), (float)maxZ);
        this.maxX = maxX;
        this.minX = minX;
        this.maxY = maxY;
        this.minY = minY;
        this.maxZ = maxZ;
        this.minZ = minZ;
    }

    public RangeOfMotion(float maxX, float maxY, float maxZ) {
        Validate.inRange((float)maxX, (String)"max X rotation", (float)0.0f, (float)((float)Math.PI));
        Validate.inRange((float)maxY, (String)"max Y rotation", (float)0.0f, (float)((float)Math.PI));
        Validate.inRange((float)maxZ, (String)"max Z rotation", (float)0.0f, (float)((float)Math.PI));
        this.maxX = maxX;
        this.minX = -maxX;
        this.maxY = maxY;
        this.minY = -maxY;
        this.maxZ = maxZ;
        this.minZ = -maxZ;
    }

    public RangeOfMotion(float maxAngle) {
        Validate.inRange((float)this.maxX, (String)"max rotation", (float)0.0f, (float)((float)Math.PI));
        this.maxX = maxAngle;
        this.minX = -maxAngle;
        this.maxY = maxAngle;
        this.minY = -maxAngle;
        this.maxZ = maxAngle;
        this.minZ = -maxAngle;
    }

    public RangeOfMotion(int axisIndex) {
        switch (axisIndex) {
            case 0: {
                this.maxX = 1.0f;
                this.minX = -1.0f;
                break;
            }
            case 1: {
                this.maxY = 1.0f;
                this.minY = -1.0f;
                break;
            }
            case 2: {
                this.maxZ = 1.0f;
                this.minZ = -1.0f;
                break;
            }
            default: {
                throw new IllegalArgumentException("axisIndex = " + axisIndex);
            }
        }
    }

    public float getMaxRotation(int axisIndex) {
        float result;
        switch (axisIndex) {
            case 0: {
                result = this.maxX;
                break;
            }
            case 1: {
                result = this.maxY;
                break;
            }
            case 2: {
                result = this.maxZ;
                break;
            }
            default: {
                throw new IllegalArgumentException("axisIndex = " + axisIndex);
            }
        }
        return result;
    }

    public float getMinRotation(int axisIndex) {
        float result;
        switch (axisIndex) {
            case 0: {
                result = this.minX;
                break;
            }
            case 1: {
                result = this.minY;
                break;
            }
            case 2: {
                result = this.minZ;
                break;
            }
            default: {
                String message = "axisIndex = " + axisIndex;
                throw new IllegalArgumentException(message);
            }
        }
        return result;
    }

    public void setup(PhysicsJoint constraint, boolean lockX, boolean lockY, boolean lockZ) {
        if (constraint instanceof New6Dof) {
            this.setupNew6Dof((New6Dof)constraint, lockX, lockY, lockZ);
        } else {
            SixDofJoint joint = (SixDofJoint)constraint;
            this.setupJoint(joint, lockX, lockY, lockZ);
        }
    }

    public void setupJoint(SixDofJoint joint, boolean lockX, boolean lockY, boolean lockZ) {
        Validate.nonNull((Object)joint, (String)"joint");
        Vector3f lower = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f upper = new Vector3f(this.maxX, this.maxY, this.maxZ);
        RotationalLimitMotor rotX = joint.getRotationalLimitMotor(0);
        if (lockX) {
            float angle;
            lower.x = angle = rotX.getAngle();
            upper.x = angle;
        }
        rotX.setLowerLimit(lower.x);
        rotX.setUpperLimit(upper.x);
        RotationalLimitMotor rotY = joint.getRotationalLimitMotor(1);
        if (lockY) {
            float angle;
            lower.y = angle = rotY.getAngle();
            upper.y = angle;
        }
        rotY.setLowerLimit(lower.y);
        rotY.setUpperLimit(upper.y);
        RotationalLimitMotor rotZ = joint.getRotationalLimitMotor(2);
        if (lockZ) {
            float angle;
            lower.z = angle = rotZ.getAngle();
            upper.z = angle;
        }
        rotZ.setLowerLimit(lower.z);
        rotZ.setUpperLimit(upper.z);
        joint.setAngularLowerLimit(lower);
        joint.setAngularUpperLimit(upper);
        for (int i = 0; i < 3; ++i) {
            RotationalLimitMotor rot = joint.getRotationalLimitMotor(i);
            rot.setMaxMotorForce(RangeOfMotion.maxMotorForces.x);
            rot.setMaxLimitForce(10.0f * RangeOfMotion.maxMotorForces.x);
        }
        joint.setLinearLowerLimit(translateIdentity);
        joint.setLinearUpperLimit(translateIdentity);
        TranslationalLimitMotor tra = joint.getTranslationalLimitMotor();
        tra.setLowerLimit(translateIdentity);
        tra.setMaxMotorForce(maxMotorForces);
        tra.setUpperLimit(translateIdentity);
    }

    public void setupNew6Dof(New6Dof constraint, boolean lockX, boolean lockY, boolean lockZ) {
        Vector3f current = constraint.getAngles(null);
        Vector3f lower = new Vector3f(this.minX, this.minY, this.minZ);
        Vector3f upper = new Vector3f(this.maxX, this.maxY, this.maxZ);
        if (lockX) {
            lower.x = current.x;
            upper.x = current.x;
        }
        RotationMotor rotX = constraint.getRotationMotor(0);
        rotX.set(MotorParam.Equilibrium, 0.5f * (lower.x + upper.x));
        rotX.set(MotorParam.LowerLimit, lower.x);
        rotX.set(MotorParam.UpperLimit, upper.x);
        rotX.setSpringEnabled(lockX);
        if (lockY) {
            lower.y = current.y;
            upper.y = current.y;
        }
        RotationMotor rotY = constraint.getRotationMotor(1);
        rotY.set(MotorParam.Equilibrium, 0.5f * (lower.y + upper.y));
        rotY.set(MotorParam.LowerLimit, lower.y);
        rotY.set(MotorParam.UpperLimit, upper.y);
        rotY.setSpringEnabled(lockY);
        if (lockZ) {
            lower.z = current.z;
            upper.z = current.z;
        }
        RotationMotor rotZ = constraint.getRotationMotor(2);
        rotZ.set(MotorParam.Equilibrium, 0.5f * (lower.z + upper.z));
        rotZ.set(MotorParam.LowerLimit, lower.z);
        rotZ.set(MotorParam.UpperLimit, upper.z);
        rotZ.setSpringEnabled(lockZ);
        for (int i = 0; i < 3; ++i) {
            RotationMotor rot = constraint.getRotationMotor(i);
            rot.set(MotorParam.MaxMotorForce, RangeOfMotion.maxMotorForces.x);
        }
        TranslationMotor tra = constraint.getTranslationMotor();
        tra.set(MotorParam.LowerLimit, translateIdentity);
        tra.set(MotorParam.MaxMotorForce, maxMotorForces);
        tra.set(MotorParam.UpperLimit, translateIdentity);
    }

    public void read(JmeImporter importer) throws IOException {
        InputCapsule capsule = importer.getCapsule((Savable)this);
        this.maxX = capsule.readFloat(tagMaxX, 0.0f);
        this.minX = capsule.readFloat(tagMinX, 0.0f);
        this.maxY = capsule.readFloat(tagMaxY, 0.0f);
        this.minY = capsule.readFloat(tagMinY, 0.0f);
        this.maxZ = capsule.readFloat(tagMaxZ, 0.0f);
        this.minZ = capsule.readFloat(tagMinZ, 0.0f);
    }

    public void write(JmeExporter exporter) throws IOException {
        OutputCapsule capsule = exporter.getCapsule((Savable)this);
        capsule.write(this.maxX, tagMaxX, 0.0f);
        capsule.write(this.minX, tagMinX, 0.0f);
        capsule.write(this.maxY, tagMaxY, 0.0f);
        capsule.write(this.minY, tagMinY, 0.0f);
        capsule.write(this.maxZ, tagMaxZ, 0.0f);
        capsule.write(this.minZ, tagMinZ, 0.0f);
    }
}

